﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace emlakOtomasyonu
{
    public partial class frmMusterilerSatici : Form
    {
        public frmMusterilerSatici()
        {
            InitializeComponent();
        }

        sinif sinif = new sinif();

        private void temizle()
        {
            foreach (Control item in this.Controls)
                if (!(item is Label) && !(item is Button))
                    item.Text = null;
            cbAdSoyad.DropDownStyle = ComboBoxStyle.DropDownList;
            cbAdSoyad.Size = new System.Drawing.Size(119, 24);
            btnYeni.Visible = true;
        }

        private void cbAdSoyadDoldur()
        {
            cbAdSoyad.ValueMember = "id";
            cbAdSoyad.DisplayMember = "adSoyad";
            cbAdSoyad.DataSource = sinif.dataTableDoldur("musterilerSatici");
        }

        private void btnTemizle_Click(object sender, EventArgs e)
        {
            temizle();
        }

        private void btnYeni_Click(object sender, EventArgs e)
        {
            cbAdSoyad.DropDownStyle = ComboBoxStyle.DropDown;
            cbAdSoyad.Size = new System.Drawing.Size(150, 24);
            btnYeni.Visible = false;
            sinif.yardimciDegisken = Convert.ToInt16(cbAdSoyad.SelectedValue);
        }

        private void btnEkle_Click(object sender, EventArgs e)
        {
            try
            {
                if (cbAdSoyad.Text != "")
                {
                    string sorgu = "INSERT INTO musterilerSatici(adSoyad, telefon, telefon2, aciklama) VALUES (@1, @2, @3, @4)";
                    sinif.komut = new OleDbCommand(sorgu, sinif.baglanti);
                    sinif.komut.Parameters.AddWithValue("@1", cbAdSoyad.Text);
                    sinif.komut.Parameters.AddWithValue("@2", mtxtTelefon.Text);
                    sinif.komut.Parameters.AddWithValue("@3", mtxtTelefon2.Text);
                    sinif.komut.Parameters.AddWithValue("@4", txtAciklama.Text);
                    sinif.komut.ExecuteNonQuery();
                    cbAdSoyadDoldur();
                    temizle(); 
                }
                else
                    MessageBox.Show("Lütfen ad soyad girişi yapınız.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void frmMusterilerSatici_Load(object sender, EventArgs e)
        {
            try
            {
                if (sinif.baglanti.State == ConnectionState.Closed)
                    sinif.baglanti.Open();
                cbAdSoyadDoldur();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void frmMusterilerSatici_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (sinif.baglanti.State == ConnectionState.Open)
                sinif.baglanti.Close();
        }

        private void cbAdSoyad_SelectedIndexChanged(object sender, EventArgs e)
        {
            sinif.yardimciDegisken = Convert.ToInt16(cbAdSoyad.SelectedValue);
            try
            {
                string sorgu = "select * from musterilerSatici where id = " + Convert.ToInt16(cbAdSoyad.SelectedValue);
                sinif.komut = new OleDbCommand(sorgu, sinif.baglanti);
                OleDbDataReader dr = sinif.komut.ExecuteReader();
                while (dr.Read())
                {
                    mtxtTelefon.Text = dr["telefon"].ToString();
                    mtxtTelefon2.Text = dr["telefon2"].ToString();
                    txtAciklama.Text = dr["aciklama"].ToString();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btnGuncelle_Click(object sender, EventArgs e)
        {
            try
            {
                if (cbAdSoyad.Text != "")
                {
                    string sorgu = "Update musterilerSatici SET adSoyad = @1, telefon = @2, telefon2 = @3, aciklama = @4 where id = " + sinif.yardimciDegisken + "";
                    sinif.komut = new OleDbCommand(sorgu, sinif.baglanti);
                    sinif.komut.Parameters.AddWithValue("@1", cbAdSoyad.Text);
                    sinif.komut.Parameters.AddWithValue("@2", mtxtTelefon.Text);
                    sinif.komut.Parameters.AddWithValue("@3", mtxtTelefon2.Text);
                    sinif.komut.Parameters.AddWithValue("@4", txtAciklama.Text);
                    sinif.komut.ExecuteNonQuery();
                    cbAdSoyadDoldur();
                    temizle(); 
                }
                else
                    MessageBox.Show("Lütfen tüm alanları doldurduğunuzdan emin olunuz.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btnSil_Click(object sender, EventArgs e)
        {
            try
            {
                if (cbAdSoyad.Text != "")
                {
                    DialogResult silmeSorusu = MessageBox.Show("Kaydı silmek istediğinize emin misiniz?", "Kayıt Silinecek", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (silmeSorusu == DialogResult.Yes)
                    {
                        string sorgu = "Delete from musterilerSatici where id = " + Convert.ToInt16(cbAdSoyad.SelectedValue) + "";
                        sinif.komut = new OleDbCommand(sorgu, sinif.baglanti);
                        sinif.komut.ExecuteNonQuery();
                        cbAdSoyadDoldur();
                        temizle();
                        MessageBox.Show("Kayıt silinmiştir.", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
                    } 
                }
                else
                    MessageBox.Show("Lütfen silmek istediğiniz kullanıcıyı seçin.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void cbAdSoyad_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!char.IsLetter(e.KeyChar) && e.KeyChar != (char)Keys.Back && e.KeyChar != (char)Keys.Space)
                e.Handled = true;
        }
    }
}
