﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Data.OleDb;
using System.Data;

namespace emlakOtomasyonu
{
    public partial class frmArama : Form
    {
        public frmArama()
        {
            InitializeComponent();
        }

        sinif sinif = new sinif();
        frmSatilikKonut frmSatilikKonut = new frmSatilikKonut();
        frmKiralikKonut frmKiralikKonut = new frmKiralikKonut();

        private void frmArama_Load(object sender, EventArgs e)
        {
            try
            {
                if (sinif.baglanti.State == ConnectionState.Closed)
                    sinif.baglanti.Open();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void dgvDoldur(string tablo)
        {
            string sorgu = "select id, fiyat, emlakTipi, metreKare, odaSalon, ilce, binadakiKatSayisi, bulunduguKat, binaninYasi, isitma from " + tablo + " where (fiyat >= " + txtMinFiyat.Text + " and fiyat <=  " + txtMaxFiyat.Text + ") and (metrekare >= " + txtMinMetrekare.Text + " and metrekare <= " + txtMaxMetrekare.Text + ") and isitma = '" + cbIsitma.Text + "' and emlakTipi = '" + cbEmlakTipi.Text + "'";
            OleDbDataAdapter da = new OleDbDataAdapter(sorgu, sinif.baglanti);
            DataSet ds = new DataSet();
            da.Fill(ds);
            dgv.DataSource = ds.Tables[0];
            dgv.Columns["id"].Visible = false;
            dgv.Columns["fiyat"].HeaderText = "Fiyat";
            dgv.Columns["emlakTipi"].HeaderText = "Emlak Tipi";
            dgv.Columns["metreKare"].HeaderText = "Metrekare";
            dgv.Columns["odaSalon"].HeaderText = "Oda - Salon";
            dgv.Columns["ilce"].HeaderText = "İlçe";
            dgv.Columns["binadakiKatSayisi"].HeaderText = "Binadaki Kat Sayısı";
            dgv.Columns["bulunduguKat"].HeaderText = "Bulunduğu Kat";
            dgv.Columns["binaninYasi"].HeaderText = "Binanın Yaşı";
            dgv.Columns["isitma"].HeaderText = "Isıtma";
            dgv.Columns["fiyat"].DefaultCellStyle.Format = "###,###,### TL";
            dgv.Columns["emlakTipi"].Width = 130;
            dgv.Columns["metreKare"].Width = 50;
            dgv.Columns["binadakiKatSayisi"].Width = 70;
            dgv.Columns["bulunduguKat"].Width = 80;
            dgv.Columns["binaninYasi"].Width = 65;
            dgv.Columns["metreKare"].HeaderText = "m²";
            dgv.Columns["isitma"].Width = 140;
            for (int i = 0; i < dgv.Rows.Count; i++)
            {
                if (i % 2 == 0)
                    dgv.Rows[i].DefaultCellStyle.BackColor = Color.AliceBlue;
            }
            dgv.ClearSelection();
        }

        private void frmArama_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (sinif.baglanti.State == ConnectionState.Open)
                sinif.baglanti.Close();
        }

        private void btnAra_Click(object sender, EventArgs e)
        {
            try
            {
                if (rbtnSatilikKonut.Checked)
                    dgvDoldur("satilikKonut");
                else
                    dgvDoldur("kiralikKonut");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void dgv_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            if (rbtnSatilikKonut.Checked)
            {
                if (frmSatilikKonut.Created)
                {
                    frmSatilikKonut.Activate();
                    frmSatilikKonut.WindowState = FormWindowState.Normal;
                }
                else
                {
                    frmSatilikKonut = new frmSatilikKonut();
                    frmSatilikKonut.MdiParent = this.MdiParent;
                    frmSatilikKonut.Show();
                }
                frmSatilikKonut.cbIlanBasligi.SelectedValue = dgv.CurrentRow.Cells["id"].Value; 
            }
            else
            {
                if (frmKiralikKonut.Created)
                {
                    frmKiralikKonut.Activate();
                    frmKiralikKonut.WindowState = FormWindowState.Normal;
                }
                else
                {
                    frmKiralikKonut = new frmKiralikKonut();
                    frmKiralikKonut.MdiParent = this.MdiParent;
                    frmKiralikKonut.Show();
                }
                frmKiralikKonut.cbIlanBasligi.SelectedValue = dgv.CurrentRow.Cells["id"].Value; 
            }
        }

        private void txtMinFiyat_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!char.IsDigit(e.KeyChar) && e.KeyChar != (char)Keys.Back)
                e.Handled = true;
        }
    }
}
