﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace emlakOtomasyonu
{
    public partial class frmKullaniciKayit : Form
    {
        public frmKullaniciKayit()
        {
            InitializeComponent();
        }

        sinif sinif = new sinif();

        private void btnTemizle_Click(object sender, EventArgs e)
        {
            foreach (Control item in this.Controls)
                if (item is TextBox)
                    item.Text = null;
        }

        private void frmKullaniciKayit_Load(object sender, EventArgs e)
        {
            try
            {
                MessageBox.Show("Programı ilk kez çalıştırdığınız için kayıtlı kullanıcı bulunamamıştır. Lütfen kayıt olunuz.", "Bilgi", MessageBoxButtons.OK, MessageBoxIcon.Information);
                if (sinif.baglanti.State == ConnectionState.Closed)
                    sinif.baglanti.Open();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void frmKullaniciKayit_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (sinif.baglanti.State == ConnectionState.Open)
                sinif.baglanti.Close();
        }

        private void btnKaydet_Click(object sender, EventArgs e)
        {
            try
            {
                if (txtKullaniciAdi.Text != "" && txtSifre.Text != "" && txtSifre.Text != "" && txtAdSoyad.Text != "")
                {
                    if (txtSifre.Text.Length >= 6)
                    {
                        if (txtSifre.Text == txtSifreTekrar.Text)
                        {
                            if (sinif.emailRegex.IsMatch(txtEPosta.Text))
                            {
                                string sorgu = "INSERT INTO kullanici(kullaniciAdi, sifre, ePosta, adSoyad) VALUES (@1, @2, @3, @4)";
                                sinif.komut = new OleDbCommand(sorgu, sinif.baglanti);
                                sinif.komut.Parameters.AddWithValue("@1", txtKullaniciAdi.Text);
                                sinif.komut.Parameters.AddWithValue("@2", txtSifre.Text);
                                sinif.komut.Parameters.AddWithValue("@3", txtEPosta.Text);
                                sinif.komut.Parameters.AddWithValue("@4", txtAdSoyad.Text);
                                sinif.komut.ExecuteNonQuery();
                                this.Hide();
                            }
                            else
                                MessageBox.Show("E-posta adresiniz hatalı.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                        else
                            MessageBox.Show("Şifreler birbiri ile uyuşmamaktadır.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error); 
                    }
                    else
                        MessageBox.Show("Şifreniz en az 6 karakter olmalıdır.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                    MessageBox.Show("Tüm alanları doldurunuz.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error); 
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void frmKullaniciKayit_FormClosed(object sender, FormClosedEventArgs e)
        {
            Application.Exit();
        }

        private void txtKullaniciAdi_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!char.IsLetter(e.KeyChar) && e.KeyChar != (char)Keys.Back && !char.IsDigit(e.KeyChar))
                e.Handled = true;
        }
    }
}
