﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace emlakOtomasyonu
{
    public partial class frmKullanicilar : Form
    {
        public frmKullanicilar()
        {
            InitializeComponent();
        }

        sinif sinif = new sinif();

        private void cbAdSoyadDoldur()
        {
            cbKullaniciAdi.ValueMember = "id";
            cbKullaniciAdi.DisplayMember = "kullaniciAdi";
            cbKullaniciAdi.DataSource = sinif.dataTableDoldur("kullanici");
        }

        private void btnYeni_Click(object sender, EventArgs e)
        {
            cbKullaniciAdi.DropDownStyle = ComboBoxStyle.DropDown;
            cbKullaniciAdi.Size = new System.Drawing.Size(150, 24);
            btnYeni.Visible = false;
            sinif.yardimciDegisken = Convert.ToInt16(cbKullaniciAdi.SelectedValue);
        }

        private void btnTemizle_Click(object sender, EventArgs e)
        {
            temizle();
        }

        private void temizle()
        {
            foreach (Control item in this.Controls)
                if (!(item is Label) && !(item is Button))
                    item.Text = null;
            cbKullaniciAdi.DropDownStyle = ComboBoxStyle.DropDownList;
            cbKullaniciAdi.Size = new System.Drawing.Size(119, 24);
            btnYeni.Visible = true;
        }

        private void btnEkle_Click(object sender, EventArgs e)
        {
            try
            {
                if (cbKullaniciAdi.Text != "" && txtEPosta.Text != "" && txtSifre.Text != "" && txtAdSoyad.Text != "")
                {
                    if (txtSifre.Text.Length >= 6)
                    {
                        if (sinif.emailRegex.IsMatch(txtEPosta.Text))
                        {
                            string sorguKontrolKullaniciAdi = "select kullaniciAdi from kullanici where kullaniciAdi = '" + cbKullaniciAdi.Text + "'";
                            sinif.komut = new OleDbCommand(sorguKontrolKullaniciAdi, sinif.baglanti);
                            OleDbDataReader dr = sinif.komut.ExecuteReader();
                            if (!dr.Read())
                            {
                                string sorguKontrolEPosta = "select ePosta from kullanici where ePosta = '" + txtEPosta.Text + "'";
                                sinif.komut = new OleDbCommand(sorguKontrolEPosta, sinif.baglanti);
                                OleDbDataReader dr2 = sinif.komut.ExecuteReader();
                                if (!dr2.Read())
                                {
                                    string sorgu = "INSERT INTO kullanici(kullaniciAdi, sifre, ePosta, adSoyad) VALUES (@1, @2, @3, @4)";
                                    sinif.komut = new OleDbCommand(sorgu, sinif.baglanti);
                                    sinif.komut.Parameters.AddWithValue("@1", cbKullaniciAdi.Text);
                                    sinif.komut.Parameters.AddWithValue("@2", txtSifre.Text);
                                    sinif.komut.Parameters.AddWithValue("@3", txtEPosta.Text);
                                    sinif.komut.Parameters.AddWithValue("@4", txtAdSoyad.Text);
                                    sinif.komut.ExecuteNonQuery();
                                    cbAdSoyadDoldur();
                                    temizle();   
                                }
                                else
                                    MessageBox.Show("Girmiş olduğunuz e-Postaya ait kayıt bulunmaktadır.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                            }
                            else
                                MessageBox.Show("Girmiş olduğunuz kullanıcı adına ait kayıt bulunmaktadır.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                        else
                            MessageBox.Show("E-Posta adresiniz hatalı.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                    else
                        MessageBox.Show("Şifreniz en az 6 karakter olmalıdır.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                    MessageBox.Show("Lütfen tüm alanları doldurunuz.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void frmKullanicilar_Load(object sender, EventArgs e)
        {
            try
            {
                if (sinif.baglanti.State == ConnectionState.Closed)
                    sinif.baglanti.Open();
                cbAdSoyadDoldur();
                cbKullaniciAdi.SelectedIndex = 0;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void frmKullanicilar_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (sinif.baglanti.State == ConnectionState.Open)
                sinif.baglanti.Close();
        }

        private void btnSil_Click(object sender, EventArgs e)
        {
            try
            {
                if (cbKullaniciAdi.Text != "")
                {
                    DialogResult silmeSorusu = MessageBox.Show("Kaydı silmek istediğinize emin misiniz?", "Kayıt Silinecek", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (silmeSorusu == DialogResult.Yes)
                    {
                        string sorgu = "Delete from kullanici where id = " + Convert.ToInt16(cbKullaniciAdi.SelectedValue) + "";
                        sinif.komut = new OleDbCommand(sorgu, sinif.baglanti);
                        sinif.komut.ExecuteNonQuery();
                        temizle();
                        MessageBox.Show("Kayıt silinmiştir.", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    } 
                }
                else
                    MessageBox.Show("Lütfen silmek istediğiniz kullanıcıyı seçin.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void cbKullaniciAdi_SelectedIndexChanged(object sender, EventArgs e)
        {
            sinif.yardimciDegisken = Convert.ToInt16(cbKullaniciAdi.SelectedValue);
            try
            {
                string sorgu = "select * from kullanici where id = " + Convert.ToInt16(cbKullaniciAdi.SelectedValue);
                sinif.komut = new OleDbCommand(sorgu, sinif.baglanti);
                OleDbDataReader dr = sinif.komut.ExecuteReader();
                while (dr.Read())
                {
                    txtSifre.Text = dr["sifre"].ToString();
                    txtEPosta.Text = dr["ePosta"].ToString();
                    txtAdSoyad.Text = dr["adSoyad"].ToString();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btnGuncelle_Click(object sender, EventArgs e)
        {
            string kontrolKullaniciAdi = cbKullaniciAdi.Text, kontrolEPosta = txtEPosta.Text;
            try
            {
                if (cbKullaniciAdi.Text != "" && txtEPosta.Text != "" && txtSifre.Text != "" && txtAdSoyad.Text != "")
                {
                    if (txtSifre.Text.Length >= 6)
                    {
                        if (sinif.emailRegex.IsMatch(txtEPosta.Text))
                        {
                            string sorgu = "Update kullanici SET kullaniciAdi = @1, sifre = @2, ePosta = @3, adSoyad = @4 where id = " + sinif.yardimciDegisken + "";
                            sinif.komut = new OleDbCommand(sorgu, sinif.baglanti);
                            sinif.komut.Parameters.AddWithValue("@1", cbKullaniciAdi.Text);
                            sinif.komut.Parameters.AddWithValue("@2", txtSifre.Text);
                            sinif.komut.Parameters.AddWithValue("@3", txtEPosta.Text);
                            sinif.komut.Parameters.AddWithValue("@4", txtAdSoyad.Text);
                            sinif.komut.ExecuteNonQuery();
                            cbAdSoyadDoldur();
                            temizle();      
                        }
                        else
                            MessageBox.Show("E-Posta adresiniz hatalı.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                    else
                        MessageBox.Show("Şifreniz en az 6 karakter olmalıdır.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                    MessageBox.Show("Lütfen tüm alanları doldurunuz.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void cbKullaniciAdi_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!char.IsLetter(e.KeyChar) && e.KeyChar != (char)Keys.Back && !char.IsDigit(e.KeyChar))
                e.Handled = true;
        }
    }
}
