﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.OleDb;

namespace Arkadaşlarım
{
   public partial class FrmAna : Form
   {
      public FrmAna()
      {
         InitializeComponent();
      }

      static string veritabani = @"Arkadaslar.mdb";

      OleDbConnection vt_baglanti = new OleDbConnection(
         "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" 
         + veritabani + ";" +
         "Jet OLEDB:Database Password=;");

      private void FrmAna_Load(object sender, EventArgs e)
      {
         // form çalışınca arkadaşları yükle
         ArkadaslariYukle();
      }

      // arkadaş seçilince arkadaşa ait bilgiler yüklensin
      private void lstArkadaslar_SelectedIndexChanged(object sender, EventArgs e)
      {
         // önceki seçili kişinin bilgilerini temizle
         lstBilgi.Items.Clear();

         // eğer seçili kimse yoksa geri dön
         if (lstArkadaslar.SelectedItems.Count == 0) return;

         // seçili kişinin numarasını al
         ListViewItem kisi = lstArkadaslar.SelectedItems[0];
         int numara = int.Parse(kisi.SubItems[0].Text);

         // seçili kişinin bilgilerini yükle
         BilgileriYukle(numara);
      }


      // arkadaşları veritabanından yükler
      void ArkadaslariYukle()
      {
         // listeyi temizle
         lstArkadaslar.Items.Clear();

         // ÖNCE BAĞLANTIYI AÇ
         vt_baglanti.Open();

         // sorgu komutu oluştur
         OleDbCommand komut = new OleDbCommand("SELECT * FROM KISILER", vt_baglanti);

         // komutu çalıştırıp satır satır okuyacağız
         OleDbDataReader okuyucu = komut.ExecuteReader();
         while (okuyucu.Read())
         {
            ListViewItem kisi = new ListViewItem(
               new string[]{
                  okuyucu["Numara"].ToString(),
                  okuyucu["Adı"].ToString(),
                  okuyucu["Soyadı"].ToString()});

            lstArkadaslar.Items.Add(kisi);
         }

         // okuma işlemi bittikten sonra okuyucu kapanmalı
         okuyucu.Close();

         // işlemler bittikten sonra bağlantı kesilmeli
         vt_baglanti.Close();
      }

      // numarası verilmiş arkadaşın bilgilerini yükler
      void BilgileriYukle(int numara)
      {
         lstBilgi.Items.Clear();

         // bağlantıyı aç
         vt_baglanti.Open();

         string komut_satırı = "SELECT * FROM BILGILER WHERE Numara =" + numara;
         OleDbCommand komut = new OleDbCommand(komut_satırı, vt_baglanti);

         // komutu satır satır okuyacağız
         OleDbDataReader okuyucu = komut.ExecuteReader();
         while (okuyucu.Read())
         {
            ListViewItem bilgi = new ListViewItem(
               new string[]{
                  okuyucu["Numara"].ToString(),
                  okuyucu["Tip"].ToString(),
                  okuyucu["Bilgi"].ToString() });

            lstBilgi.Items.Add(bilgi);
         }

         // okuyucunun işi bitince kapat
         okuyucu.Close();

         // işlem bitin bağlantıyı kes
         vt_baglanti.Close();
      }

      private void btnArkadasEkle_Click(object sender, EventArgs e)
      {
         FrmArkadasEkleDuzenle frm = new FrmArkadasEkleDuzenle();
         frm.Ekleme = true;
         if (frm.ShowDialog() == DialogResult.OK)
         {
            // önce bağlantıyı aç
            vt_baglanti.Open();

            // insert komutu ekleme formundan gelecek
            OleDbCommand komut = new OleDbCommand(frm.SQL_Komut, vt_baglanti);

            // komutu çalıştır
            komut.ExecuteNonQuery();

            // bağlantıyı kapat
            vt_baglanti.Close();

            // ekledikten sonra arkadaşları yükle
            ArkadaslariYukle();
         }
      }

      private void btnArkadasDuzenle_Click(object sender, EventArgs e)
      {
         // eğer seçili kimse yoksa geri dön
         if (lstArkadaslar.SelectedItems.Count == 0) return;

         FrmArkadasEkleDuzenle frm = new FrmArkadasEkleDuzenle();
         frm.Ekleme = false;

         // seçili kişinin numarasını al
         ListViewItem kisi = lstArkadaslar.SelectedItems[0];

         // düzenleyecek kişinin numarasını gönder.
         frm.Numara = int.Parse(kisi.SubItems[0].Text);
         frm.Ad = kisi.SubItems[1].Text;
         frm.Soyad = kisi.SubItems[2].Text;

         if (frm.ShowDialog() == DialogResult.OK)
         {
            // önce bağlantıyı aç
            vt_baglanti.Open();

            // insert komutu ekleme formundan gelecek
            OleDbCommand komut = new OleDbCommand(frm.SQL_Komut, vt_baglanti);

            // komutu çalıştır
            komut.ExecuteNonQuery();

            // bağlantıyı kapat
            vt_baglanti.Close();

            // ekledikten sonra arkadaşları yükle
            ArkadaslariYukle();
         }
      }

      private void btnBilgiEkle_Click(object sender, EventArgs e)
      {
         FrmBilgiEkleDuzenle frm = new FrmBilgiEkleDuzenle();
         frm.Ekleme = true;
         // seçili kişinin numarasını al
         ListViewItem kisi = lstArkadaslar.SelectedItems[0];

         // düzenleyecek kişinin numarasını gönder.
         frm.Numara = int.Parse(kisi.SubItems[0].Text);

         if (frm.ShowDialog() == DialogResult.OK)
         {
            // önce bağlantıyı aç
            vt_baglanti.Open();

            // insert komutu ekleme formundan gelecek
            OleDbCommand komut = new OleDbCommand(frm.SQL_Komut, vt_baglanti);

            // komutu çalıştır
            komut.ExecuteNonQuery();

            // bağlantıyı kapat
            vt_baglanti.Close();

            // ekledikten sonra arkadaşları yükle
            BilgileriYukle(frm.Numara);
         }
      }

      private void btnBilgiDuzenle_Click(object sender, EventArgs e)
      {
         // eğer seçili kimse yoksa geri dön
         if (lstBilgi.SelectedItems.Count == 0) return;

         FrmBilgiEkleDuzenle frm = new FrmBilgiEkleDuzenle();
         frm.Ekleme = false;

         // seçili bilginin numarasını ve Tipini al
         ListViewItem kisi = lstBilgi.SelectedItems[0];

         // düzenleyecek kişinin numarasını gönder.
         frm.Numara = int.Parse(kisi.SubItems[0].Text);
         frm.Tip = kisi.SubItems[1].Text;
         frm.Bilgi = kisi.SubItems[2].Text;

         if (frm.ShowDialog() == DialogResult.OK)
         {
            // önce bağlantıyı aç
            vt_baglanti.Open();

            // insert komutu ekleme formundan gelecek
            OleDbCommand komut = new OleDbCommand(frm.SQL_Komut, vt_baglanti);

            // komutu çalıştır
            komut.ExecuteNonQuery();

            // bağlantıyı kapat
            vt_baglanti.Close();

            // ekledikten sonra arkadaşları yükle
            BilgileriYukle(frm.Numara);
         }
      }

      private void btnArkadasSil_Click(object sender, EventArgs e)
      {
         // eğer seçili kimse yoksa geri dön
         if (lstArkadaslar.SelectedItems.Count == 0) return;

         if (MessageBox.Show("Kişi Silinsin mi?", 
                             "Silmeyi Onayla", 
                             MessageBoxButtons.YesNo, 
                             MessageBoxIcon.Question) == DialogResult.Yes)
         {

            // seçili kişinin numarasını al
            ListViewItem kisi = lstArkadaslar.SelectedItems[0];

            // düzenleyecek kişinin numarasını gönder.
            int numara = int.Parse(kisi.SubItems[0].Text);

            // önce bağlantıyı aç
            vt_baglanti.Open();

            string sql_komut = "DELETE FROM KISILER WHERE Numara=" + numara;
            // insert komutu ekleme formundan gelecek
            OleDbCommand komut = new OleDbCommand(sql_komut, vt_baglanti);

            // komutu çalıştır
            komut.ExecuteNonQuery();

            // bağlantıyı kapat
            vt_baglanti.Close();

            // ekledikten sonra arkadaşları yükle
            ArkadaslariYukle();
         }
      }

      private void btnBilgiSil_Click(object sender, EventArgs e)
      {
         // eğer seçili kimse yoksa geri dön
         if (lstBilgi.SelectedItems.Count == 0) return;

         if (MessageBox.Show("Bilgi Silinsin mi?",
                             "Silmeyi Onayla",
                             MessageBoxButtons.YesNo,
                             MessageBoxIcon.Question) == DialogResult.Yes)
         {

            // seçili kişinin numarasını al
            ListViewItem bilgi = lstBilgi.SelectedItems[0];

            // düzenleyecek kişinin numarasını gönder.
            int numara = int.Parse(bilgi.SubItems[0].Text);
            string tip = bilgi.SubItems[1].Text;

            // önce bağlantıyı aç
            vt_baglanti.Open();

            string sql_komut = "DELETE FROM BILGILER WHERE Numara=" + numara+" AND Tip='"+tip+"'";
            // insert komutu ekleme formundan gelecek
            OleDbCommand komut = new OleDbCommand(sql_komut, vt_baglanti);

            // komutu çalıştır
            komut.ExecuteNonQuery();

            // bağlantıyı kapat
            vt_baglanti.Close();

            // ekledikten sonra arkadaşları yükle
            BilgileriYukle(numara);
         }

      }


   }
}
