﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Klasor_Dosya_Listeleme_Treeview
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.SelectedPath = txtklasoryolu.Text;
            DialogResult sonuc = folderBrowserDialog1.ShowDialog();
            if (sonuc == System.Windows.Forms.DialogResult.OK)
                txtklasoryolu.Text = folderBrowserDialog1.SelectedPath;
        }

        private void button2_Click(object sender, EventArgs e)
        {
           
            progressBar1.Value = 0;
          
            treeView1.Nodes.Clear();
            toolTip1.ShowAlways = true;
            if (txtklasoryolu.Text != "" && Directory.Exists(txtklasoryolu.Text))
                Klasoryukle(txtklasoryolu.Text);
            else//https://www.bilisimogretmeni.com
                MessageBox.Show("Klasör Seçin!!");
        }
        public void Klasoryukle(string Dir)
        {
            DirectoryInfo di = new DirectoryInfo(Dir);          
            progressBar1.Maximum = Directory.GetFiles(Dir, "*.*", SearchOption.AllDirectories).Length + Directory.GetDirectories(Dir, "**", SearchOption.AllDirectories).Length;
            TreeNode tds = treeView1.Nodes.Add(di.Name);
            tds.Tag = di.FullName;
            tds.StateImageIndex = 0;
            DosyaYukle(Dir, tds);//https://www.bilisimogretmeni.com
            AltKlasorYukle(Dir, tds);
        }
        private void AltKlasorYukle(string dir, TreeNode td)
        {
           
            string[] subdirectoryEntries = Directory.GetDirectories(dir);
            
            foreach (string subdirectory in subdirectoryEntries)
            {
                DirectoryInfo di = new DirectoryInfo(subdirectory);
                TreeNode tds = td.Nodes.Add(di.Name);
                tds.StateImageIndex = 0;
                tds.Tag = di.FullName;
                DosyaYukle(subdirectory, tds);
                AltKlasorYukle(subdirectory, tds);
                ListeyiGuncelle();
            }
        }
        private void DosyaYukle(string dir, TreeNode td)
        {
            string[] Files = Directory.GetFiles(dir, "*.*");          
            foreach (string file in Files)
            {
                FileInfo fi = new FileInfo(file);
                TreeNode tds = td.Nodes.Add(fi.Name);
                tds.Tag = fi.FullName;
                tds.StateImageIndex = 1;
                ListeyiGuncelle();
            }
        }

        private void ListeyiGuncelle()
        {
            if (progressBar1.Value < progressBar1.Maximum)
            {
                progressBar1.Value++;
                int percent = (int)(((double)progressBar1.Value / (double)progressBar1.Maximum) * 100);
                progressBar1.CreateGraphics().DrawString(percent.ToString() + "%", new Font("Arial", (float)8.25, FontStyle.Regular), Brushes.Black, new PointF(progressBar1.Width / 2 - 10, progressBar1.Height / 2 - 7));
                //https://www.bilisimogretmeni.com
                Application.DoEvents();
            }
        }

        private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {

        }

        private void treeView1_MouseMove(object sender, MouseEventArgs e)
        {
           
            TreeNode theNode = this.treeView1.GetNodeAt(e.X, e.Y);            
            if (theNode != null && theNode.Tag != null)
            {                
                if (theNode.Tag.ToString() != this.toolTip1.GetToolTip(this.treeView1))
                    this.toolTip1.SetToolTip(this.treeView1, theNode.Tag.ToString());
            }//https://www.bilisimogretmeni.com
            else     
            {
                this.toolTip1.SetToolTip(this.treeView1, "");
            }
        }
    }
}
