﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace SlideShowApp
{
    public partial class Form1 : Form
    {
        string Dirpath;
        int imgindex;
        public Form1()
        {
            InitializeComponent();
        }

        //1 Resimlerin geçiş süresini ayarlayabilmek için timer nesnesine
        // 1-10 arasındaki sayılar ekleniyor..
        private void Form1_Load(object sender, EventArgs e)
        {
            for (int i = 1; i < 10; i++)
            {
                comboBox1.Items.Add(i);
                comboBox1.SelectedIndex = 0;
            }//http://www.bilisimogretmeni.com/
            label2.Text = "Görüntülenen Resim Yok";
        }
        //2 folderBrowserDialog penceresi ile resimlerin olduğu klasörün seçilmesi
        // ve klasördeki resimlerin listesinin listbox'a alınması 
        private void button1_Click(object sender, EventArgs e)
        {
            DialogResult dr = folderBrowserDialog1.ShowDialog();
            if (dr != DialogResult.Cancel)
            {
                listBox1.Items.Clear();
                Dirpath = folderBrowserDialog1.SelectedPath;
                string[] files = Directory.GetFiles(Dirpath, "*.Jpg");
                foreach (string file in files)
                {
                    int pos = file.LastIndexOf("||");
                    string FName = file.Substring(pos + 1);
                    listBox1.Items.Add(FName);
                }
                listBox1.SelectedIndex = imgindex = 0;
                btnonceki.Enabled = true;
                btnsonraki.Enabled = btnshow.Enabled = true;
            }
        }
        //3 Slideshow başlaması için Timer nesnesi başlatılıyor
        // Eğer çalışıyorsada durduruluyor..
        private void btnshow_Click(object sender, EventArgs e)
        {
            if (btnshow.Text == "Slide Show")
            {
                btnshow.Text = "Durdur";
                timer1.Interval = int.Parse(comboBox1.Text) * 1000;
                timer1.Start();
                //http://www.bilisimogretmeni.com/
            }
            else
            {
                timer1.Stop();
                btnshow.Text = "Slide Show";
            }
        }
        //4 Listbox'dan seçilen eleman değiştiği anda picturebox'da gösterilecek olan
        // resmin yolu alınıp resim ve resmin ismi görüntüleniyor
        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            pictureBox1.ImageLocation = listBox1.SelectedItem.ToString ();
            string ad = listBox1.SelectedItem.ToString();
            string[] parcalar = ad.Split('\\');
            label2.Text = "Gösterilen Resim "+parcalar[parcalar.Count() - 1].ToString();          
        }
        //5 Önceki butonuna basılınca listbox'dan sıradaki resmin yolunun alınabilmesi için
        // seçili hale geliyor
        private void btnonceki_Click(object sender, EventArgs e)
        {
            if (imgindex > 0)
            {
                imgindex -= 1;
                if(imgindex ==0)
                {//http://www.bilisimogretmeni.com/
                    btnonceki .Enabled=false;
                }
                if (imgindex < listBox1.Items.Count - 1)
                    btnsonraki.Enabled = true;
                listBox1.SelectedIndex = imgindex;
            }
        }
        //6 Sonraki butonuna basılınca listbox'dan sıradaki resmin yolunun alınabilmesi için
        // seçili hale geliyor
        private void btnsonraki_Click(object sender, EventArgs e)
        {
            if (imgindex < listBox1.Items.Count - 1)
            {
                imgindex += 1;
                if (imgindex == listBox1.Items.Count - 1)
                    btnsonraki.Enabled = false;
                if (imgindex > 0)//http://www.bilisimogretmeni.com/
                btnonceki.Enabled = true;                 
                listBox1.SelectedIndex = imgindex;
            }
        }
        //7 Seçilen zaman diliminde sonraki resme geçilmesi için sonraki butonu tetikleniyor
        private void timer1_Tick(object sender, EventArgs e)
        {
            btnsonraki.PerformClick();
        }

        private void panel2_Paint(object sender, PaintEventArgs e)
        {

        }
    }
}
