<?php
/*
Sayfa Adı: Yorum Sayfası
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
if ( post_password_required() )
    return;
?>
<div class="clearfix"></div>
<div id="comments" class="comments-area">
 <?php if ('open' == $post->comment_status) : ?>
    <div id="respond" class="widget">	
			<div class="content__title">
				<h3 class="uckan-btn"><?php _e('Yorum Yap', 'geo'); ?></h3>
			</div>
		<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
		<?php else : ?>
		<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" class="comment-form" id="commentform">
			<div class="form-group">
				<div class="form-label-group">
					<textarea tabindex="100" name="comment" id="comment" class="form-control" placeholder="<?php _e('Yorumunuz', 'geo'); ?>" cols="100%" rows="5" tabindex="4"></textarea>
					<label for="comment"><?php _e('Yorumunuz', 'geo'); ?></label>
				</div>
			</div>
		<?php if ( $user_ID ) : ?>
			<div class="comment-bottom_recaptcha">
			<?php echo geoit_recaptcha('comments_form'); ?>
			</div>
			<div class="comment-bottom">
				<div class="comment-bottom--left">
					<div class="comment-bottom--avatar">
						<?php echo get_avatar( get_the_author_meta( 'ID', $user_ID ), 50 ); ?>
					</div>
					<div class="comment-bottom--account">
						<?php echo $user_identity; ?>
					</div>
				</div>
				<div class="spacer"></div>
				<div class="comment-bottom--right">
					<?php cancel_comment_reply_link( 'Cevabı İptal Et', 'geo' ); ?>
					<a class="uckan-btn uckan-btn--middle comment-logout uckan-dark" href="<?php echo wp_logout_url( get_permalink() ); ?>" title="Sign Out"><?php _e('Çıkış Yap', 'geo');?></a>
					<button name="submit" type="submit" id="submit" class="comment-submit uckan-btn uckan-btn--middle colored" tabindex="5"><?php _e('Yorumu Gönder', 'geo');?></button>
				</div>
			</div>
		<?php else : ?>	
			<div class="comment-input-group">
			
				<div class="form-group">
					<div class="form-label-group">
						<input type="text" id="author" name="author" class="form-control" placeholder="<?php _e('Adınız', 'geo'); ?>" value="<?php echo $comment_author; ?>" <?php if ($req) echo "required"; ?>>
						<label for="author"><?php _e('Adınız', 'geo'); ?> *</label>
					</div>
				</div>
			
				<div class="form-group">
					<div class="form-label-group">
						<input type="email" id="email" name="email" class="form-control" placeholder="<?php _e('E-Posta Adresiniz', 'geo'); ?>" value="<?php echo $comment_author_email; ?>" <?php if ($req) echo "required"; ?>>
						<label for="email"><?php _e('E-Posta Adresiniz', 'geo'); ?> *</label>
					</div>
				</div>
			
				<div class="form-group">
					<div class="form-label-group">
						<input type="text" id="url" name="url" class="form-control" placeholder="<?php _e('Websiteniz', 'geo'); ?>" value="<?php echo esc_attr($comment_author_url); ?>" >
						<label for="url"><?php _e('Websiteniz', 'geo'); ?></label>
					</div>
				</div>
			</div>
			<?php echo geoit_recaptcha('comments_form'); ?>
			<button tabindex="104" name="submit" type="submit" id="submit" class="comment-submit uckan-btn uckan-btn--middle" tabindex="5"><?php _e('Yorumu Gönder', 'geo'); ?></button>
			<?php if(ot_get_option('header_top_login') != 'off'): ?>
				<button type="button" class="uckan-btn uckan-btn--middle uckan-dark" data-toggle="geoit-login"><?php _e('Giriş Yap', 'geo'); ?></button>
			<?php endif; ?>
		<?php endif; ?> 
		
		<?php cancel_comment_reply_link( 'Cevabı İptal Et', 'geo' ); ?>
		<?php comment_id_fields(); ?>
		<?php do_action('comment_form', $post->ID); ?>
		 
		</form>
		<?php endif; // If registration required and not logged in ?>
	</div>
	
	<?php endif; // if you delete this the sky will fall on your head ?>
		
    <?php if ( have_comments() ) : ?> 
		<div id="comment_list" class="widget">
				<div class="content__title comment_box">
							<h3 class="uckan-btn"><?php comments_number( __('Yorumlar (0)', 'geo'), __('Yorumlar (1)', 'geo'), __('Yorumlar (%)', 'geo') ); ?><span><i class="fa fa-caret-up" aria-hidden="true"></i></span></h3>
					</div>
        <ol class="comment-list">
          <?php wp_list_comments(array('callback' => 'geo_comment')); ?>
        </ol><!-- .comment-list -->
 
        <?php
            // Are there comments to navigate through?
            if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
        ?>
        <nav class="navigation comment-navigation" role="navigation">
            <h1 class="screen-reader-text section-heading"><?php _e( 'Yorum Navigasyonu', 'geo' ); ?></h1>
            <div class="nav-previous"><?php previous_comments_link( __( 'Eski Yorumlar', 'geo' ) ); ?></div>
            <div class="nav-next"><?php next_comments_link( __( 'Yeni Yorumlar', 'geo' ) ); ?></div>
        </nav><!-- .comment-navigation -->
        <?php endif; // Check for comment navigation ?>
 
        <?php if ( ! comments_open() && get_comments_number() ) : ?>
        <p class="no-comments"><?php _e( 'Bu yazının yorum fonksiyonları kapatılmıştır.' , 'geo' ); ?></p>
        <?php endif; ?>
		</div>
    <?php endif; // have_comments() ?>
 
 
</div>