<?php

/**
 * Class Cerny_Post_Type
 *
 * @package Cerny_Post_Type
 * @subpackage WordPress
 */

class Geoit_Post_Type
{

    public function register_post_type($post_type, $post_type_title, $post_type_permalink) {
        $labels = array(
            'name'                  => _x( $post_type_title, $post_type_title.' General Name', 'cerny' ),
            'singular_name'         => _x( $post_type_title, $post_type_title.' Singular Name', 'cerny' ),
            'menu_name'             => __( $post_type_title, 'cerny' ),
            'name_admin_bar'        => __( $post_type_title, 'cerny' ),
        );
        $args = array(
            'label'                 => __( $post_type_title, 'cerny' ),
            'labels'                => $labels,
            "supports"              => array("title", "editor"),
            'taxonomies'            => array(),
            'hierarchical'          => false,
            'public'                => false,
            'show_ui'               => true,
            'show_in_menu'          => true,
            'show_in_rest'          => true,
            'menu_position'         => 5,
            'show_in_admin_bar'     => true,
            'show_in_nav_menus'     => true,
            'can_export'            => true,
            'has_archive'           => true,
            'exclude_from_search'   => false,
            'rewrite'               => array('slug' => $post_type_permalink),
            'publicly_queryable'    => true,
            'capability_type'       => 'page',
        );
        register_post_type( mb_strtolower($post_type), $args );
    }

    public function register_taxonomy($taxomony, $post_type, $taxomony_permalink) {
        $args = array(
            'hierarchical' => true,
            'show_ui' => true,
            'public' => true,
            'exclude_from_search' => true,
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => $taxomony_permalink)
        );
        register_taxonomy($taxomony, mb_strtolower($post_type), $args);
    }

    public function init() {
        add_action( 'init', [ $this, 'register_post_type' ] );
        add_action( 'init', [ $this, 'register_taxonomy' ] );
    }

}

function geoit_post_types() 
{
    $app = new Geoit_Post_Type();
    $post_types = [
        'notification' => [
            'post_type' => 'geo-notification',
            'post_type_title' => __('Bildirim', 'cerny'),
        ]
    ];
    foreach ($post_types as $post_type) {
        $app->register_post_type($post_type['post_type'], $post_type['post_type_title'], $post_type['post_type_permalink']);
        if ($post_type['taxomony'])
        $app->register_taxonomy($post_type['taxomony'], $post_type['post_type'], $post_type['taxomony_permalink']);
    }
}
add_action('init', 'geoit_post_types');