<?php
/*
 * Metaboxes
 * --------------------------
 *
 */ 

add_filter( 'geo_metaboxes', 'geo_metaboxes' );
	
function geo_metaboxes( array $metaboxes ) {
		
		$prefix = 'geo_';
		
		$metaboxes[] = array(
			'id'		 => 'review_control',
			'title'      => __('Ürün İnceleme', 'geo'),
			'pages'      => array('post'), // Post type
			'context'    => 'normal',
			'priority'   => 'high',
			'fields' => array(
				array(
					'label' => __('İncelemeyi Aktifleştir', 'geo'),
					'id'	=> $prefix . 'enable_review',
					'type'	=> 'checkbox'
				),
				array(
					'label' => __('İnceleme Kutusunun Pozisyonu', 'geo'),
					'id'	=> $prefix . 'review_position',
					'type'	=> 'select',
					'options' => array(
						'top' => 'Top',
						'bottom' => 'Bottom'
					),
					'std'	=> 'bottom'
				),
				array(
					'label' => __('İnceleme Kriteri', 'geo'),
					'id'	=> $prefix . 'rating_criteria',
					'type'	=> 'rating_criteria'
				),
				array(
					'label' => __('İnceleme Tipi', 'geo'),
					'desc'	=> __('Select the rating type', 'geo'),
					'id'	=> $prefix . 'rating_type',
					'type'	=> 'select',
					'options' => array ( 'number' => 'Number')
				),
				array(
					'label' => __('İnceleme Başlığı', 'geo'),
					'id'	=> $prefix . 'review_box_title',
					'type'	=> 'text',
					'std'	=> 'Review Overview'
				),
				array(
					'label' => __('İnceleme Açıklaması', 'geo'),
					'id'	=> $prefix . 'review_summary',
					'type'	=> 'textarea',
					'std'	=> ''
				),
			)
		);

		
	return $metaboxes;
}

add_filter( 'geo_metaboxes_manset', 'geo_metaboxes_manset' );
	
function geo_metaboxes_manset( array $metaboxes ) {
		
		$prefix = 'geo_';
		
		$metaboxes[] = array(
			'id'		 => 'review_control',
			'title'      => __('Manşet Ayarları', 'geo'),
			'pages'      => array('geoit_manset'), // Post type
			'context'    => 'normal',
			'priority'   => 'high',
			'fields' => array(
				array(
					'label' => __('Link', 'geo'),
					'id'	=> $prefix . 'manset_link',
					'type'	=> 'text',
					'std'	=> ''
				),
				array(
					'label' => __('Başlık', 'geo'),
					'id'	=> $prefix . 'manset_baslik',
					'type'	=> 'text',
					'std'	=> ''
				),
			)
		);

		
	return $metaboxes;
}

