<?php
define('geoitMEGAMENU_LOCATION', 'primary');
add_action( 'admin_enqueue_scripts', 'geoit_mega_menu_load_scripts_admin' );
add_action( 'widgets_init', 'geoit_mega_menu_widget' );
add_filter( 'walker_nav_menu_start_el', 'geoit_mega_menu_walker_nav_menu_start_el', 10, 4 );
add_filter( 'nav_menu_submenu_css_class', 'geoit_mega_menu_nav_menu_submenu_css_class', 10, 3);

function geoit_mega_menu_nav_menu_submenu_css_class( $classes, $args, $depth) {
    $a = array();
    foreach($classes as $class) {
        $a[] = 'geoit-mega-menu-'.$class;
    }
    return $classes;
}
function geoit_mega_menu_load_scripts_admin($hook) {
  wp_enqueue_script( 'geoit-mega-menu-admin-js', get_template_directory_uri() . '/assets/admin.js' );    
  wp_enqueue_style( 'geoit-mega-menu-admin-style', get_template_directory_uri() . '/assets/admin.css' );
}

function geoit_mega_menu_widget() {
    $locations = get_nav_menu_locations();
    foreach ($locations as $key => $location) {
        $menu = get_term( $location , 'nav_menu' );
        if (!$menu) return;
        if ( $items = wp_get_nav_menu_items( $menu->name ) ) {
            foreach ( $items as $item ) {
                if ( in_array( 'geoit-mega-menu', $item->classes ) ) {
                    register_sidebar( array(
                        'id'   => 'geoit-mega-menu-widget-area-' . $item->ID,
                        'name' => $item->title . ' - Mega Menu',
                        'description' => '',
                        'class' => '',
                        'before_widget' => '<div id="%1$s" class="widget %2$s">',
                        'after_widget' => "</div>\n",
                        'before_title' => '<h3 class="widgettitle">',
                        'after_title' => "</h3>\n",
                    ) );
                }
            }
        }
    }
}

function geoit_mega_menu_walker_nav_menu_start_el($item_output, $item, $depth, $args ) {
	
    if ( in_array( 'geoit-mega-menu', $item->classes ) ) {
		ob_start();
		if ( is_active_sidebar( 'geoit-mega-menu-widget-area-' . $item->ID ) ) {
            echo '<div class="geoit-mega-menu-block">';
            dynamic_sidebar( 'geoit-mega-menu-widget-area-' . $item->ID );
            echo '</div>';
        }
        $html = ob_get_contents();
        ob_end_clean();
		$item_output = $item_output.$html;
	}
	
   	return $item_output;
}