<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
		
if( ! function_exists( 'Mobile_Detect' )){
	function geo_is_mobile() {
		require_once( __DIR__ . '/Mobile_Detect.php' );
		$detect = new Mobile_Detect;
		if( $detect->isMobile() ) {
			return true;
		} else {
			return false;
		}
	}
}

if( ! function_exists( 'Mobile_Detect' )){
	function geo_is_tablet() {
		require_once( __DIR__ . '/Mobile_Detect.php' );
		$detect = new Mobile_Detect;
		if( $detect->isTablet() ) {
			return true;
		} else {
			return false;
		}
	}
}

if( ! function_exists( 'geo_mobil_close' )){
	function geo_mobil_close() { 
		echo '<div id="geo_mobil_menu">';
		echo '<button data-toggle="geo_mobil_menu" id="mobile-menu-icon" class="mobil-close"><i class="fa fa-close"></i></button>';
	}
}
if( ! function_exists( 'geo_mobil_lr' )){
	function geo_mobil_lr() { 
		$dark_theme = ot_get_option('dark_theme');
		$darktheme = ot_get_option('header_dark_mode');
		if ( get_option( 'users_can_register' ) ) {
		echo '<div class="goe_mobil_lr">';
		if ( ! is_user_logged_in() ) {
			$whatx = ot_get_option('header_top_login');
			if ( $whatx != 'off' ) {
				echo '<button class="geo_mobil_log" data-toggle="geoit-login">'.__('Giriş Yap', 'geo').'</button>';
			}
			$register_url = ot_get_option('geo-register');
			if ($register_url != '') {
				echo '<a class="geo_mobil_log whatsapp" href="'.get_page_link($register_url).'">'.__('Kayıt Ol', 'geo').'</a>';
			}
			else {
				echo '<a class="geo_mobil_log whatsapp " href="'.site_url().'/wp-login.php?action=register">'.__('Kayıt Ol', 'geo').'</a>';
			}
		}
		else {
			$current_user = wp_get_current_user();
			echo __('Hoş geldiniz', 'geo').', <span>'.$current_user->display_name.'</span>';
		}
		echo '</div>';
		}

		if (! is_user_logged_in() && $dark_theme != 'on' && $darktheme != 'off' ) {
			echo '<div class="geoit_dark_button"><i class="fa fa-flash"></i> <div class="geo-switch-button Off"><div class="geo-switch"></div></div></div>';
		}
		echo '</div>';// main div
	}
}
if( ! function_exists( 'geo_mobil_menu' )){
	function geo_mobil_menu() { 
		if ( has_nav_menu( 'geo-mobil' ) ) {
			$defaults = array(
			 'theme_location'  => 'geo-mobil',
			 'menu'            => '',
			 'container'       => false,
			 'container_class' => '',
			 'container_id'    => '',
			 'menu_class'      => 'menu-mobil',
			 'menu_id'         => '',
			 'echo'            => true,
			 'fallback_cb'     => 'wp_page_menu',
			 'before'          => '',
			 'after'           => '',
			 'link_before'     => '',
			 'link_after'      => '',
			 'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
			 'depth'           => 0,
			 'walker'          => ''
			);
			wp_nav_menu( $defaults );
		}else {
			$defaults = array(
			 'theme_location'  => 'geo-header',
			 'menu'            => '',
			 'container'       => false,
			 'container_class' => '',
			 'container_id'    => '',
			 'menu_class'      => 'menu-mobil',
			 'menu_id'         => '',
			 'echo'            => true,
			 'fallback_cb'     => 'wp_page_menu',
			 'before'          => '',
			 'after'           => '',
			 'link_before'     => '',
			 'link_after'      => '',
			 'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
			 'depth'           => 0,
			 'walker'          => ''
			);
			wp_nav_menu( $defaults );
		}
		get_search_form();
	} 
}

if( ! function_exists( 'geo_mobil_login' )){
	function geo_mobil_login() {
		$whatx = ot_get_option('header_top_login');
		if ( $whatx != 'off' ) {
			if ( is_user_logged_in() ) {
				$current_user = wp_get_current_user();
				$fav_page_url = ot_get_option('geo-favorites');
				$posting_url = ot_get_option('geo-posting');
				$settings_url = ot_get_option('geo_profile');
				$logout = wp_logout_url( home_url() );
				echo '<div class="has-login-area mobil_login_button">';
				echo '<button data-toggle="geoit_login" class="uckan_login-button"><i class="fa fa-user"></i></button>';
				echo '<div id="geoit_login" class="dropdown-content has_login">';
				echo '<ul>';

				if ( current_user_can('administrator') ) {
					echo '<li><a href="'.site_url().'/wp-admin">'.__('Admin Panel', 'geo').'</a></li>';
				}
				echo '<li><a href="'.get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ).'">'.__('Profilim', 'geo').'</a></li>';
				if ($settings_url != '') {
					echo '<li><a href="'.get_page_link($settings_url).'">'.__('Profilimi Düzenle', 'geo').'</a></li>';
				}
				else {
					echo '<li><a href="'.get_edit_user_link().'">'.__('Profilimi Düzenle', 'geo').'</a></li>';
				}
				if ($fav_page_url != '') {
					echo '<li><a href="'.get_page_link($fav_page_url).'">'.__('Favorilerim', 'geo').'</a></li>';
				}
				if ($posting_url != '') {
					echo '<li><a href="'.get_page_link($posting_url).'">'.__('Yazı Gönder', 'geo').'</a></li>';
				}
				$dark_theme = ot_get_option('dark_theme');
				$darktheme = ot_get_option('header_dark_mode');
				if ($dark_theme != 'on' && $darktheme != 'off' ) {
					echo '<div class="geoit_dark_button"><i class="fa fa-flash"></i> <div class="geo-switch-button Off"><div class="geo-switch"></div></div></div>';
				}
				echo '<li><a href="'.$logout.'">'.__('Çıkış Yap', 'geo').'</a></li>';
				echo '</ul>';
				echo '</div>';
				echo '</div>';
			}
		}
	}
}