<?php
if ( ! defined( 'ABSPATH' ) ) exit;

if( ! function_exists( 'geoit_opengraph' ) ){

	add_action( 'wp_head', 'geoit_opengraph' );
	function geoit_opengraph(){
		$og_geo = ot_get_option('geo_open_graph');
		$schema = ot_get_option('geo_schema');
		if ($og_geo != 'off') {
			if(is_single()) {
				$post = get_post();
				$categories = get_the_terms( $post->ID, 'category' );
				$cat_ID = $categories[0]->term_id;
				$option = [
					'title' =>  get_the_title(),
					'published' => get_the_time('c', $post->ID),
					'modified' => get_the_modified_date('c', $post->ID),
					'url' => get_permalink($post-> ID),
					'description' => mb_substr( strip_tags($post->post_content), 0, 200,"UTF-8" ),
					'category' => get_cat_name( $cat_ID ),
					'logo' => ot_get_option('geo-logo'),
					'image' => wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'), 
					'author' => get_the_author_meta($post->post_author), 
					'site_title' =>  get_bloginfo('name'),
					'site_desc' =>  get_bloginfo('description'),
					'site_url' =>  get_site_url(),
				];
				echo '
					<meta property="og:locale" content="tr_TR" />
					<meta property="og:site_name" content="'. $option['site_title'] .'" />
					<meta property="og:type" content="article" />
					<meta property="og:url" content="'.$option['url'].'" />
					<meta property="og:title" content="'.$option['title'].'" />
					<meta property="og:description" content="'.$option['description'].'" />
					<meta property="article:published_time" content="'.$option['published'].'" />
					<meta property="article:section" content="'.$option['category'].'" />
				';
				if (has_post_thumbnail()) {
					echo '<meta property="og:image" content="'.$option['image'][0].'" />'."\n";
				}		
			}
			elseif (is_home()) {
				$option = [
					'site_title' =>  get_bloginfo('name'),
					'site_desc' =>  get_bloginfo('description'),
					'site_url' =>  get_site_url(),
					'logo' => ot_get_option('geo-logo'),
				];
				echo '
					<meta property="og:title" content="'. $option['site_title'] .'" />
					<meta property="og:description" content="'. $option['site_desc'] .'" />
					<meta property="og:type" content="website" />
					<meta property="og:url" content="'.$option['site_url'].'" />
					<meta property="og:site_name" content="'. $option['site_title'] .'" />
				';
				if ($option['logo']) {
					echo '<meta property="og:image" content="'.$option['logo'].'" />'."\n";
				}	
			}
		}
		if ( $schema != 'off' ){
			
			if(is_single()) {
				$post = get_post();
				$categories = get_the_terms( $post->ID, 'category' );
				$cat_ID = $categories[0]->term_id;
				$option = [
					'title' =>  get_the_title(),
					'published' => get_the_time('c', $post->ID),
					'modified' => get_the_modified_date('c', $post->ID),
					'url' => get_permalink($post-> ID),
					'description' => mb_substr( strip_tags($post->post_content), 0, 200,"UTF-8" ),
					'category' => get_cat_name( $cat_ID ),
					'logo' => ot_get_option('geo-logo'),
					'image' =>wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'), 
					'author' => get_the_author_meta($post->post_author), 
					'site_title' =>  get_bloginfo('name'),
					'site_desc' =>  get_bloginfo('description'),
					'site_url' =>  get_site_url(),
				];
				$json_ld = array(
					"@context" => "http://schema.org",
					"@type" => "Article",
					"publisher" => array(
						"@type" => "Organization",
						"url" => $option['site_url'],
						"name" => $option['site_title'],
						"logo" => array(
							"@type" => "ImageObject",
							"url" => $option['logo'],	
						),
					),
					"headline" => $option['title'],
					"author" => array(
						"@type" => "Person",
						"name" => $option['author']
					),
					"datePublished" => $option['published'],
					"image" => array(
						"@type" => "ImageObject",
						"url" => $option['image'][0],	
					),
					"dateModified" =>  $option['modified'],
					"mainEntityOfPage" => $option['url'],
					"url" => $option['url'],
					"description" => $option['description']
				); ?>
				<script type='application/ld+json'>
					<?php echo json_encode( $json_ld ); ?>
				</script>
			<?php }
			elseif (is_home()) {
				$option = [
					'site_title' =>  get_bloginfo('name'),
					'site_desc' =>  get_bloginfo('description'),
					'site_url' =>  get_site_url(),
					'logo' => ot_get_option('geo-logo'),
				];
				$json_ld = array(
					"@context" => "http://schema.org",
					"@type" => "Organization",
					"url" => $option['site_url'],
					"name" => $option['site_title'],
					"logo" => array(
						"@type" => "ImageObject",
						"url" => $option['logo'],	
					),
				); ?>
				<script type='application/ld+json'>
					<?php echo json_encode( $json_ld ); ?>
				</script>
				<script type='application/ld+json'>{"@context":"http://schema.org","@type":"WebSite","url":"<?php echo $option['site_url']; ?>/","name":"<?php echo $option['site_url']; ?>","potentialAction":{"@type":"SearchAction","target":"<?php echo $option['site_url']; ?>?s={search_term_string}","query-input":"required name=search_term_string"}}</script>
			<?php } 
		}
	}
}