(function() {
    tinymce.PluginManager.add('sp_add_shortcode_button', function( editor, url ) {
        editor.addButton( 'sp_add_shortcode_button', {
            icon: 'shortcodes-icon',
            type: 'menubutton',
            menu: [
                {
					text: 'Button',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Button',
							body: [
								{
									type: 'listbox',
									name: 'ButtonStyle',
									label: 'Style',
									'values': [
										{text: 'Normal', value: ''},
										{text: 'Circle', value: 'uckan-btn--fab'},
										{text: 'Circle + İcon', value: 'uckan-btn--icon'},
									]
								},
								{
									type: 'listbox',
									name: 'ButtonColor',
									label: 'Color',
									'values': [
										{text: 'Red', value: 'uckan-btn--red'},
										{text: 'Blue', value: 'uckan-btn--blue'},
										{text: 'Green', value: 'uckan-btn--green'},
										{text: 'White', value: ''},
									]
								},
								{
									type: 'listbox',
									name: 'ButtonSize',
									label: 'Boyut',
									'values': [
										{text: 'Small', value: 'uckan-btn--small'},
										{text: 'Medium', value: 'uckan-btn--middle'},
										{text: 'Big', value: ''},
									]
								},
								{
									type: 'textbox',
									name: 'ButtonLink',
									label: 'Link',
									minWidth: 300,
									value: 'http://'
								},
								{
									type: 'textbox',
									name: 'ButtonText',
									label: 'Text',
									value: ''
								},
								{
									type: 'textbox',
									name: 'ButtonIcon',
									label: 'Ikon (use full Font Awesome name):',
									value: ''
								},
								{
									type: 'checkbox',
									name: 'ButtonTarget',
									label: 'Yeni Sekmede Aç',
									value: 'blank',
								}

							],
							onsubmit: function( e ) {
								editor.insertContent( '[button style="' + e.data.ButtonStyle + '" color="' + e.data.ButtonColor + '" size="' + e.data.ButtonSize + '" link="' + e.data.ButtonLink + '" icon="' + e.data.ButtonIcon + '" target="' + e.data.ButtonTarget + '"]'+ e.data.ButtonText +'[/button]');
							}
						});
					}
				},
				{
								text: 'Reklam',
								onclick: function() {
									editor.windowManager.open( {
										title: 'Kısakod Reklam',
										body: [
											{
												type: 'textbox',
												name: 'shortcodeAd',
												label: 'Kısakod Reklam',
												value: '[geo_ad]'
											},
									],
										onsubmit: function( e ) {
										editor.insertContent( '[geo_ad]');
										}
									});
								}
							},
				// {
								// text: 'Abonelik Formu',
								// onclick: function() {
									// editor.windowManager.open( {
										// title: 'Abonelik Formu',
										// body: [
											// {
												// type: 'textbox',
												// name: 'shortcodeAd',
												// label: 'Abone Ol',
												// value: '[widget widget_name="PT_Mailchimp_Subscribe"]'
											// },
									// ],
										// onsubmit: function( e ) {
										// editor.insertContent( '[widget widget_name="PT_Mailchimp_Subscribe"]');
										// }
									// });
								// }
							// },
				{
								text: 'Reaksiyon Butonları',
								onclick: function() {
									editor.windowManager.open( {
										title: 'Reaksiyon Butonları',
										body: [
											{
												type: 'textbox',
												name: 'shortcodereact',
												label: 'Kısakod',
												value: '[geo_reactions]'
											},
									],
										onsubmit: function( e ) {
										editor.insertContent( '[geo_reactions]');
										}
									});
								}
							},
				{
					text: 'Tab Menu',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Tab Menu',
							width: 350,
							height: 275,
							body: [
								{
									type: 'textbox',
									name: 'geo_tabTitle',
									label: 'Başlık',
									value: 'Başlık 1'
								},
								{
									type: 'listbox',
									name: 'geo_tabStatus',
									label: 'Durum',
									'values': [
										{text: 'Aktif', value: 'active'},
										{text: 'Aktif Değil', value: 'is-no-active'},
									]
								},
								{
									type: 'textbox',
									name: 'geo_tabTitle1',
									label: 'Başlık',
									value: 'Başlık 2'
								},
								{
									type: 'listbox',
									name: 'geo_tabStatus1',
									label: 'Status',
									'values': [
										{text: 'Aktif Değil', value: 'is-no-active'},
										{text: 'Aktif', value: 'active'},
									]
								},
								{
									type: 'textbox',
									name: 'geo_tabTitle2',
									label: 'Başlık',
									value: 'Başlık 3'
								},
								{
									type: 'listbox',
									name: 'geo_tabStatus2',
									label: 'Status',
									'values': [
										{text: 'Aktif Değil', value: 'is-no-active'},
										{text: 'Aktif', value: 'active'},
									]
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[tabgroup]<br />\
									[tab status="'+ e.data.geo_tabStatus +'" title="'+ e.data.geo_tabTitle +'"] Content 1 [/tab]<br />\
									[tab status="'+ e.data.geo_tabStatus1 +'" title="'+ e.data.geo_tabTitle1 +'"] Content 2 [/tab]<br />\
									[tab status="'+ e.data.geo_tabStatus2 +'" title="'+ e.data.geo_tabTitle2 +'"] Content 3 [/tab]<br />\
								[/tabgroup]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
				{
					text: 'Açılır Menü',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Açılır Menu',
							width: 350,
							height: 275,
							body: [
								{
									type: 'textbox',
									name: 'geo_tabTitle',
									label: 'Başlık',
									value: 'Başlık 1'
								},
								{
									type: 'textbox',
									name: 'geo_tabTitle1',
									label: 'Başlık',
									value: 'Başlık 2'
								},
								{
									type: 'textbox',
									name: 'geo_tabTitle2',
									label: 'Başlık',
									value: 'Başlık 3'
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[toggles]<br />\
									[toggle title="'+ e.data.geo_tabTitle +'"] Content 1 [/toggle]<br />\
									[toggle title="'+ e.data.geo_tabTitle1 +'"] Content 2 [/toggle]<br />\
									[toggle title="'+ e.data.geo_tabTitle2 +'"] Content 3 [/toggle]<br />\
								[/toggles]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
				{
					text: 'Büyük Harf',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Büyük Harf',
							width: 350,
							height: 120,
							body: [
								{
									type: 'listbox',
									name: 'DropcapsType',
									label: 'Tip',
									'values': [
										{text: 'Letter', value: 'letter'},
										{text: 'Circle', value: 'circle'},
									]
								},
								{
									type: 'textbox',
									name: 'DropcapsText',
									label: 'Text',
									value: 'A'
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[dropcap type="'+ e.data.DropcapsType +'"]\
									'+ e.data.DropcapsText +' \
								[/dropcap]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
				{
					text: 'Vurgula',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Vurgula',
							width: 350,
							height: 120,
							body: [
								{
									type: 'textbox',
									name: 'HighlightsText',
									label: 'Text',
									value: 'Geoit Theme'
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[highlight]\
									'+ e.data.HighlightsText +' \
								[/highlight]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
				{
					text: 'Önerilen Yazı',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Önerilen Yazı',
							width: 350,
							height: 120,
							body: [
								{
									type: 'textbox',
									name: 'relatedPostID',
									label: 'Yazı ID:',
									value: '1'
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[geo-post id="'+ e.data.relatedPostID +'" label="Önerilen Yazı"]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
            ]
        });
    });
})();