<?php
/*
Sayfa Adı: Benzer Yazılar
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
?>
<div class="clearfix"></div>
<?php
$related_count = ot_get_option('related_count');
$tags = wp_get_post_terms( get_queried_object_id(), 'post_tag', ['fields' => 'ids'] );
$categories = get_the_category($post->ID); if ($categories) {$category_ids = array(); foreach($categories as $individual_category) $category_ids[] = $individual_category->term_id;}
if ( ot_get_option( 'related_order' ) == 'most-commented' ) {
	$args= array(
		'category__in' => $category_ids,
		'showposts' => $related_count,
		'post__not_in' => array($post->ID),
		'ignore_sticky_posts'=>1,
		'orderby' => 'comment_count',
	);
}
elseif ( ot_get_option( 'related_order' ) == 'recent-posts' ) {
	$args= array(
		'category__in' => $category_ids,
		'post__not_in' => array($post->ID),
		'ignore_sticky_posts'=>1,
		'showposts' => $related_count,
	);
}
elseif ( ot_get_option( 'related_order' ) == 'most-viewed' ) {
	$args= array(
		'category__in' => $category_ids,
		'orderby' => 'post_views',
		'order'	=> 'desc',
		'suppress_filters' => false,
		'post__not_in' => array($post->ID),
		'ignore_sticky_posts'=>1,
		'showposts' => $related_count,
	);
}
elseif ( ot_get_option( 'related_order' ) == 'tags' ) {
	$args= array(
		'suppress_filters' => false,
		'post__not_in' => array($post->ID),
		'ignore_sticky_posts'=>1,
		'showposts' => $related_count,
		'orderby'   => 'rand',
		'tax_query' => [
			[
				'taxonomy' => 'post_tag',
				'terms'    => $tags
			]
    ]
	);
}
else {
	$args= array(
		'category__in' => $category_ids,
		'showposts' => $related_count,
		'post__not_in' => array($post->ID),
		'ignore_sticky_posts'=>1,
		'orderby' => 'rand',
	);
}

$my_query = new wp_query($args);  if ($my_query->have_posts()) : ?>
<div id="related-posts" class="content__related-posts">
	<?php $title =  __( 'Benzer Yazılar', 'geo' ); echo geoit_block_title($title, 'h3');
	if ( ot_get_option( 'related-posts-styles' ) == 'blog-list' ) { ?>
		<div class="post-list-group">
			<?php while($my_query->have_posts()): $my_query->the_post();
				get_template_part('frameworks/template-parts/post/post-list', get_post_format() );
			endwhile; ?>
		</div>
	<?php }
	elseif ( ot_get_option( 'related-posts-styles' ) == 'blog-masonry' ) { ?>
		<div class="masonry">
			<?php while($my_query->have_posts()): $my_query->the_post();?>
				<?php get_template_part('frameworks/template-parts/post/post', get_post_format() ); ?>		
			<?php endwhile; ?>
		</div>
	<?php }
	elseif ( ot_get_option( 'related-posts-styles' ) == 'blog-masonry2' ) { ?>
		<div class="masonry">
			<?php while($my_query->have_posts()): $my_query->the_post();?>
				<?php get_template_part('frameworks/template-parts/post/post-masonry', get_post_format() ); ?>		
			<?php endwhile; ?>
		</div>
	<?php }
	else { ?>
		<div class="masonry masonry-grid">
			<?php while($my_query->have_posts()): $my_query->the_post();?>
				<?php get_template_part('frameworks/template-parts/post/post-grid', get_post_format() ); ?>		
			<?php endwhile; ?>
		</div>
	<?php }
	?>
</div>
<?php endif; wp_reset_query(); ?>	