<?php
/*
Sayfa Adı: Yazı Sayfası-Video
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
?>
<article id="post-<?php the_ID(); ?>" class="content__post content__post-video uck-card">
<div class="content-header-meta">
		<?php if (ot_get_option('geo-breadcrumb') != 'off') get_template_part( 'frameworks/template-parts/extras/breadcrumb');
		geoit_trending_entry(get_the_ID()); 
		if ( is_single() ) {
				the_title( '<h1 class="headline entry-title">', '</h1>' );
			} else {
				the_title( '<h1 class="headline entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h1>' );
			}
		$post_desc = get_post_meta(get_the_ID(), 'geo_post_desc', true);
		if($post_desc != '') {
			echo '<p>'.$post_desc.'</p>';
		} 
		if (is_single() ) : ?>
		<div class="content__post--article_meta">
			<div class="content__post-meta">
				<div class="geoprev"><?php previous_post_link('%link', '<i class="fa fa-arrow-circle-left" aria-hidden="true"></i>', FALSE); ?></div>
				<span class="entry-author author_name vcard author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 32 ); ?><a class="fn" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span>
				<span class="date entry-time"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
				<?php geoit_reading_time($post); ?>
				<?php echo geoit_post_views(); ?>
			</div>
			<div class="content__post-size">
				<span data-balloon="<?php _e('Yazı Boyutu Büyüt', 'geo');?>" data-balloon-pos="left"><a href="javascript:void(0);" id="increase-text"><i class="fa fa-font" aria-hidden="true"></i>+</a> </span>
				<span data-balloon="<?php _e('Yazı Boyutu Küçült', 'geo');?>" data-balloon-pos="left"><a href="javascript:void(0);" id="decrease-text"><i class="fa fa-font" aria-hidden="true"></i>-</a></span>
			</div>
		</div>
		<?php endif; ?>
		<div class="content__post--meta">
			<div class="geoprev"><?php previous_post_link('%link', '<i class="fa fa-arrow-circle-left" aria-hidden="true"></i>', FALSE); ?></div>
			<?php echo geoit_social_share(); ?>
		</div>
	</div>
	<?php $post_video = get_post_meta(get_the_ID(), 'geo_video_url', true); $show_thumb = get_post_meta( get_the_ID(), 'post_show_featured_image', true );
	if ($post_video != ''): ?>
		<div class="content__post--header thumb_video thumbnail">
			<?php echo $post_video; ?>
		</div>
	<?php elseif(has_post_thumbnail() && $show_thumb != 'off'): ?>
		<div class="content__post--header thumbnail">
			<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
					<?php the_post_thumbnail('geo-big'); ?>
				</a>
			<?php echo get_simple_likes_button( get_the_ID() ); ?>
		</div>
	<?php endif; ?>
	<div class="content__post--article">
		<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true ) == true) : ?>
			<?php if(get_post_meta( $post->ID, 'geo_' . 'review_position', true ) == 'top') : ?>
				<div class="gp-review-box-top">
					<?php geo_print_review_box($post->ID, get_post_meta( $post->ID, true ));  ?>
				</div>
			<?php endif; ?>
		<?php endif; ?>
		
		<?php if(geo_is_mobile()): ?>
			<?php if(ot_get_option('geo-2-ads-m') != '' && is_single() ): ?>
				<div class="ad ad-single"><?php echo ot_get_option('geo-2-ads-m'); ?></div>
			<?php endif; ?>
		<?php else: ?>
			<?php if(ot_get_option('geo-2-ads') != '' && is_single() ): ?>
				<div class="ad ad-single"><?php echo ot_get_option('geo-2-ads'); ?></div>
			<?php endif; ?>
		<?php endif; ?>
		
		<?php
			the_content( sprintf(
				__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'geo' ),
				get_the_title()
			) ); ?>
			
			<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true ) == true) : ?>
		<?php if(get_post_meta( $post->ID, 'geo_' . 'review_position', true ) == 'bottom') : ?>
			<div class="gp-review-box-bottom">
				<?php geo_print_review_box($post->ID, get_post_meta( $post->ID, true ));  ?>
			</div>
		<?php endif; ?>
		<?php endif; ?>
			
		<?php if(geo_is_mobile()): ?>
			<?php if(ot_get_option('geo-3-ads-m') != '' && is_single() ): ?>
				<div class="ad ad-single"><?php echo ot_get_option('geo-3-ads-m'); ?></div>
			<?php endif; ?>
		<?php else: ?>
			<?php if(ot_get_option('geo-3-ads') != '' && is_single() ): ?>
				<div class="ad ad-single"><?php echo ot_get_option('geo-3-ads'); ?></div>
			<?php endif; ?>
		<?php endif; ?>
		
		<?php wp_link_pages( array(
			'before'      => '<div class="page-links">' . __( 'Sayfalar:', 'geo' ),
			'after'       => '</div>',
			'link_before' => '<span class="page-number">',
			'link_after'  => '</span>',
			) );
			if ( is_single() ) {
				the_tags( '<div class="content__post--article_tags">'.__('Etiketler:', 'geo').' ', ', ', '<br /></div>' );
			}
		?>


	</div>
</article>