<?php
/*
Sayfa Adı: Yazı-List(3x)
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
?>
<div id="post-<?php the_ID(); ?>" class="uck-card uck-card-list">
	<?php if(has_post_thumbnail()): ?>
		<div class="uck-card--image">
			<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
					<?php the_post_thumbnail('geo-medium'); ?>
				</a>
			<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
			<?php echo get_simple_likes_button( get_the_ID() ); ?>
		</div>
	<?php endif; ?>
	<div class="uck-card--content">
		<div class="uck-card-top">
			<?php geo_reaction_badge($post->ID); ?>
			<?php geoit_trending_post(get_the_ID()); ?>
			<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
			<?php echo geoit_block_views(); ?>
		</div>
		<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
			<?php $gallery_desc = get_post_meta(get_the_ID(), 'geo_gallery_desc', true);
				if ($gallery_desc != '') {
					$string = strip_tags($gallery_desc);
					if (strlen($string) > 250) {

							// truncate string
							$stringCut = substr($string, 0, 250);
							$endPoint = strrpos($stringCut, ' ');

							//if the string doesn't contain any space then it will cut without word basis.
							$string = $endPoint? substr($stringCut, 0, $endPoint) : substr($stringCut, 0);
					}
					echo '<p>'.$string.'..</p>'; 
				} 
			?>
			<div class="uck-card--meta">
				<div class="uck-card--left">
					<span class="entry_author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 20 ); ?><a title="<?php the_author(); ?>" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span>
				</div>
				<div class="uck-card--right">
					<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'><?php _e( 'Galeriyi İncele', 'geo' ); ?></a>
				</div>
			</div>
	</div>
</div>
