<?php
add_action('widgets_init', 'geo_homepage_1col_load_widgets');
function geo_homepage_1col_load_widgets()
{
	register_widget('geo_Homepage_1col_Widget');
}
class geo_Homepage_1col_Widget extends WP_Widget {
	public function __construct(){
		$widget_ops = array('classname' => 'geo_homepage_1col');
		$control_ops = array('id_base' => 'geo_homepage_1col-widget');
		parent::__construct('geo_homepage_1col-widget', ''.THEME_NAME .' - '.__( "Yazılar" , 'geo' ).' #2' , $widget_ops, $control_ops );

	}
	
	public function widget($args, $instance)
	{
		extract($args);
		
		$show_excerpt = isset($instance['show_excerpt']) ? 'true' : 'false';
		
		$title = $instance['title'];
		$title1 = $instance['title1'];
		$categories = $instance['categories'];
		$posts = $instance['posts'];
		$categories1 = $instance['categories1'];
		$posts1 = $instance['posts1'];
		$sortby = $instance['sortby'];
		$postnotin = !empty($instance['postnotin']) ? $instance['postnotin'] : '';
		
		$exlude = $postnotin;
		$excludeposts = explode(",", $exlude);

		echo $before_widget; 
		
		if($sortby == 'commented') {
			$sp_query = new WP_Query(
				array( 
					'showposts' => $posts, 
					'cat' => $categories,
					'orderby' => 'comment_count',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'random') {
			$sp_query = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'orderby' => 'rand',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'post-viewed') {
			$sp_query = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'orderby' => 'post_views',
					'order'	=> 'desc',
					'suppress_filters' => false,
					'post__not_in' => $excludeposts
				)
			);
		}
		else {
			$sp_query = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'post__not_in' => $excludeposts
				)
			);
		}
		?>
		<div class="uck-card col-1">
		<?php if(!empty($title)) {
			echo $before_title;
				echo $title; 
			echo $after_title;
		} ?>
		<?php if ($sp_query->have_posts()) : ?>
			
				<?php $counter = 1; while($sp_query->have_posts()): $sp_query->the_post(); global $post;?>
				<?php if($counter == 1): ?>
					<div class="uck-card--col_top">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
							<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-medium'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
						<?php endif; ?>
							<div class="uck-card--content">
								<?php geo_categories();?>
								<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
								<?php echo geoit_block_views(); ?>
								<?php geoit_trending_post(get_the_ID()); ?>
								<?php if($show_excerpt == 'true'): ?>    
								<?php if (ot_get_option('excerpt-length') != '0'): ?>
									<?php the_excerpt(); ?>
								<?php endif; ?>
							<?php endif; ?>
							</div>
					</div>
				<?php else: ?>
					<div class="uck-card--col_right">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-small'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
						<?php endif; ?>
							<div class="uck-card--content">
								<?php the_title( sprintf( '<h3 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
								<?php geoit_trending_post(get_the_ID()); ?>
							</div>
					</div>
				<?php endif; ?>
				<?php $counter++; endwhile; ?>
			
			<?php else: ?>
			<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
			<?php endif; ?>
			</div>
			<?php 
			if($sortby == 'commented') {
				$sp_query1 = new WP_Query(
					array( 
						'showposts' => $posts1, 
						'cat' => $categories1,
						'orderby' => 'comment_count',
						'post__not_in' => $excludeposts
					)
				);
			}
			elseif($sortby == 'random') {
				$sp_query1 = new WP_Query(
					array( 
						'cat' => $categories1,
						'showposts' => $posts1,
						'orderby' => 'rand',
						'post__not_in' => $excludeposts
					)
				);
			}
			elseif($sortby == 'post-viewed') {
			$sp_query1 = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'orderby' => 'post_views',
					'order'	=> 'desc',
					'suppress_filters' => false,
					'post__not_in' => $excludeposts
				)
			);
		}
			else {
				$sp_query1 = new WP_Query(
					array( 
						'cat' => $categories1,
						'showposts' => $posts1,
						'post__not_in' => $excludeposts
					)
				);
			}?>
			<div class="uck-card col-1 right">
				<?php echo $before_title; echo $title1 ;  echo $after_title; ?>
			<?php if ($sp_query1->have_posts()) : ?>
			
				<?php $counter = 1; while($sp_query1->have_posts()): $sp_query1->the_post(); global $post; ?>
				<?php if($counter == 1): ?>
					<div class="uck-card--col_top">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
								<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-medium'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
						<?php endif; ?>
							<div class="uck-card--content">
								<?php geo_categories();?>
								<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
								<?php geoit_trending_post(get_the_ID()); ?>
								<?php echo geoit_block_views(); ?>
								<?php if($show_excerpt == 'true'): ?>    
								<?php if (ot_get_option('excerpt-length') != '0'): ?>
									<?php the_excerpt(); ?>
								<?php endif; ?>
							<?php endif; ?>
							</div>
					</div>
				<?php else: ?>
					<div class="uck-card--col_right">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-small'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
						<?php endif; ?>
							<div class="uck-card--content">
								<?php the_title( sprintf( '<h3 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
								<?php geoit_trending_post(get_the_ID()); ?>
							</div>
					</div>
				<?php endif; ?>
				<?php $counter++; endwhile; ?>
			<?php else: ?>
			<div style="padding: 1em"><?php _e('Listelenecek Bir Yazı Bulunamadı.', 'geo'); ?></div>
			<?php endif; ?>
			</div>
			<?php wp_reset_query(); ?>
		<?php
		echo $after_widget;
	}
	
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['show_excerpt'] = $new_instance['show_excerpt'];
		$instance['title'] = $new_instance['title'];
		$instance['categories'] = $new_instance['categories'];
		$instance['posts'] = $new_instance['posts'];
		$instance['title1'] = $new_instance['title1'];
		$instance['categories1'] = $new_instance['categories1'];
		$instance['posts1'] = $new_instance['posts1'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['postnotin'] = $new_instance['postnotin'];
		
		return $instance;
	}

	public function form($instance)
	{
		$defaults = array('show_excerpt' => null, 'sortby' => 'recent', 'title' => __('Modül', 'geo'),'postnotin' => '', 'categories' => 'all', 'posts' => 5, 'title1' => __('Modül', 'geo'), 'categories1' => 'all', 'posts1' => 5);
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Göre Sırala' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='recent' <?php if ('recent' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Yayınlanma Tarihine Göre' , 'geo') ?></option>
				<option value='commented' <?php if ('commented' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Yorum Yapılan' , 'geo') ?></option>
				<option value='post-viewed' <?php if ('post-viewed' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Okunan' , 'geo') ?></option>
				<option value='random' <?php if ('random' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Rastgele' , 'geo') ?></option>
			</select>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_excerpt'], 'on'); ?> id="<?php echo $this->get_field_id('show_excerpt'); ?>" name="<?php echo $this->get_field_name('show_excerpt'); ?>" /> 
			<label for="<?php echo $this->get_field_id('show_excerpt'); ?>"><?php _e( 'Açıklamayı Göster' , 'geo') ?></label>
		</p>
		
		<h3>1. Kolon</h3>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('categories'); ?>"><?php _e( 'Kategori' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('categories'); ?>" name="<?php echo $this->get_field_name('categories'); ?>" class="widefat categories" style="width:100%;">
				<option value='all' <?php if ('all' == $instance['categories']) echo 'selected="selected"'; ?>><?php _e( 'Hepsi' , 'geo') ?></option>
				<?php $categories = get_categories('hide_empty=0&depth=1&type=post'); ?>
				<?php foreach($categories as $category) { ?>
				<option value='<?php echo $category->term_id; ?>' <?php if ($category->term_id == $instance['categories']) echo 'selected="selected"'; ?>><?php echo $category->cat_name; ?></option>
				<?php } ?>
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Yazı Sayfası' , 'geo') ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" value="<?php echo $instance['posts']; ?>" />
		</p>
		
		<h3>2. Kolon</h3>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title1' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title1' ); ?>" name="<?php echo $this->get_field_name( 'title1' ); ?>" value="<?php echo $instance['title1']; ?>" class="widefat" type="text" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('categories1'); ?>"><?php _e( 'Kategori' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('categories1'); ?>" name="<?php echo $this->get_field_name('categories1'); ?>" class="widefat categories1" style="width:100%;">
				<option value='all' <?php if ('all' == $instance['categories1']) echo 'selected="selected"'; ?>><?php _e( 'Hepsi' , 'geo') ?></option>
				<?php $categories1 = get_categories('hide_empty=0&depth=1&type=post'); ?>
				<?php foreach($categories1 as $category1) { ?>
				<option value='<?php echo $category1->term_id; ?>' <?php if ($category1->term_id == $instance['categories1']) echo 'selected="selected"'; ?>><?php echo $category1->cat_name; ?></option>
				<?php } ?>
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('posts1'); ?>"><?php _e( 'Yazı Sayısı' , 'geo') ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('posts1'); ?>" name="<?php echo $this->get_field_name('posts1'); ?>" value="<?php echo $instance['posts1']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'postnotin' ); ?>"><?php _e( 'Hariç Tutulan Yazılar' , 'geo') ?></label>
			<br><i><?php _e('Yazı idlerini virgül ile ayırarak girin', 'geo'); ?></i>
			<input id="<?php echo $this->get_field_id( 'postnotin' ); ?>" name="<?php echo $this->get_field_name( 'postnotin' ); ?>" value="<?php echo $instance['postnotin']; ?>" class="widefat" type="text" />
		</p>
	<?php }
}
?>