<?php
  /**
 * Add function to widgets_init that'll load our widget.
 */
add_action('widgets_init','geo_ad_widgets');

function geo_ad_widgets(){
	register_widget("geo_ad_widget");
}

/**
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 */
class geo_ad_widget extends WP_widget{
	
	/**
	 * Widget setup.
	 */
	public function __construct(){
		
		/* Widget settings. */
		$widget_ops = array('classname' => 'widget_ad');
		
		/* Create the widget. */
		parent::__construct('geo_ad_widget', THEME_NAME .' - '.__( "Reklam" , 'geo' ) , $widget_ops );		
	}
	
	/**
	 *display the widget on the screen.
	 */
	public function widget($args,$instance){
		extract($args);
			$title = apply_filters('widget_title', $instance['title'] );
			$link = $instance['link'];
			$image = $instance['image'];
			
			echo $before_widget;
			
			if ( $title )
			echo $before_title . $title . $after_title;
			
			if($image) { ?>	

						<div class="widget-sponsor">
						<a href="<?php echo $link; ?>"><img alt="reklam" src="<?php echo $image; ?>" /></a>
						</div>

	  <?php }
			echo $after_widget;
	}
	
	/**
	 * update widget settings
	 */
	public function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['link'] = $new_instance['link'];
		$instance['image'] = $new_instance['image'];
		
		return $instance;
	}
	
	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	public function form($instance){
		$defaults = array('title' => __('Reklam', 'geo'), 'link' => '', 'image' => '');
		$instance = wp_parse_args((array) $instance, $defaults);
		?>	
		
		<p>			

			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Başlık', 'geo') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('link'); ?>">Link Url</label>
			<input class="widefat" id="<?php echo $this->get_field_id('link'); ?>" name="<?php echo $this->get_field_name('link'); ?>" value="<?php echo $instance['link']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('image'); ?>"><?php _e('Resim URL', 'geo') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('image'); ?>" value="<?php echo $instance['image']; ?>" />
		</p>
		<?php
	}
}
?>