<?php
add_action('widgets_init', 'geo_widget_authors');
function geo_widget_authors()
{
	register_widget('geo_widgetauthors');
}
class geo_widgetauthors extends WP_Widget {
	public function __construct(){
		$widget_ops = array('classname' => 'geoit_authors');
		$control_ops = array('id_base' => 'geo-authors-widget');
		parent::__construct('geo-authors-widget', THEME_NAME .' - '.__( "Köşe Yazarları" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget($args, $instance)
	{
		extract($args);
		
		$title = $instance['title'];
		$posts = $instance['posts'];
		$count = $instance['count'];


		echo $before_widget;
		
		if(!empty($title)) {
			echo $before_title;
				echo $title ; 
			echo $after_title; 
		}
		
		$uids =  explode(',', $posts);

		$args = array (
		'include' => $uids,
		'order' => 'ASC', 
		);
		
		// Create the WP_User_Query object
		$wp_user_query = new WP_User_Query( $args );

		// Get the results
		$authors = $wp_user_query->get_results();

		// Check for results

			if ( ! empty( $authors ) ) {
					foreach ( $authors as $author ) {  $args = array( 'author' => $author->ID, 'showposts' => $count ); $posts = query_posts($args);	?>
						
						<div class="geoit_user_ranking">
				
								<?php echo geoit_get_avatar($author->ID,'80'); ?>
								<div class="geoit_user_content">
								<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $author->ID ) ); ?>"><?php the_author_meta('display_name', $author->ID); ?><?php geoit_verified_user($author->ID); ?></a>
								<?php  if ( have_posts() ) : ?>
									<?php while ( have_posts() ) : the_post(); ?>
										<a class="autor_post" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
									<?php endwhile; ?>
								<?php endif; ?>
								</div>

						</div>

						
					<?php }

			} else {
				echo '<p style="padding:1em">'.__('Listelenecek yazar bulunamadı!', 'geo').'</p>';
			}

		?>
		
	
		<?php
		echo $after_widget;
	}
	
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['posts'] = $new_instance['posts'];
		$instance['count'] = $new_instance['count'];

		
		return $instance;
	}

	public function form($instance)
	{
		$defaults = array('title' => __('Yazarlarımız', 'geo'), 'count' => 1, 'posts' => '');
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Gösterilecek Yazarlar' , 'geo') ?></label>
			<br>
			<i><?php _e('Örnek: 1,10,12 (Yazarın kullanıcı IDsini yazmalısınız)', 'geo'); ?></i>
			<br>
			<input class="widefat" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" value="<?php echo $instance['posts']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('count'); ?>"><?php _e( 'Gösterilecek Yazı' , 'geo') ?></label>
			<input class="widefat" type="number" min="1" max="5" id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>" value="<?php echo $instance['count']; ?>" />
		</p>


	<?php }
}
?>