<?php
add_action('widgets_init', 'geo_widget_coin');
function geo_widget_coin()
{
	register_widget('geo_widgetcoin');
}
class geo_widgetcoin extends WP_Widget {
	public function __construct(){
		$widget_ops = array('classname' => 'geowidgetcoin');
		$control_ops = array('id_base' => 'geowidgetcoin-widget');
		parent::__construct('geowidgetcoin-widget', THEME_NAME .' - '.__( "Kripto Paralar" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget($args, $instance)
	{
		extract($args);
		
		$title = $instance['title'];
		$sortby = $instance['sortby'];

		echo $before_widget;
		echo $before_title;
		echo $title ; 
		echo $after_title; 
		
		if($sortby == 'grid') {
			echo do_shortcode( '[wpcrypto_grid]' );
		}else {
			echo do_shortcode( '[wpcrypto_list]' );
		}
		
		?>

	
		<?php
		echo $after_widget;
	}
	
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['sortby'] = $new_instance['sortby'];
		
		return $instance;
	}

	public function form($instance)
	{
		$defaults = array('show_excerpt' => null, 'title' => __('Koinler', 'geo'), 'sortby' => 'liste');
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		<div style="background: #f00; opacity: .5;margin:1em 0;color:#fff;padding:1em">
			<?php _e('Bu bileşenin çalışması için Ultimate Crypto eklentisinin kurulu olması gerekmektedir.', 'geo'); ?>
			<br/><br/>
			<?php _e('Eklentiyi İndirmek İçin <a style="color: #fff" href="https://www.kanthemes.com/files/wp-ultimate-crypto.zip">Tıkla!</a>', 'geo'); ?>
		</div>
		
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Görünüm' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='grid' <?php if ('grid' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Grid' , 'geo') ?></option>
				<option value='liste' <?php if ('liste' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Liste' , 'geo') ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>

	<?php }
}
?>