<?php
add_action('widgets_init', 'geo_widget_users');
function geo_widget_users()
{
	register_widget('geo_widgetusers');
}
class geo_widgetusers extends WP_Widget {
	public function __construct(){
		$widget_ops = array('classname' => 'geowidgetusers');
		$control_ops = array('id_base' => 'geowidgetusers-widget');
		parent::__construct('geowidgetusers-widget', THEME_NAME .' - '.__( "Öne Çıkan Yazarlar" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget($args, $instance)
	{
		extract($args);
		
		$title = $instance['title'];
		$posts = $instance['posts'];
		$sortby = $instance['sortby'];

		echo $before_widget;
		echo $before_title;
		echo $title ; 
		echo $after_title; 
		
		if($sortby == '-1') {
			$sortby = -1;
		}
		
		$args = array (
		'meta_query' => array(
		  array(
			'type' => 'NUMERIC'
		  )
		),
		'meta_key' => 'geo_user_points', 
		'order' => 'DESC', 
		'orderby' => 'meta_value_num', 
		'number' => $posts,
		'role' => $sortby,
		);

		// Create the WP_User_Query object
		$wp_user_query = new WP_User_Query( $args );

		// Get the results
		$authors = $wp_user_query->get_results();

		// Check for results
		if (ot_get_option('geo_puan_sistem') == 'on') {
			if ( ! empty( $authors ) ) {
					$counter = '0';
					foreach ( $authors as $author ) { $counter++;	?>
						
						<div class="geoit_user_ranking <?php if($counter=='1'):?>birinci_uye<?php endif;?>">
							<div>
								<span class="user_count"><?php echo $counter; ?></span>
								<?php echo geoit_get_avatar($author->ID,'25'); ?>
								<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $author->ID ) ); ?>"><?php the_author_meta('display_name', $author->ID); ?><?php geoit_verified_user($author->ID); ?></a>
							</div>
							<?php echo geo_get_points($author->ID); ?> <?php _e('Puan', 'geo'); ?>
						</div>

						
					<?php }
				if (ot_get_option('geo_user_ranking') != '') {
				echo '<a class="featured_user_btn" href="'. get_page_link(ot_get_option('geo_user_ranking')).'">'.__('Tüm Listeyi Göster', 'geo').'</a>';
				}
			} else {
				echo '<p style="padding:1em">'.__('Listelenecek yazar bulunamadı!', 'geo').'</p>';
			}
		}
		else {
			echo '<p style="padding:1em">'.__('Puanlama sistemini aktif etmeniz gerekmekte.', 'geo').'</p>';
		}
		?>
		
	
		<?php
		echo $after_widget;
	}
	
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['posts'] = $new_instance['posts'];
		$instance['sortby'] = $new_instance['sortby'];
		
		return $instance;
	}

	public function form($instance)
	{
		$defaults = array('posts' => 5, 'title' => __('Öne Çıkan Kullanıcılar', 'geo'), 'sortby' => 'subscriber');
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Yazar Sayısı' , 'geo') ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" value="<?php echo $instance['posts']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Listelenecek Kullanıcıların Rolü' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='-1' <?php if ('all' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Hepsi' , 'geo'); ?></option>
				<option value='subscriber' <?php if ('subscriber' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Abone' , 'geo'); ?></option>
				<option value='contributor' <?php if ('contributor' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e('İçerik Sağlayıcı' , 'geo'); ?></option>
				<option value='editor' <?php if ('editor' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e('Editör' , 'geo'); ?></option>
				<option value='administrator' <?php if ('administrator' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e('Yönetici' , 'geo'); ?></option>
			</select>
		</p>

	<?php }
}
?>