<?php
add_action('widgets_init', 'geo_posts_5_widgets');
function geo_posts_5_widgets()
{
	register_widget('geo_posts_5_Widget');
}
class geo_posts_5_Widget extends WP_Widget {
	public function __construct(){
		$widget_ops = array('classname' => 'geo_posts_5');
		$control_ops = array('id_base' => 'geo_posts_5-widget');
		parent::__construct('geo_posts_5-widget', ''.THEME_NAME .' - '.__( "Yazılar" , 'geo' ).' #5' , $widget_ops, $control_ops );
	}
	
	public function widget($args, $instance)
	{
		extract($args);
		
		$title = $instance['title'];
		$categories = $instance['categories'];
		$posts = $instance['posts'];
		$sortby = $instance['sortby'];
		$postnotin = !empty($instance['postnotin']) ? $instance['postnotin'] : '';
		
		$exlude = $postnotin;
		$excludeposts = explode(",", $exlude);
		
		echo $before_widget; 
		
		if($sortby == 'commented') {
			$sp_query = new WP_Query(
				array( 
					'showposts' => $posts, 
					'cat' => $categories,
					'orderby' => 'comment_count',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'random') {
			$sp_query = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'orderby' => 'rand',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'post-viewed') {
			$sp_query = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'orderby' => 'post_views',
					'order'	=> 'desc',
					'suppress_filters' => false,
					'post__not_in' => $excludeposts
				)
			);
		}
		else {
			$sp_query = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'post__not_in' => $excludeposts
				)
			);
		}
		?>
	<?php echo $before_title; echo $title ;  echo $after_title; ?>
	<div class="masonry masonry-grid">
		<?php if ($sp_query->have_posts()) : ?>
				<?php while($sp_query->have_posts()): $sp_query->the_post(); global $post; 
					get_template_part('frameworks/template-parts/post/post', 'grid');
				endwhile; ?>
			<?php else: ?>
				<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
			<?php endif; ?>
		</div>
		<?php wp_reset_query();
			
		echo $after_widget;
	}
	
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['categories'] = $new_instance['categories'];
		$instance['posts'] = $new_instance['posts'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['postnotin'] = $new_instance['postnotin'];
		
		return $instance;
	}

	public function form($instance)
	{
		$defaults = array('show_excerpt' => null, 'sortby' => 'recent', 'title' => __('Modül', 'geo'),'postnotin' => '', 'categories' => 'all', 'posts' => 6, 'title1' => __('Modül', 'geo'), 'categories1' => 'all', 'posts1' => 5);
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Göre Sırala' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='recent' <?php if ('recent' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Yayınlanma Tarihine Göre' , 'geo') ?></option>
				<option value='commented' <?php if ('commented' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Yorum Yapılan' , 'geo') ?></option>
				<option value='post-viewed' <?php if ('post-viewed' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Okunan' , 'geo') ?></option>
				<option value='random' <?php if ('random' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Rastgele' , 'geo') ?></option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('categories'); ?>"><?php _e( 'Kategori' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('categories'); ?>" name="<?php echo $this->get_field_name('categories'); ?>" class="widefat categories" style="width:100%;">
				<option value='all' <?php if ('all' == $instance['categories']) echo 'selected="selected"'; ?>><?php _e( 'Hepsi' , 'geo') ?></option>
				<?php $categories = get_categories('hide_empty=0&depth=1&type=post'); ?>
				<?php foreach($categories as $category) { ?>
				<option value='<?php echo $category->term_id; ?>' <?php if ($category->term_id == $instance['categories']) echo 'selected="selected"'; ?>><?php echo $category->cat_name; ?></option>
				<?php } ?>
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Yazı Sayısı' , 'geo') ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" value="<?php echo $instance['posts']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'postnotin' ); ?>"><?php _e( 'Hariç Tutulan Yazılar' , 'geo') ?></label>
			<br><i><?php _e('Yazı idlerini virgül ile ayırarak girin', 'geo'); ?></i>
			<input id="<?php echo $this->get_field_id( 'postnotin' ); ?>" name="<?php echo $this->get_field_name( 'postnotin' ); ?>" value="<?php echo $instance['postnotin']; ?>" class="widefat" type="text" />
		</p>
	<?php }
}
?>