<?php
add_action( 'widgets_init', 'geoit_recent_comments' );
function geoit_recent_comments() {
	register_widget( 'geoit_recentcomments' );
}
class geoit_recentcomments extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'classname' => 'geoit_recentcomments' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'recentcomments_widget' );
		parent::__construct( 'recentcomments_widget', THEME_NAME .' - '.__( "Son Yorumlar" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );


		echo $before_widget;
			$output = '';
			$comments = get_comments( apply_filters( 'widget_comments_args', array( 'number' => $number, 'status' => 'approve', 'post_status' => 'publish', 'type'=> 'comment') ) );
			$output .= '<ul>';
			foreach ( (array) $comments as $comment) {
            $output .=  '<li class="recent_comments">' . sprintf(_x('%1$s tarafından %2$s', 'geo'), '<span class="comment-author-link">'.get_comment_author_link().'</span>', '<a href="' . esc_url( get_comment_link($comment->comment_ID) ) . '">' . get_the_title($comment->comment_post_ID) . '</a>') . '</li>';
         }
			$output .= '</ul>';
			echo $output;
		
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];

		return $instance;
	}

	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>

	<?php
	}
}
?>