<?php
add_action( 'widgets_init', 'reviewed_posts_widget' );
function reviewed_posts_widget() {
	register_widget( 'reviewed_posts_widgets' );
}
class reviewed_posts_widgets extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'classname' => 'reviewed_posts' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'reviewed_post' );
		parent::__construct( 'reviewed_post', THEME_NAME .' - '.__( "İncelenen Yazılar" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$no_of_posts = $instance['no_of_posts'];
		$sortby = $instance['sortby'];

		echo $before_widget;
		echo $before_title;
		echo $title ; 
		echo $after_title;

		if($sortby == 'bestreview') {
			$sp_query = new WP_Query(
				array( 
					'showposts' => $no_of_posts, 
					'meta_key' => 'geo_enable_review', 
					'meta_value' => 'on',
					'orderby' => 'meta_value_num',
				)
			);
		}
		elseif($sortby == 'random') {
			$sp_query = new WP_Query(
				array( 
					'meta_key' => 'geo_enable_review', 
					'meta_value' => 'on',
					'showposts' => $no_of_posts,
					'orderby' => 'rand',
				)
			);
		}
		else {
			$sp_query = new WP_Query(
				array( 
					'meta_key' => 'geo_enable_review', 
					'meta_value' => 'on',
					'showposts' => $no_of_posts,
				)
			);
		}		?>

			<?php global $post; if ($sp_query->have_posts()) : ?>
				<div class="uckan-card-big">
				<?php while($sp_query->have_posts()): $sp_query->the_post(); global $post; ?>
					<div class="geo__item">
						<div class="geo-thumbnail">
							<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
							<?php if(has_post_thumbnail()): ?>
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-medium'); ?>
								</a>
							<?php endif; ?>
							<div class="carousel__content">
								<div class="carousel__category">
									<?php geo_categories(); ?>
								</div>
								<?php the_title( sprintf( '<h3 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
								<div class="carousel__content--meta">
									<span class="author"><i class="fa fa-user"></i> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span>
									<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?><?php echo geoit_block_views(); ?><?php geoit_trending_post(get_the_ID()); ?></span>
								</div>
							</div>
						</div>
					</div>
				<?php endwhile; ?>
				</div>
			<?php else: ?>
				<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
			<?php endif; ?>
			<?php wp_reset_query(); ?>
	
	<?php 
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['no_of_posts'] = $new_instance['no_of_posts'];
		$instance['sortby'] = $new_instance['sortby'];
		
		return $instance;
	}

	public function form( $instance ) {
		$defaults = array( 'title' =>__( 'Modül' , 'geo'), 'no_of_posts' => '4', 'sortby' => 'bestreview'  );
		$instance = wp_parse_args( (array) $instance, $defaults );
	?>
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Göre Sırala' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='recent' <?php if ('recent' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Yayınlanma Tarihine Göre' , 'geo') ?></option>
				<option value='bestreview' <?php if ('bestreview' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En çok puanı alan yazılar' , 'geo') ?></option>
				<option value='random' <?php if ('random' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Rastgele' , 'geo') ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>"><?php _e( 'Yazı Sayısı' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance['no_of_posts']; ?>" type="text" size="3" />
		</p>
	<?php
	}
}
?>