<?php
add_action( 'widgets_init', 'geo_query_widget' );
function geo_query_widget() {
	register_widget( 'geo_querys' );
}
class geo_querys extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'classname' => 'recentpostslider' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'recentpost_slider_widget' );
		parent::__construct( 'recentpost_slider_widget', THEME_NAME .' - '.__( "Slider Yazıları" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$no_of_posts = $instance['no_of_posts'];
		$cats_id = $instance['cats_id'];
		$style = $instance['style'];
		$sortby = $instance['sortby'];
		$postnotin = !empty($instance['postnotin']) ? $instance['postnotin'] : '';
		
		$exlude = $postnotin;
		$excludeposts = explode(",", $exlude);

		echo $before_widget;
		
		if(!empty($title)) {
			echo $before_title;
				echo $title; 
			echo $after_title;
		}
		
		if($sortby == 'commented') {
			$geo_query = new WP_Query(
				array( 
					'showposts' => $no_of_posts, 
					'cat' => $cats_id,
					'orderby' => 'comment_count',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'random') {
			$geo_query = new WP_Query(
				array( 
					'cat' => $cats_id,
					'showposts' => $no_of_posts,
					'orderby' => 'rand',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'post-viewed') {
			$geo_query = new WP_Query(
				array( 
					'cat' => $cats_id,
					'showposts' => $no_of_posts,
					'orderby' => 'post_views',
					'order'	=> 'desc',
					'suppress_filters' => false,
					'post__not_in' => $excludeposts
				)
			);
		}
		else {
			$geo_query = new WP_Query(
				array( 
					'cat' => $cats_id,
					'showposts' => $no_of_posts,
					'post__not_in' => $excludeposts
				)
			);
		}
		?>
	<?php if($style == 'standart'): ?>
		<div class="slider-style-2">
			<div class="owl-carousel loop w-slider owl-theme">
				<?php if ($geo_query->have_posts()) : ?>
					<?php while($geo_query->have_posts()): $geo_query->the_post(); global $post;?>
						<div class="carousel__item item">
							<?php echo get_simple_likes_button( get_the_ID() ); ?>
							<figure <?php geoit_thumbnail_background_image(get_post_thumbnail_id(), 'geo-slider'); ?>></figure>
							<div class="carousel__content">
								<div class="carousel__category">
									<?php geo_categories(); ?>
								</div>
								<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
								<div class="carousel__content--meta">
									<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?><?php echo geoit_block_views(); ?><?php geoit_trending_post(get_the_ID()); ?></span>
									<span class="circle"></span>
									<span class="category"><?php geo_categories();?></span>
									<a class="readmore" href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'><?php _e( 'Devamını Oku', 'geo' ); ?></a>
								</div>
							</div>
						</div>
					<?php endwhile; ?>
				<?php else: ?>
					<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
				<?php endif; ?>
			</div>
		</div>
	<?php elseif($style == 'righttoleft'): ?>
			<div class="owl-carousel slider-style-x2 loop2 h-slider w-slider owl-theme">
				<?php if ($geo_query->have_posts()) : ?>
					<?php while($geo_query->have_posts()): $geo_query->the_post(); global $post; ?>
					<div class="carousel__item item">
						<?php echo get_simple_likes_button( get_the_ID() ); ?>
						<figure <?php geoit_thumbnail_background_image(get_post_thumbnail_id(), 'geo-big'); ?>></figure>
						<div class="carousel__content">
						<div class="carousel__category">
										<?php geo_categories(); ?>
									</div>
						<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
						<div class="carousel__content--meta">
								<span class="author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 25 ); ?><span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span></span>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?><?php echo geoit_block_views(); ?><?php geoit_trending_post(get_the_ID()); ?></span>
							</div>
					</div>
					</div>
				<?php endwhile;?>
				<?php else: ?>
				<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
				<?php endif; ?>
			</div>
	<?php elseif($style == 'righttoleft2'): ?>
			<div class="owl-carousel slider-style-3 loop2 owl-theme h-slider w-slider ">
				<?php if ($geo_query->have_posts()) : ?>
					<?php while($geo_query->have_posts()): $geo_query->the_post(); global $post; ?>
						<div class="carousel__item carousel_big--item">
						<a href="<?php echo esc_url( get_permalink() ); ?>" class="uckan-card--url"></a>
						<?php echo get_simple_likes_button( get_the_ID() ); ?>
						<figure <?php geoit_thumbnail_background_image(get_post_thumbnail_id(), 'geo-carousel3', 'carousel__image'); ?>></figure>
						<div class="carousel__content">
							<div class="carousel__category">
								<?php geo_categories(); ?>
							</div>
							<?php the_title( sprintf( '<h2 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
								<div class="carousel__content--meta">
									<span class="author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 25 ); ?><span><a title="<?php the_author(); ?>" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span></span>
									<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?><?php echo geoit_block_views(); ?><?php geo_reaction_badge($post->ID); ?><?php geoit_trending_post(get_the_ID()); ?></span>
								</div>
						
						</div>
					</div>
				<?php endwhile; ?>
				<?php else: ?>
					<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
				<?php endif; ?>
			</div>
	<?php endif; ?>
<?php wp_reset_query(); ?>
	
	<?php 
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['no_of_posts'] = $new_instance['no_of_posts'];
		$instance['cats_id'] = $new_instance['cats_id'];
		$instance['style'] = $new_instance['style'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['postnotin'] = $new_instance['postnotin'];

		return $instance;
	}

	public function form( $instance ) {
		$defaults = array( 'title' =>__( 'Modül' , 'geo'), 'no_of_posts' => '5','sortby' => 'recent', 'cats_id' => 'all','postnotin' => '', 'style' => 'standart'  );
		$instance = wp_parse_args( (array) $instance, $defaults );
	?>
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Göre Sırala' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='recent' <?php if ('recent' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Son Yazılar' , 'geo') ?></option>
				<option value='commented' <?php if ('commented' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Yorum Yapılan' , 'geo') ?></option>
				<option value='post-viewed' <?php if ('post-viewed' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Okunan' , 'geo') ?></option>
				<option value='random' <?php if ('random' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Rastgele' , 'geo') ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('style'); ?>"><?php _e( 'Görünüm' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('style'); ?>" name="<?php echo $this->get_field_name('style'); ?>" class="widefat categories" style="width:100%;">
				<option value='righttoleft' <?php if ('righttoleft' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Sağdan Sola' , 'geo') ?></option>
				<option value='righttoleft2' <?php if ('righttoleft2' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Sağdan Sola' , 'geo') ?> #2</option>
				<option value='standart' <?php if ('standart' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Basit Slider' , 'geo') ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('cats_id'); ?>"><?php _e( 'Kategori' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('cats_id'); ?>" name="<?php echo $this->get_field_name('cats_id'); ?>" class="widefat categories" style="width:100%;">
				<option value='all' <?php if ('all' == $instance['cats_id']) echo 'selected="selected"'; ?>><?php _e( 'Hepsi' , 'geo') ?></option>
				<?php $cats_id = get_categories('hide_empty=0&depth=1&type=post'); ?>
				<?php foreach($cats_id as $cats_id) { ?>
				<option value='<?php echo $cats_id->term_id; ?>' <?php if ($cats_id->term_id == $instance['cats_id']) echo 'selected="selected"'; ?>><?php echo $cats_id->cat_name; ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>"><?php _e( 'Yazı Sayısı' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance['no_of_posts']; ?>" type="text" size="3" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'postnotin' ); ?>"><?php _e( 'Hariç Tutulan Yazılar' , 'geo') ?></label>
			<br><i><?php _e('Yazı idlerini virgül ile ayırarak girin', 'geo'); ?></i>
			<input id="<?php echo $this->get_field_id( 'postnotin' ); ?>" name="<?php echo $this->get_field_name( 'postnotin' ); ?>" value="<?php echo $instance['postnotin']; ?>" class="widefat" type="text" />
		</p>
		
	<?php
	}
}
?>