<?php
  /**
 * Add function to widgets_init that'll load our widget.
 */
add_action('widgets_init','geo_social_widgets');

function geo_social_widgets(){
	register_widget("geo_social_widget");
}

/**
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 */
class geo_social_widget extends WP_widget{
	
	/**
	 * Widget setup.
	 */
	public function __construct(){
		
		/* Widget settings. */
		$widget_ops = array('classname' => 'widget_social');
		
		/* Create the widget. */
		parent::__construct('geo_social_widget', THEME_NAME .' - '.__( "Sosyal Medya" , 'geo' ) , $widget_ops );		
	}
	
	/**
	 *display the widget on the screen.
	 */
	public function widget($args,$instance){
		extract($args);
			$title = apply_filters('widget_title', $instance['title'] );
			$facebook = $instance['facebook'];
			$twitter = $instance['twitter'];
			$gplus = $instance['gplus'];
			$pinterest = $instance['pinterest'];
			$youtube = $instance['youtube'];
			$medium = $instance['medium'];
			$instagram = $instance['instagram'];
			
			echo $before_widget;
			if ( $title ) {
			echo $before_title . $title . $after_title;
			}
			?>	

			<div class="widget-social-accounts">
				<?php if ( $facebook ) : ?>
					<a target="_blank" class="s-link facebook" href="<?php echo $facebook; ?>">
						<span class="w-icon"><i class="fa fa-facebook"></i></span>
						<span class="text"><?php _e('Beğen','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $twitter ) : ?>
					<a target="_blank" class="twitter s-link" href="<?php echo $twitter; ?>">
						<span class="w-icon"><i class="fa fa-twitter"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $gplus ) : ?>
					<a target="_blank" class="s-link gplus" href="<?php echo $gplus; ?>">
						<span class="w-icon"><i class="fa fa-google-plus"></i></span>
						<span class="text"><?php _e('Abone','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $medium ) : ?>
					<a target="_blank" class="s-link medium" href="<?php echo $medium; ?>">
						<span class="w-icon"><i class="fa fa-medium"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $pinterest ) : ?>
					<a target="_blank" class="s-link pinterest" href="<?php echo $pinterest; ?>">
						<span class="w-icon"><i class="fa fa-pinterest"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $youtube ) : ?>
					<a target="_blank" class="s-link youtube" href="<?php echo $youtube; ?>">
						<span class="w-icon"><i class="fa fa-youtube"></i></span>
						<span class="text"><?php _e('Abone','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $instagram ) : ?>
					<a target="_blank" class="s-link instagram" href="<?php echo $instagram; ?>">
						<span class="w-icon"><i class="fa fa-instagram"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
			</div>

	  <?php 
			echo $after_widget;
	}
	
	/**
	 * update widget settings
	 */
	public function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['facebook'] = $new_instance['facebook'];
		$instance['twitter'] = $new_instance['twitter'];
		$instance['gplus'] = $new_instance['gplus'];
		$instance['pinterest'] = $new_instance['pinterest'];
		$instance['youtube'] = $new_instance['youtube'];
		$instance['medium'] = $new_instance['medium'];
		$instance['instagram'] = $new_instance['instagram'];
		return $instance;
	}

	public function form($instance){
		$defaults = array('title' => '', 'facebook' => '', 'twitter' => '', 'gplus' => '', 'pinterest' => '', 'medium' => '', 'youtube' => '', 'instagram' => '', );
		$instance = wp_parse_args((array) $instance, $defaults);
		?>	
				
		<p>	
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Başlık', 'geo') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('facebook'); ?>">Facebook</label>
			<i><?php _e('Sample:', 'geo') ?></i><strong>http://www.facebook.com/kanthemes</strong>
			<input class="widefat" id="<?php echo $this->get_field_id('facebook'); ?>" name="<?php echo $this->get_field_name('facebook'); ?>" value="<?php echo $instance['facebook']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('twitter'); ?>">Twitter</label>
			<i><?php _e('Sample:', 'geo') ?></i><strong>http://www.twitter.com/uckanthemes</strong>
			<input class="widefat" id="<?php echo $this->get_field_id('facebook'); ?>" name="<?php echo $this->get_field_name('twitter'); ?>" value="<?php echo $instance['twitter']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('gplus'); ?>">Google Plus</label>
			<i><?php _e('Sample:', 'geo') ?></i><strong>https://plus.google.com/xxx</strong>
			<input class="widefat" id="<?php echo $this->get_field_id('gplus'); ?>" name="<?php echo $this->get_field_name('gplus'); ?>" value="<?php echo $instance['gplus']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('pinterest'); ?>">Pinterest</label>
			<i><?php _e('Sample:', 'geo') ?></i><strong>https://pinterest.com/kanthemes</strong>
			<input class="widefat" id="<?php echo $this->get_field_id('pinterest'); ?>" name="<?php echo $this->get_field_name('pinterest'); ?>" value="<?php echo $instance['pinterest']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('medium'); ?>">Medium.com</label>
			<i><?php _e('Sample:', 'geo') ?></i><strong>https://medium.com/@kanthemes</strong>
			<input class="widefat" id="<?php echo $this->get_field_id('medium'); ?>" name="<?php echo $this->get_field_name('medium'); ?>" value="<?php echo $instance['medium']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('youtube'); ?>">Youtube</label>
			<i><?php _e('Sample:', 'geo') ?></i><strong>http://www.youtube.com/kanthemes</strong>
			<input class="widefat" id="<?php echo $this->get_field_id('facebook'); ?>" name="<?php echo $this->get_field_name('youtube'); ?>" value="<?php echo $instance['youtube']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('instagram'); ?>">Instagram</label>
			<i><?php _e('Sample:', 'geo') ?></i><strong>http://www.twitter.com/kanhemes</strong>
			<input class="widefat" id="<?php echo $this->get_field_id('instagram'); ?>" name="<?php echo $this->get_field_name('instagram'); ?>" value="<?php echo $instance['instagram']; ?>" />
		</p>
		<?php
	}
}
?>