<?php
add_action('widgets_init', 'tabs_load_widgets');
function tabs_load_widgets()
{
	register_widget('Tabs_Widget');
}
class Tabs_Widget extends WP_Widget {
	public function __construct(){
		$widget_ops = array('classname' => 'tab-widget');
		$control_ops = array('id_base' => 'tabs-widget');
		parent::__construct('tabs-widget', THEME_NAME .' - Tab Menu' , $widget_ops, $control_ops );
	}
	public function widget($args, $instance)
	{
		extract($args);
		$posts1 = $instance['posts1'];
		$posts = $instance['posts'];
		$sortby = $instance['sortby'];
		$show_recent_posts1 = isset($instance['show_recent_posts1']) ? 'true' : 'false';
		$show_popular_posts = isset($instance['show_popular_posts']) ? 'true' : 'false';
		$postnotin = !empty($instance['postnotin']) ? $instance['postnotin'] : '';
		
		$exlude = $postnotin;
		$excludeposts = explode(",", $exlude);
		global $post;
		echo $before_widget;
		?>
		<div id="tab-menu">
			<ul class="tabs">
					<?php if($show_recent_posts1 == 'true'): ?><li href="#recent" data-toggle="tab" class="active"><?php _e('Son Yazılar', 'geo') ?></li><?php endif; ?>
					<?php if($show_popular_posts == 'true'): ?><li href="#popular" data-toggle="tab"><?php _e('Popüler Yazılar', 'geo') ?></li><?php endif; ?>
			</ul>
			
			<div class="tab_container">
			
				<?php if($show_recent_posts1 == 'true'): ?>
				<div id="recent" class="tab_content active">
					<?php
					$recent_posts1 = new WP_Query(array('showposts' => $posts1, 'post__not_in' => $excludeposts));
					if($recent_posts1->have_posts()): ?>
					<div class="uck-card-group">
						<?php while($recent_posts1->have_posts()): $recent_posts1->the_post(); global $post; ?>
							<div class="uck-card--col_right">
							<?php if(has_post_thumbnail()): ?>
								<div class="uck-card--image">
									<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
										<?php the_post_thumbnail('geo-small'); ?>
									</a>
									<?php echo get_simple_likes_button( get_the_ID() ); ?>
								</div>
							<?php endif; ?>
								<div class="uck-card--content">
									<?php the_title( sprintf( '<h3 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
									<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
									<?php geoit_trending_post(get_the_ID()); ?>
								</div>
							</div>
						<?php endwhile; ?>
					</div>
					<?php endif; ?>
				</div>
				<?php endif; ?>
				
				<?php if($show_popular_posts == 'true'): ?>
				<div id="popular" class="tab_content <?php  if($show_recent_posts1 == 'false'):?>active<?php endif;?>">
					<?php
						if($sortby == 'post-viewed') {
							$popular_posts = new WP_Query(
								array( 
									'showposts' => $posts1,
									'orderby' => 'post_views',
									'order'	=> 'desc',
									'suppress_filters' => false,
									'post__not_in' => $excludeposts
								)
							);
						}
						else {
							$popular_posts = new WP_Query(
								array( 
									'showposts' => $posts1,
									'orderby' => 'comment_count',
									'post__not_in' => $excludeposts
								)
							);
						}
					if($popular_posts->have_posts()): ?>
					<div class="uck-card-group">
						<?php while($popular_posts->have_posts()): $popular_posts->the_post(); global $post; ?>
							<div class="uck-card--col_right">
							<?php if(has_post_thumbnail()): ?>
								<div class="uck-card--image">
									<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
										<?php the_post_thumbnail('geo-small'); ?>
									</a>
									<?php echo get_simple_likes_button( get_the_ID() ); ?>
								</div>
							<?php endif; ?>
								<div class="uck-card--content">
									<?php the_title( sprintf( '<h3 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
									<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
									<?php echo geoit_block_views(); ?>
									<?php geoit_trending_post(get_the_ID()); ?>
								</div>
							</div>
						<?php endwhile; ?>
					</div>
					<?php endif; ?>
				</div>
				<?php endif; ?>				
			</div>
		
		</div>
		<?php wp_reset_query(); ?>
	
		<?php
		echo $after_widget;
	}
	
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['posts1'] = $new_instance['posts1'];
		$instance['posts'] = $new_instance['posts'];
		$instance['show_recent_posts1'] = $new_instance['show_recent_posts1'];
		$instance['show_popular_posts'] = $new_instance['show_popular_posts'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['postnotin'] = $new_instance['postnotin'];
		
		return $instance;
	}

	public function form($instance)
	{
		$defaults = array('posts1' => 5, 'posts' => '5', 'show_recent_posts1' => 'on', 'show_popular_posts' => 'on', 'postnotin' => '', 'sortby' => 'commented');
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('posts1'); ?>"><?php _e( 'Son Yazı Sayısı' , 'geo') ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('posts1'); ?>" name="<?php echo $this->get_field_name('posts1'); ?>" value="<?php echo $instance['posts1']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Popüler Yazı Sayısı' , 'geo') ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" value="<?php echo $instance['posts']; ?>" />
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_recent_posts1'], 'on'); ?> id="<?php echo $this->get_field_id('show_recent_posts1'); ?>" name="<?php echo $this->get_field_name('show_recent_posts1'); ?>" /> 
			<label for="<?php echo $this->get_field_id('show_recent_posts1'); ?>"><?php _e( 'Son Yazıları Göster' , 'geo') ?></label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_popular_posts'], 'on'); ?> id="<?php echo $this->get_field_id('show_popular_posts'); ?>" name="<?php echo $this->get_field_name('show_popular_posts'); ?>" /> 
			<label for="<?php echo $this->get_field_id('show_popular_posts'); ?>"><?php _e( 'Popüler Yazıları Göster' , 'geo') ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Popüler Yazıların Sıralanışı' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='commented' <?php if ('commented' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Yorum Yapılan' , 'geo') ?></option>
				<option value='post-viewed' <?php if ('post-viewed' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Okunan' , 'geo') ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'postnotin' ); ?>"><?php _e( 'Hariç Tutulan Yazılar' , 'geo') ?></label>
			<br><i><?php _e('Yazı idlerini virgül ile ayırarak girin', 'geo'); ?></i>
			<input id="<?php echo $this->get_field_id( 'postnotin' ); ?>" name="<?php echo $this->get_field_name( 'postnotin' ); ?>" value="<?php echo $instance['postnotin']; ?>" class="widefat" type="text" />
		</p>
	<?php }
}