<?php
/**
 * Template Name: Trendler
 * @url kanthemes.com
 */
__('Trendler', 'geo');
geoit_header(); ?>
<main class="uck-layout__content" role="main" style="margin:3em 0">
	<div class="page__content">
		<div class="container">
			<div class="row">
				<div id="content "class="content content__single col-md-10" style="margin: 0 auto; float: none">
					<?php if ( have_posts() ) : 
						while ( have_posts() ) : the_post();
							$content = get_the_content();
							if (!empty($content))
								echo '<div class="alert alert-secondary" role="alert">'.$content.'</div>';
						endwhile;
					endif; ?>
					<div class="content__recent-posts--group">
						<div class="content__title">
							<h3 class="uckan-btn"><?php the_title(); ?></h3>
						</div>
						<?php
						$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
						if (ot_get_option('geo-trending-query') == 'views') {
							$data= new WP_Query(array(
								'post_type'=>'post', // your post type name
								'orderby' => 'post_views',
								'order'	=> 'desc',
								'suppress_filters' => false,
								'posts_per_page' => 10, // post per page
								'paged' => $paged,
							));
						} else {
							$data= new WP_Query(array(
								'post_type'=>'post', // your post type name
								'meta_query' => array(
									array(
										'key' => 'geoit_post_trending',
										'value' => 'on',
										'compare' => '='
									)
								),
								'meta_key' => 'geoit_post_trending',
								'orderby' => 'meta_value_num',
								'order' => 'DESC',
								'posts_per_page' => 10, // post per page
								'paged' => $paged,
							));
						}
						 ?>
						<?php if($data->have_posts()) : ?>
							<div class="post-list-group post-counter-php">
								<?php $counter=0;while($data->have_posts())  : $data->the_post(); global $post; $counter++; ?>
									<div id="post-<?php the_ID(); ?>" class="uck-card uck-card-list">
										<?php if(has_post_thumbnail()): ?>
											<?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'geo-medium'); ?>
											<div class="post-counter-label"><?php if($paged==1) echo $counter; else echo $counter+(($paged*10)-10); ?></div>
											<div class="uck-card--image">
												
												<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
													<?php the_post_thumbnail('geo-medium'); ?>
												</a>
												<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
												<?php echo get_simple_likes_button( get_the_ID() ); ?>
											</div>
										<?php endif; ?>
										<div class="uck-card--content">
											<div class="uck-card-top">
												<?php geo_reaction_badge($post->ID); ?>
												<?php geoit_trending_post(get_the_ID()); ?>
												<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
												<?php echo geoit_block_views(); ?>
											</div>
											<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
											<?php if (ot_get_option('excerpt-length') != ''): ?>
												<?php the_excerpt(); ?>
											<?php endif; ?>
											<div class="uck-card--meta">
												<div class="uck-card--left">
													<span class="entry_author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 20 ); ?><a title="<?php the_author(); ?>" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span>
												</div>
												<div class="uck-card--right">
													<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'><?php _e( 'Devamını Oku', 'geo' ); ?></a>
												</div>
											</div>
										</div>
									</div>
								<?php endwhile;?>
							</div>
						<?php else: ?>
							<div style="width: 100% !important; padding: 0 1em 1em; display:inline-block;margin-bottom: 1em" class="uck-card box-sd">
								<div class="uck-card--content"><?php _e('Trendlere eklenen bir yazı bulunamadı.', 'geo'); ?></div>
							</div>
						<?php endif; ?>
						<?php
							$total_pages = $data->max_num_pages;
							if ($total_pages > 10){
								echo '<nav class="navigation pagination" role="navigation"><div class="nav-links">';
								$current_page = max(1, get_query_var('paged'));
								echo paginate_links(array(
									'base' => get_pagenum_link(1) . '%_%',
									'format' => '/page/%#%',
									'current' => $current_page,
									'total' => $total_pages,
									'prev_text'          => '<i class="fa fa-long-arrow-left"></i>',
									'next_text'          => '<i class="fa fa-long-arrow-right"></i>',
								));
								echo '</div></nav>';
							}
						?>  	
				</div>
			</div>
		</div>
	</div>
</main>
<?php get_footer();