<?php
if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

/*-----------------------------------------------------------------------------------*/
# Tema Versiyonu
/*-----------------------------------------------------------------------------------*/
require_once('update-notifier.php');
define ('THEME_VER',	"4.8.2" );

/*-----------------------------------------------------------------------------------*/
# Lazy load for featured images
/*-----------------------------------------------------------------------------------*/
add_filter( 'wp_get_attachment_image_attributes', 'wpse8170_add_lazyload_to_attachment_image', 10, 2 );
function wpse8170_add_lazyload_to_attachment_image( $attr, $attachment ) {
	if( is_admin() || is_preview() || ot_get_option('geoit_lazy_images') != 'on' || (function_exists( 'is_amp_page' ) && is_amp_page()) || ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint())) {
		return $attr;
	}
	$attr['class'] .= ' geo-lazy';
	$attr['data-src'] = $attr['src'];
	$attr['data-srcset'] = !empty($attr['srcset']) ? $attr['srcset'] : '';

	$attr['src'] = 'data:image/gif;base64,R0lGODlhAQABAIAAAP///////yH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
	$attr['srcset'] = empty($attr['data-srcset']) ? '' : 'data:image/gif;base64,R0lGODlhAQABAIAAAP///////yH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
    return $attr;
}

/*-----------------------------------------------------------------------------------*/
# The thumbnails add alt tag
/*-----------------------------------------------------------------------------------*/
function isa_add_img_title( $attr, $attachment = null ) {
	if (empty($attr['alt'])) {
		$img_title = trim( strip_tags( $attachment->post_title ) );
		$attr['alt'] = $img_title;
	}
    return $attr;
}
add_filter( 'wp_get_attachment_image_attributes','isa_add_img_title', 10, 2 );

/*-----------------------------------------------------------------------------------*/
# Page Sidebars
/*-----------------------------------------------------------------------------------*/
function geoit_add_sidebar() {
	
	$style = ot_get_option('block_title_style');
	$class = 'block_title_'.$style;
	
	// Page custom sidebar
	wp_reset_query();
	$query = new WP_Query( array(
		'post_type'  => 'any',
		'meta_key'   => '_wp_page_template',
		'meta_value' => 'temp/custom-sidebar.php'
	) );
	
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) : $query->the_post(); global $post;
			$sidebar = get_post_meta($post->ID, 'page_sidebar_status', true);
			if ($sidebar == 'on') {
				register_sidebar(array(
					'name' => $post->post_title.': Sağ Sidebar',
					'description' => $post->post_title.' sayfasının sağ sidebarı.',
					'id' => 'custom-sidebar-'.$post->ID,
					'before_widget' => '<aside id="%1$s" class="widget widget-0 %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<div class="content__title '.$class.'"><h4 class="uckan-btn">',
					'after_title' => '</h4></div>',
				));
			}
		endwhile;
	}
	wp_reset_query();
	
	// Homepage
	wp_reset_query();
	$query = new WP_Query( array(
		'post_type'  => 'any',
		'meta_key'   => '_wp_page_template',
		'meta_value' => array(
			'temp/custom-homepage.php',
		)
	) );
	
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) : $query->the_post(); global $post;
			$sidebar = get_post_meta($post->ID, 'page_sidebar_status', true);
			if ($sidebar == 'on') {
				register_sidebar(array(
					'name' => $post->post_title.': Sağ Sidebar',
					'description' => $post->post_title.' sayfasının sağ sidebarı.',
					'id' => 'custom-sidebar-'.$post->ID,
					'before_widget' => '<aside id="%1$s" class="widget widget-0 %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<div class="content__title '.$class.'"><h4 class="uckan-btn">',
					'after_title' => '</h4></div>',
				));
				register_sidebar(array(
					'name' => $post->post_title.': Homepage',
					'description' => $post->post_title.' sayfasının sol bileşen alanı.',
					'id' => 'custom-homepage-'.$post->ID,
					'before_widget' => '<aside class="widget widget-homepage %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<div class="content__title '.$class.'"><h3 class="uckan-btn">',
					'after_title' => '</h3></div>',
				));
				register_sidebar(array(
					'name' => $post->post_title.': Homepage Full Width',
					'description' => $post->post_title.' sayfasının tam genişlikli bileşen alanı.',
					'id' => 'custom-homepage-full-'.$post->ID,
					'before_widget' => '<aside class="widget widget-homepage widget-full-width %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<div class="content__title '.$class.'"><h3 class="uckan-btn">',
					'after_title' => '</h3></div>',
				));
			}
		endwhile;
	}
	wp_reset_query();

}
add_action( 'widgets_init', 'geoit_add_sidebar' );

/*-----------------------------------------------------------------------------------*/
# Lazy Load for entry images
/*-----------------------------------------------------------------------------------*/

function add_image_placeholders( $content ) {
	// Don't lazyload for feeds, previews, mobile
	if( is_feed() || is_preview() || !is_singular() || ot_get_option('geoit_lazy_images') != 'on' || (function_exists( 'is_amp_page' ) && is_amp_page()) || ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint()))
		return $content;

	// Don't lazy-load if the content has already been run through previously
	if ( false !== strpos( $content, 'data-src' ) )
		return $content;

	// In case you want to change the placeholder image
	$placeholder_image = apply_filters( 'lazyload_images_placeholder_image', 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mPk5ODkAQAAZAAoQWYOjQAAAABJRU5ErkJggg==' );

	// This is a pretty simple regex, but it works
	$content = preg_replace( '#<img([^>]+?)src=[\'"]?([^\'"\s>]+)[\'"]?([^>]*)>#', sprintf( '<img${1}src="%s" data-src="${2}"${3}><noscript><img${1}src="${2}"${3}></noscript>', $placeholder_image ), $content );
	$content = str_replace('srcset="', 'data-srcset="', $content); 
	
	return $content;
}
add_filter( 'the_content', 'add_image_placeholders', 99 );

/*-----------------------------------------------------------------------------------*/
# Functions.php değiştirme
/*-----------------------------------------------------------------------------------*/
add_action( 'after_setup_theme', 'geoit_image_sizes');
function geoit_image_sizes() {
	if ( function_exists( 'add_image_size' ) ){
		add_image_size( 'geo-small', 150, 90, true );
		add_image_size( 'geo-medium', 335, 195, true );
		add_image_size( 'geo-big', 850, 9999, false );
		add_image_size( 'geo-big2', 466, 250, true );
		add_image_size( 'geo-carousel', 950, 500, true );
		add_image_size( 'geo-slider', 1290, 500, true );
	}
}

add_action( 'after_setup_theme', 'geoit_content_width');
function geoit_content_width() {
	$content_width = 794;
	$GLOBALS['content_width'] = apply_filters( 'geoit_content_width', $content_width );
}

/*-----------------------------------------------------------------------------------*/
# Mailchimp
/*-----------------------------------------------------------------------------------*/
require get_template_directory() . '/frameworks/mailchimp.php';

function geoit_wp_head() {
	$kod = ot_get_option('geo-wp-head');
	$out = '';
	if (!empty($kod))
		$out = $kod;
	echo $out;
}
add_action('wp_head', 'geoit_wp_head');

/*-----------------------------------------------------------------------------------*/
# Mobil Menu
/*-----------------------------------------------------------------------------------*/
register_nav_menus( array(
	'geo-mobil' => __( 'Mobil Menu', 'geo' ),
) );

/*-----------------------------------------------------------------------------------*/
# Thumbnail
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_setup2' ) ) {
  function geo_setup2() {
		if ( function_exists( 'add_image_size' ) ){
			add_image_size( 'geo-carousel2', 475, 249, true );
			add_image_size( 'geo-carousel3', 430, 500, true );
		}
	}
}
add_action( 'after_setup_theme', 'geo_setup2' );

/*-----------------------------------------------------------------------------------*/
# Manşet
/*-----------------------------------------------------------------------------------*/
add_action( 'init', 'geoit_manset_system' );
function geoit_manset_system() {
	$st = ot_get_option('geoit_manset');
	if ($st == 'on') {
		$s = true;
	}
	else {
		$s = false;
	}
	register_post_type( 'geoit_manset',
		array(
			'labels' => array(
				'name' => __( 'Manşet', 'geo' ),
				'singular_name' => __( 'manset', 'geo' )
			),
		'public' => false,
		'show_ui' => $s,
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'rewrite' => false,
    	'query_var' => false,
		'supports' => array( 'title', 'thumbnail', 'custom-fields' ),
		)
	);
	
	 register_taxonomy('topics',array('geoit_manset'), array(
    'hierarchical' => true,
    'show_ui' => true,
	 'public' => false,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'topic' ),
	));
}

add_filter('manage_edit-geoit_manset_columns', 'posts_columns', 5);
add_action('manage_geoit_manset_posts_custom_column', 'posts_custom_columns', 5, 2);
 
function posts_columns($defaults){
    $defaults['riv_post_thumbs'] = __('Thumbs');
    return $defaults;
}
 
function posts_custom_columns($column_name, $id){
    if($column_name === 'riv_post_thumbs'){
        echo the_post_thumbnail( 'medium' );
    }
}


/*-----------------------------------------------------------------------------------*/
# Paylaş Butonları
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_social_share' ) ) {
function geoit_social_share() {
	global $post;
	$style = ot_get_option('social_share');
	if ($style == 'off')
		return;
	?>
	<div class="content__post--meta-social social_btn_<?php echo $style; ?>">
		<ul>
			<li><a class="facebook" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php echo get_permalink(); ?>" data-balloon="<?php _e('Facebook\'ta Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-facebook"></div></a></li>
			<li><a target="_blank" class="twitter" href="http://www.twitter.com/intent/tweet?text=<?php echo get_the_title(); ?> via <?php echo get_permalink(); ?>" data-balloon="<?php _e('Twitter\'da Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-twitter"></div></a></li>
			<?php if(geo_is_mobile()): ?>
			<li><a target="_blank" class="whatsapp" href="whatsapp://send?text=<?php echo get_permalink(); ?>" data-balloon="<?php _e("Whatsapp'ta Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-whatsapp"></div></a></li>
			<?php endif; ?>
			<?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>
			<li><a target="_blank" class="pinterest" href="https://pinterest.com/pin/create/button/?url=&media=<?php echo $image[0]; ?>&description=<?php echo get_the_title(); ?>&url=<?php echo get_permalink(); ?>" data-balloon="<?php _e("Pinterest'te Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-pinterest"></div></a></li>
			<li><a target="_blank" class="mail" onclick="window.open('https://mail.google.com/mail/u/0/?view=cm&fs=1&to&su=<?php echo get_the_title(); ?>&body=<?php echo get_permalink(); ?>&ui=2&tf=1','mail','width=600,height=400')" href="https://mail.google.com/mail/u/0/?view=cm&fs=1&to&su=<?php echo get_the_title();?>&body=<?php echo get_permalink(); ?>&ui=2&tf=1" data-balloon="<?php _e('Gmail ile Gönder', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-envelope "></div></a></li>
			<?php if ( is_single() ) : ?>
				<li data-balloon="<?php _e('Önceki Sayfa', 'geo');?>" data-balloon-pos="bottom" class="geoprevv"><?php previous_post_link('%link', '<i class="fa fa-arrow-circle-left" aria-hidden="true"></i>', FALSE); ?></li>
				<li data-balloon="<?php _e('Sonraki Sayfa', 'geo');?>" data-balloon-pos="bottom"><?php next_post_link('%link', '<i class="fa fa-arrow-circle-right" aria-hidden="true"></i>', FALSE); ?></li>
			<?php endif; ?>
		</ul>
	</div>
<?php  }
}
/*-----------------------------------------------------------------------------------*/
# Klasik Editör
/*-----------------------------------------------------------------------------------*/
function geoit_classic_editor() {
	$kontrol = ot_get_option('geo_gutenberg_disable');
	if ($kontrol == 'on') {
		if (version_compare($GLOBALS['wp_version'], '5.0-beta', '>')) {
				
			 // WP > 5 beta
			 add_filter('use_block_editor_for_post_type', '__return_false', 100);
				
		} else {
				
			 // WP < 5 beta
			 add_filter('gutenberg_can_edit_post_type', '__return_false');
				
		}
	}
}
add_action('admin_init', 'geoit_classic_editor' );
/*-----------------------------------------------------------------------------------*/
# Puanları Sıfırla
/*-----------------------------------------------------------------------------------*/
add_action('admin_init', 'geo_points_reset');
function geo_points_reset() {
	$kontrol = ot_get_option('geo_puan_reset');

    //check if admin, if not, lets get out of here - don't run remainder of function 
    if ( current_user_can('administrator') && $kontrol == 'on') 
    {
			//check that $_POST is not empty & that correct wp_nonce is supplied
			//checl that $_POST['delete_credit'] is also set and passed with $_POST variables
			if ( !empty($_POST) )
			 {
					 //set your role to apply this action to
					 // $role = 'subscriber';

					 //get all users of this role (i.e. Subcribers)
					 // $users = get_users('role='.$role);
					 $users = get_users();

					 //iterate of each user returned applying our delete_user_meta function
					 foreach ($users as $user) {
						delete_user_meta($user->ID, 'cover_puan');
						delete_user_meta($user->ID, 'avatar_puan');
						delete_user_meta($user->ID, 'geo_user_points');
					 }

			 }
     }
}
/*-----------------------------------------------------------------------------------*/
# Okunma Sayısı
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_block_views' ) ) {
	function geoit_block_views() {
		$control = ot_get_option('geoit_post_views');
		$block = ot_get_option('geo_block_views');
		$return = '';
		if ($control == 'on' && function_exists("pvc_get_post_views")) {
			if ($block == 'on') {
				$return = pvc_get_post_views( get_the_ID());
				$return = '<span class="post-views"><i class="fa fa-bolt"></i> '.$return.'</span>';
			}
		}
		return $return;
	}
}
if ( ! function_exists( 'geoit_post_views' ) ) {
	function geoit_post_views() {
		$control = ot_get_option('geoit_post_views');
		$block = ot_get_option('geo_post_views');
		$return = '';
		if ($control == 'on' && function_exists("pvc_get_post_views")) {
			if ($block == 'on') {
				$return = pvc_get_post_views( get_the_ID());
				$return = '<span class="post-views"><i class="fa fa-bolt"></i> '.$return.'</span>';
			}
		}
		return $return;
	}
}
/*-----------------------------------------------------------------------------------*/
# Popup
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_popup' ) ) {
	function geoit_popup() {
		$cookie = ot_get_option('geo_popup_box');
		$ad = ot_get_option('geo-6-ads');
		if ($cookie == 'on'): ?>
			<?php if(is_active_sidebar('popup')):?>
			<div id="popup-box">
				<div id="popup-box-content">
					<i class="fa fa-close" id="popup-close"></i>
					<?php dynamic_sidebar( 'popup' ); ?>
				</div>
			</div>
		<?php endif;
		endif; 
		if ($ad != '') {
			echo '<div class="geoit_popup_ade">';
				echo '<div class="geoit_popup_wrapper">';
					echo '<i class="fa fa-close" id="popup-close"></i>';
					echo $ad;
				echo '</div>';
			echo '</div>';
		}
	}
}
/*-----------------------------------------------------------------------------------*/
# Çerez Bildirimi
/*-----------------------------------------------------------------------------------*/
add_action('wp_footer', 'geoit_cookie');
if ( ! function_exists( 'geoit_cookie' ) ) {
	function geoit_cookie() {
		$cookie = ot_get_option('geo_cookie_box');
		if ($cookie == 'on'): ?>
		<div id="cookie-box">
        <div id="cookie-box-content">
            <p><?php _e('Bu web sitesinde en iyi deneyimi yaşamanızı sağlamak için çerezler kullanılmaktadır.', 'geo'); ?></p>
				<a href="<?php echo get_page_link(ot_get_option('geo_cookie_page')); ?>" style="text-decoration: underline;"><?php _e('Detaylar', 'geo'); ?></a>
				<button class="uckan-btn colored"><?php _e('Kabul Ediyorum', 'geo'); ?></button>
        </div>
      </div>
		<?php endif; 
	}
}
/*-----------------------------------------------------------------------------------*/
# Adblock Engelleyicisi
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_adblock' ) ) {
	function geoit_adblock() { ?>
		<?php if (ot_get_option('adblock_detecter') == 'on') : ?>
		<div class="adblockalert">
		  <div class="adblockalert-content">
			<i class="fa fa-warning"></i>
			<h3 class="adblockalert-content-title"><?php _e('Adblock Kullanıyorsunuz', 'sp'); ?></h3>
			<?php echo do_shortcode(''.ot_get_option('adblock_text').''); ?>
		  </div>
		</div>
		<script>
		!function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t:e.adblock=t()}(this,function(){"use strict";var e={},t=function(){var e=document.createElement("div");return e.id="adcontent",document.body.appendChild(e),e};return e.check=function(e,n){var o=t();setTimeout(function(){var t=0===o.offsetLeft&&0===o.offsetTop;e(t)},n||1e3)},e});

		var enabled = document.querySelector('.adblockalert');

		adblock.check(function (active) {
			if (active) {
				$('body').addClass('ad_block_detected');
				enabled.style.display = 'block';
			}
		}, 1000);
		</script>
		<?php else:
			return false;
		endif; ?>
	<?php }
}
add_action ('wp_footer', 'geoit_adblock');
/*-----------------------------------------------------------------------------------*/
# Çerez Bildirimi
/*-----------------------------------------------------------------------------------*/
// add_action('wp_footer', 'geo_cookie_bar');q
if ( ! function_exists( 'geo_cookie_bar' ) ) {
	function geo_cookie_bar() {
		$cookie = ot_get_option('footer-cookie');
			echo '<div id=""eu-cookie-law" class="cookie-wrapper cookie hidden widget_eu_cookie_law_widget">';
				echo '<div class="hide-on-button">';
				echo 'Denemeler cookie bildirimi.';
				echo '</div>';
				echo '<button id="closeCookie" class="cookie_close accept"><i class="fa fa-times"></i></button>';
			echo '</div>';
	}
}
/*-----------------------------------------------------------------------------------*/
# Slider&Carousel
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_featured' ) ) {
	function geoit_featured() {
		$select = ot_get_option( 'slider_select' );
		Switch ($select){
			case 'slider-style1':
				get_template_part('frameworks/template-parts/slider/carousel');
				break;
			case 'slider-style4':
				get_template_part('frameworks/template-parts/slider/carousel-2');
				break;
			case 'slider-style2':
				get_template_part('frameworks/template-parts/slider/slider');
				break;
			case 'slider-style3':
				get_template_part('frameworks/template-parts/slider/slider-2');
				break;
			case 'slider-style5':
				get_template_part('frameworks/template-parts/slider/slider-3');
				break;
			case 'slider-style6':
				get_template_part('frameworks/template-parts/slider/carousel-3');
				break;
			case 'manset':
				get_template_part('frameworks/template-parts/slider/manset');
				break;
	 }
	}
}
/*-----------------------------------------------------------------------------------*/
# Rankını Göster
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_get_rank' ) ) {
	function geo_get_rank($author) {
			$user = new WP_User( $author );
			$count = get_user_meta( $author, 'geo_user_points', true );
			$role = $user->roles;
			$rank = ot_get_option('geo_ranks', array());
			$rank2 = ot_get_option('geo_role_ranks', array());
			$out = '';
			if (!empty($rank2)){
				foreach($rank2 as $item) {
					if ( isset($item['title']) && !empty($item['title']) && !empty($item['role']) && isset($item['role'])) {
						if($role[0] == $item['role']){
							$out .= '<label style="background-color: '.$item['color'].'" class="rank-geo">'.$item['title'].'</label>';
						}
					}
				}
			}
			
			if (!empty($rank)){
				foreach($rank as $item) {
					if ( isset($item['title']) && !empty($item['title']) && !empty($item['rank-min']) && isset($item['rank-min']) && !empty($item['rank-max']) && isset($item['rank-max'])) {
						if($count>=$item['rank-min'] && $count<=$item['rank-max']){
							$out .= '<label style="background-color: '.$item['color'].'" class="rank-geo">'.$item['title'].'</label>';
						}
					}
				}
			}
			
			return $out;
	}
}

/*-----------------------------------------------------------------------------------*/
# Puanını Göster
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_get_points' ) ) {
	function geo_get_points($author) {
		$count = get_user_meta( $author, 'geo_user_points', true ); 
		if (!empty($count)) {
			$out = $count;
		}
		else {
			$out = '0';
		}
		return $out;
	}
}

/*-----------------------------------------------------------------------------------*/
# Yazıya Puan Ekle
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'post_published_add_points' ) ) {
	function post_published_add_points( $ID, $post ) {
		$author = $post->post_author;
		$points = get_user_meta( $author, 'geo_user_points', true );
		$points += ot_get_option('geo_puan_yazi');
		update_user_meta( $author, 'geo_user_points', $points); 
	}
}
add_action( 'publish_post', 'post_published_add_points', 10, 2 );



/*-----------------------------------------------------------------------------------*/
# Yoruma Puan Ekle
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'comment_published_add_points' ) ) {
	function comment_published_add_points( $comment_ID, $comment_approved ) {
		$comment = get_comment( $comment_ID );
		$comment_author_id = $comment -> user_id;
		$points = get_user_meta( $comment_author_id, 'geo_user_points', true );
		$points += ot_get_option('geo_puan_yorum');
		update_user_meta( $comment_author_id, 'geo_user_points', $points); 
	}
}
add_action( 'comment_post', 'comment_published_add_points', 10, 2 );

/*-----------------------------------------------------------------------------------*/
# Paragraf Arasına Reklam
/*-----------------------------------------------------------------------------------*/
add_filter( 'the_content', 'geo_single_ad' );

if ( ! function_exists( 'geo_single_ad' ) ) {
	function geo_single_ad( $content ) {
		$ad_code = ot_get_option('ad_single_aut');
		$ad_position = ot_get_option('sp_ad_position');
		if ( is_single() && ! is_admin() ) {
			if ($ad_code != '')
			return geo_single_ad_insert( '<div class="ad ad-single">'.$ad_code.'</div>', $ad_position, $content );
		} 
		return $content;
	}
}

if ( ! function_exists( 'geo_single_ad_insert' ) ) { 
	function geo_single_ad_insert( $insertion, $paragraph_id, $content ) {
		$closing_p = '</p>';
		$paragraphs = explode( $closing_p, $content );
		foreach ($paragraphs as $index => $paragraph) {
			if ( trim( $paragraph ) ) {
				$paragraphs[$index] .= $closing_p;
			}
			if ( $paragraph_id == $index + 1 ) {
				$paragraphs[$index] .= $insertion;
			}
		} 
		return implode( '', $paragraphs );
	}
}
/*-----------------------------------------------------------------------------------*/
# Sidebarlar
/*-----------------------------------------------------------------------------------*/
function geoit_block_title($value, $tag) {
	$style = ot_get_option('block_title_style');
	$class = 'block_title_'.$style;
	return '<div class="content__title '.$class.'"><'.$tag.' class="uckan-btn">'.$value.'</'.$tag.'></div>';
}
/*-----------------------------------------------------------------------------------*/
# Sidebarlar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_widgets_init' ) ) {
	function geoit_widgets_init() {
		$style = ot_get_option('block_title_style');
		$class = 'block_title_'.$style;
		register_sidebar(array(
			'name' => 'Sidebar',
			'id' => 'Sidebar',
			'before_widget' => '<aside id="%1$s" class="widget widget-0 %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="content__title '.$class.'"><h4 class="uckan-btn">',
			'after_title' => '</h4></div>',
		));
		
		register_sidebar(array(
			'name' => 'Homepage',
			'id' => 'Homepage',
			'before_widget' => '<aside class="widget widget-homepage widget-0 %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="content__title '.$class.'"><h3 class="uckan-btn">',
			'after_title' => '</h3></div>',
		));
		register_sidebar(array(
			'name' => 'Homepage Full Width',
			'id' => 'home-full-width',
			'before_widget' => '<aside class="widget widget-homepage widget-full-width %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="content__title '.$class.'"><h3 class="uckan-btn">',
			'after_title' => '</h3></div>',
		));
		if (ot_get_option('geo-footerwidgets') != 'off' && ot_get_option('footer-layout-select') != '2') {
			register_sidebar(array(
				'name' => 'Footer 1',
				'id' => 'Footer-1',
				'before_widget' => '<aside class="widget widget-footer %2$s">',
				'after_widget' => '</aside>',
				'before_title' => '<div class="footer__title"><h4 class="headline">',
				'after_title' => '</h4></div>',
			));
			register_sidebar(array(
				'name' => 'Footer 2',
				'id' => 'Footer-2',
				'before_widget' => '<aside class="widget widget-footer %2$s">',
				'after_widget' => '</aside>',
				'before_title' => '<div class="footer__title"><h4 class="headline">',
				'after_title' => '</h4></div>',
			));
			register_sidebar(array(
				'name' => 'Footer 3',
				'id' => 'Footer-3',
				'before_widget' => '<aside class="widget widget-footer widget-last %2$s">',
				'after_widget' => '</aside>',
				'before_title' => '<div class="footer__title"><h4 class="headline">',
				'after_title' => '</h4></div>',
			));
		}
		if ($cookie = ot_get_option('geo_popup_box') == 'on') {
		register_sidebar(array(
			'name' => 'Popup',
			'id' => 'popup',
			'before_widget' => '<aside id="%1$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="popup__title">',
			'after_title' => '</div>',
		));
		}
	}
}
add_action( 'widgets_init', 'geoit_widgets_init' );
/*-----------------------------------------------------------------------------------*/
# Son Yazı Bileşeni
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_recent_entries_standart' ) ) {
	function geo_recent_entries_standart($geo_query){
		global $post;
		$original_post = $post;
	?>
		<div class="uck-card-group">
			<?php if ($geo_query->have_posts()) :
				while($geo_query->have_posts()): $geo_query->the_post();?>
					<div class="uck-card--col_right">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-medium'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
						<?php endif; ?>
						<div class="uck-card--content">
							<?php the_title( sprintf( '<h3 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
							<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
							<?php geoit_trending_post(get_the_ID()); ?>
						</div>
					</div>
				<?php endwhile;?>
			<?php else: ?>
				<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
			<?php endif;?>
		</div>
		<?php $post = $original_post;
		wp_reset_query();
	}
}
	
/*-----------------------------------------------------------------------------------*/
# Sosyal Medya Hesapları
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_social_links' ) ) {

	function geo_social_links() {
		if ( !ot_get_option('social-links') =='' ) {
			$links = ot_get_option('social-links', array());
			if ( !empty( $links ) ) {
				echo '<div class="header__top--social"><ul>';
				foreach( $links as $item ) {
					
					# Build each separate html-section only if set
					if ( isset($item['title']) && !empty($item['title']) ) 
						{ $title = 'title="' .$item['title']. '"'; } else $title = '';
					if ( isset($item['social-link']) && !empty($item['social-link']) ) 
						{ $link = 'href="' .$item['social-link']. '"'; } else $link = '';
					if ( isset($item['social-target']) && !empty($item['social-target']) ) 
						{ $target = 'target="' .$item['social-target']. '"'; } else $target = '';
					if ( isset($item['social-icon']) && !empty($item['social-icon']) ) 
						{ $icon = 'class="fa ' .$item['social-icon']. '"'; } else $icon = '';
					if ( isset($item['social-color']) && !empty($item['social-color']) ) 
						{ $color = 'style="color: ' .$item['social-color']. ';"'; } else $color = '';
					
					# Put them together
					if ( isset($item['title']) && !empty($item['title']) && isset($item['social-icon']) && !empty($item['social-icon']) && ($item['social-icon'] !='fa-') ) {
						echo '<li><a rel="nofollow" '.$title.' '.$link.' '.$target.'><i '.$icon.' '.$color.'></i></a></li>';
					}
				}
				echo '</ul></div>';
			}
		}
	}
	
}

/*-----------------------------------------------------------------------------------*/
# Kullanıcılar için Sosyal Medya Hesapları
/*-----------------------------------------------------------------------------------*/
add_action( 'show_user_profile', 'add_extra_social_links', 10, 2 );
add_action( 'edit_user_profile', 'add_extra_social_links', 10, 2 );
if ( ! function_exists( 'add_extra_social_links' ) ) {
function add_extra_social_links( $user, $false = 'on' )
{ 
 ?>
 <h3><?php _e('Sosyal Medya','geo'); ?></h3>
<table class="form-table">
<?php if ( (is_admin() && current_user_can('administrator')) && $false != 'off' ) : ?>
<tr class="show-admin-bar user-admin-bar-front-wrap">
<th scope="row"><?php _e('Onaylanmış Hesap', 'geo'); ?></th>
<td><fieldset><legend class="screen-reader-text"><span><?php _e('Onaylanmış Hesap', 'geo'); ?></span></legend>
<label for="verified_user">
<input name="verified_user" type="checkbox" id="verified_user" value="yes" <?php if (esc_attr( get_the_author_meta( "verified_user", $user->ID )) == "yes") echo "checked";?>>
</label><br>
</fieldset>
</td>
</tr>
<?php endif; ?>
<?php if ( (is_admin() && current_user_can('administrator')) && (ot_get_option('geo_puan_sistem') == 'on')) : ?>
<tr class="show-admin-bar user-admin-bar-front-wrap">
<th scope="row"><?php _e('Kullanıcının Puanı', 'geo'); ?></th>
<td><fieldset><legend class="screen-reader-text"><span><?php _e('Puanınız', 'geo'); ?></span></legend>
<label for="geo_user_points">
<input name="geo_user_points" type="number" id="geo_user_points" value="<?php echo get_the_author_meta( 'geo_user_points', $user->ID ); ?>">
</label><br>
</fieldset>
</td>
</tr>
<?php endif; ?>
 <tr>
 <th><label for="facebook_profile"><?php _e('Facebook Kullanıcı Adınız','geo'); ?></label></th>
 <td><input type="text" name="facebook_profile" value="<?php echo esc_attr(get_the_author_meta( 'facebook_profile', $user->ID )); ?>" class="regular-text" />
</td>
 </tr>
<tr>
 <th><label for="twitter_profile"><?php _e('Twitter Kullanıcı Adınız','geo'); ?></label></th>
 <td><input type="text" name="twitter_profile" value="<?php echo esc_attr(get_the_author_meta( 'twitter_profile', $user->ID )); ?>" class="regular-text" />
</td>
 </tr>
<tr>
 <th><label for="instagram_profile"><?php _e('Instagram Kullanıcı Adınız','geo'); ?></label></th>
 <td><input type="text" name="instagram_profile" value="<?php echo esc_attr(get_the_author_meta( 'instagram_profile', $user->ID )); ?>" class="regular-text" /></td>
 </tr>
 </table>
 <?php
}
}
add_action( 'personal_options_update', 'save_extra_social_links' );
add_action( 'edit_user_profile_update', 'save_extra_social_links' );
if ( ! function_exists( 'save_extra_social_links' ) ) {
	function save_extra_social_links( $user_id )
	{
	update_user_meta( $user_id,'facebook_profile', sanitize_text_field( $_POST['facebook_profile'] ) );
	update_user_meta( $user_id,'twitter_profile', sanitize_text_field( $_POST['twitter_profile'] ) );
	update_user_meta( $user_id,'instagram_profile', sanitize_text_field( $_POST['instagram_profile'] ) );
	update_user_meta( $user_id, 'verified_user',  sanitize_text_field($_POST['verified_user']) );
	if(is_admin())
		update_user_meta( $user_id, 'geo_user_points',  sanitize_text_field($_POST['geo_user_points']) );	 
	}
}

/*-----------------------------------------------------------------------------------*/
# Yazar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_entry_author' ) ) {
	function geo_entry_author () {
		$author = get_the_author();
		echo '<div class="entry-author">';
			echo get_avatar( 'email@example.com', 25 );
			echo ''.$author.'';
		echo '</div>';
	}
}

/*-----------------------------------------------------------------------------------*/
# Kategori
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_categories' ) ) {
	function geo_categories () {
		$category = get_the_category(); 

		if($category[0]->cat_name == "featured") {

				#if first category in array is "featured", get next category in line

				 $name = $category[1]->cat_name;
				 $cat_id = get_cat_ID( $name );
				 $link = get_category_link( $cat_id );
				 echo '<a href="'. esc_url( $link ) .'"">'. $name .'</a>';

		} else {

				#get the first category

				 $name = $category[0]->cat_name;
				 $cat_id = get_cat_ID( $name );
				 $link = get_category_link( $cat_id );
				 echo '<a class="geo_first_category" href="'. esc_url( $link ) .'">'. $name .'</a>';

		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Trendlerdeki Yazılar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_news_ticker' ) ) {
	function geo_news_ticker() {
		$status = ot_get_option('header-top-trend');
		$page 	= ot_get_option('geo-trending');
		
		if (!empty($page)) {
			$page = array(
				'tag' => 'a href="'.get_page_link($page).'"',
				'tag_end' => 'a',
			);
		} else {
			$page = array(
				'tag' => 'div',
				'tag_end' => 'div',
			);
		}
		
		$args = array(
			'meta_query' => array(
				array(
					'key' => 'geoit_post_trending',
					'value' => 'on',
					'compare' => '='
				)
			),
			'meta_key' => 'geoit_post_trending',
		  'orderby' => 'meta_value_num',
		  'order' => 'DESC',
		  'posts_per_page' => 10
		);
		
		$geoit_query = new WP_Query( $args );
		if ($status != 'off') {
			if ($geoit_query->have_posts()) {
				echo '<div id="news-ticker" class="news--ticker">';
				echo '<'.$page['tag'].' class="ticker-title" title="'.__('Trendlerdeki Yazılar', 'geo').'"><i class="fa fa-bolt"></i></'.$page['tag_end'].'>';
				echo '<ul id="sample" class="ticker">';
					while($geoit_query->have_posts()): $geoit_query->the_post();
						echo '<li>';
							echo the_title( sprintf( '<a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a>' );
						echo '</li>';
					endwhile;
					echo '</ul>';
				echo '</div>';
			}
		}
	}
}


/*-----------------------------------------------------------------------------------*/
# Onaylanmış Hesap
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_verified_user' ) ) {
	function geoit_verified_user($curauth) {
		$verified = get_the_author_meta('verified_user', $curauth); 
		if( $verified == 'yes') {
			echo '<label class="verify-geo" data-balloon="'.__('Onaylanmış Hesap', 'geo').'" data-balloon-pos="right"><i class="fa fa-check"></i></label>';
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Trendlerdeki Yazı - İkon
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_trending_post' ) ) {
	function geoit_trending_post($post) {
		$trending = get_post_meta($post, 'geoit_post_trending', true);
		$status 	= ot_get_option('geo_trending_status');
		if ($status != 'off') {
			if ($trending == 'on' ) {
				echo '<span class="geo_trending_post" data-balloon="'.__('Trendlerdeki Yazı', 'geo').'" data-balloon-pos="top"><i class="fa fa-bolt"></i></span>';
			}
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Trendlerdeki Yazı - Text + İkon
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_trending_entry' ) ) {
	function geoit_trending_entry($post) {
		$trending = get_post_meta($post, 'geoit_post_trending', true);
		$status 	= ot_get_option('geo_trending_status');
		if ($status != 'off') {
			if ($trending == 'on' ) {
				echo '<div class="trending-post"><div><span class="geo_trending_post fa fa-bolt"></i></span> '.__('Trendlerdeki Yazı', 'geo').'</div></div>';
			}
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Panel Çubuğunun Durumu
/*-----------------------------------------------------------------------------------*/
add_action('after_setup_theme', 'remove_admin_bar');
if ( ! function_exists( 'remove_admin_bar' ) ) {
	function remove_admin_bar() {
		if (ot_get_option('geo_admin_bar') != 'off' ) {
			if (!current_user_can('administrator') && !is_admin()) {
				show_admin_bar(false);
			}
		}
		if (ot_get_option('geo_admin_bar_2') != 'off' ) {
			if (current_user_can('administrator') && !is_admin()) {
				show_admin_bar(false);
			}
		}
	}
}
/*-----------------------------------------------------------------------------------*/
# Stil Dosyaları
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_styles' ) ) {
	function geo_styles() {
		wp_enqueue_style('geoit-css', get_template_directory_uri() . '/assets/css/geoit.css', array(), THEME_VER);
	}
}
add_action( 'wp_enqueue_scripts', 'geo_styles' );

/*-----------------------------------------------------------------------------------*/
# JS Dosyaları
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_scripts' ) ) {
	function geo_scripts() {
		
		$localize = array(
			'loading' => get_template_directory_uri().'/assets/img/ajax.svg',
			'ajax' => admin_url( 'admin-ajax.php' ),
			'nonce' => wp_create_nonce( 'ajax-nonce' ),
			'geo_path' => get_template_directory_uri(),
			'geo_lazy' => ot_get_option('geoit_lazy_images'),
			
			'sticky' => ot_get_option('geo-sticky'),
			'infinite' => ot_get_option('geo-infinite'),
			'popup' => ot_get_option('geo_popup_box'),
			'is_single' => is_single(),
		);
		
		if (!is_singular()) {
			wp_deregister_style( 'wp-block-library' );
			wp_deregister_style( 'wp-block-library-theme' );
		}

		// jQuery
		wp_enqueue_script( 'geo_jquery', get_template_directory_uri().'/assets/js/app/app.min.js', array('jquery'), THEME_VER, true );
	
		
		// Popup
		if (ot_get_option('geo_popup_box') == 'on' || ot_get_option('geo_cookie_box') == 'on' || ot_get_option('geo-6-ads') != '')
			wp_enqueue_script( 'geo_popup', get_template_directory_uri().'/assets/js/popup.min.js', array(), THEME_VER, true );


		// Stories
		if((ot_get_option('geoit_stories') == 'on') || (ot_get_option('geoit_story_cats') && ot_get_option('geoit_story_site')) ) {
			if (ot_get_option('geoit_stories_page')== 'on') {
				wp_enqueue_script( 'geo_zuck', get_template_directory_uri().'/assets/js/zuck.min.js', array(), THEME_VER, true );
			}
			else {
				if(is_front_page())
					wp_enqueue_script( 'geo_zuck', get_template_directory_uri().'/assets/js/zuck.min.js', array(), THEME_VER, true );
			}
		}
		
		// JS Vars
		wp_localize_script( 'geo_jquery', 'geo_vars', $localize);
		
		if ( is_singular() && comments_open() && get_option('thread_comments') ){
			wp_enqueue_script( 'comment-reply' );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'geo_scripts', 10 );

function remove_head_scripts() {
	remove_action('wp_head', 'wp_print_scripts');
	remove_action('wp_head', 'wp_print_head_scripts', 9);
	remove_action('wp_head', 'wp_enqueue_scripts', 1);

	add_action('wp_footer', 'wp_print_scripts', 5);
	add_action('wp_footer', 'wp_enqueue_scripts', 5);
	add_action('wp_footer', 'wp_print_head_scripts', 5);
}
add_action( 'wp_enqueue_scripts', 'remove_head_scripts' );

function geoit_custom_customize_enqueue() {
	wp_enqueue_style( 'geoit-customizer-css', get_stylesheet_directory_uri() . '/assets/css/customizer.css' );
}
add_action( 'customize_controls_enqueue_scripts', 'geoit_custom_customize_enqueue' );

/*-----------------------------------------------------------------------------------*/
# Yorumları Listele
/*-----------------------------------------------------------------------------------*/
function pressfore_comment_time_output($date, $d, $comment){
	return sprintf( _x( '%s önce', '%s = human-readable time difference', 'geo' ), human_time_diff( get_comment_time( 'U' ), current_time( 'timestamp' ) ) );
}
add_filter('get_comment_date', 'pressfore_comment_time_output', 10, 3);
if (!function_exists('geo_comment')) :
    function geo_comment($comment, $args, $depth)
    {
        $GLOBALS['comment'] = $comment;
        switch ($comment->comment_type) :
            case 'pingback' :
            case 'trackback' : ?>

                <?php
                break;
            default :
                # Proceed with normal comments.
                global $post; ?>

                <li <?php comment_class(); ?>  id="comment-<?php comment_ID(); ?>">
                  <div class="geoit_comment">
											<div class="geoit_comment_avatar">
                        <?php echo get_avatar($comment, 80); ?>
											</div>
											<div class="geoit_comment_detail vcard" itemtype="http://schema.org/Comment" itemscope="itemscope" itemprop="comment">
												<div class="geoit_comment_meta">
													<span class="geoit_comment_author comment-author vcard">
													<?php 
													 $comment_url = $comment->comment_author_url;
													 $comment_author = get_comment_author();
													 if ($comment_url != '') {
														 echo '<a itemprop="author" class="fn" href="'.$comment_url.'">'.$comment_author.'</a>';
													 }
													 else {
														 echo '<cite itemprop="author" class="fn">'.$comment_author.'</cite>';
													 }
													 $commentid_geo = $comment->user_id;
														$verified = get_the_author_meta('verified_user', $commentid_geo); 
														if( $verified == 'yes' && $commentid_geo != '0') {
															echo '<label class="verify-geo" data-balloon="'.__('Onaylanmış Hesap', 'geo').'" data-balloon-pos="right"><i class="fa fa-check"></i></label>';
														} 
													?>
													</span>
													<span  class="date"> 
														<a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
														<?php echo get_comment_date(); ?>
														</a>
													</span>
												</div>
												<div class="geoit_comment_text comment-content" itemprop="text">
												<?php if ('0' == $comment->comment_approved) : ?>
													<p class="comment-awaiting-moderation"><?php _e(
														'Yorumunuz editörümüz tarafından incelendikten sonra uygunsa yayına alınacaktır, teşekkürler.',
														'geo'
													); ?></p>
												<?php endif; ?>
												<?php comment_text(); ?>
												</div>
												<div class="geoit_comment_footer">
													<?php comment_reply_link( array_merge($args, array(
													'reply_text' => __('Cevapla', 'geo'),
													'respond_id' => 'respond',    
													'depth'      => $depth,
													'max_depth'  => $args['max_depth']
												)
											)); ?>
											<?php edit_comment_link(__('Düzenle', 'geo'), '', '') ?>
												</div>
											</div>
									
									</div>
                 </li>
								 <div class="clearfix"></div>
                <?php
                break;
        endswitch;
    }
endif;

/*-----------------------------------------------------------------------------------*/
# Okunma Süresi
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_reading_time' ) ) {
	function geoit_reading_time($post) {
		if (ot_get_option('reading-time') != 'off') {
			$uckicerik = $post->post_content; # yazı iceriğini çekiyor
			$word = str_word_count(strip_tags($uckicerik)); # içerikteki kelime sayısını hesaplıyor
			$m = floor($word / 200); # kelime sayısını 200'e bölerek dakika sayısını hesaplıyor
			$s = floor($word % 200 / (200 / 60)); # kelime sayısının %200'ünü alıp 3.33'e bölerek saniyeyi hesaplıyor
			echo '<span class="reading-time"><i class="fa fa-bookmark-o"></i> ';
			echo __('Okuma süresi:', 'geo');
			$uckokunma = ' '.$m . __('dk', 'geo') . ($m == 1 ? '' : '') . ', ' . $s . __('sn', 'geo') . ($s == 1 ? '' : '');
			echo $uckokunma;
			echo '</span>';
		}
	}
}
/*-----------------------------------------------------------------------------------*/
# Galeri Sayfalama
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'tp_link_pages' ) ) {
	function tp_link_pages() {
			global $page, $numpages;

			echo paginate_links( array(
					'base' => get_permalink() . '/%#%/',
					'format' => get_permalink() . '/%#%/',
					'current' => $page,
					'total' => $numpages,
					'next_text' => '<i class="fa fa-long-arrow-right"></i>',
					'prev_text' => '<i class="fa fa-long-arrow-left"></i>',
			) );
	}
}
/*-----------------------------------------------------------------------------------*/
# Body class
/*-----------------------------------------------------------------------------------*/
add_filter( 'body_class','my_body_classes' );
if ( ! function_exists( 'my_body_classes' ) ) {
	function my_body_classes( $classes ) {
			$dark_theme = ot_get_option('dark_theme');
			$infinite = ot_get_option('geo-infinite');
			if ($dark_theme == 'on') {
				$classes[] = 'dark-mode';
			}
			else {
				$classes[] = 'light-mode';
			}
			if ($infinite == 'on') {
				$classes[] = 'infinite-active';
			}
			else {
				$classes[] = 'infinite-disable';
			}
			if(ot_get_option('geoit_lazy_images') == 'on') {
				$classes[] = 'lazyload-active';
			}
			return $classes;
			 
	}
}
/*-----------------------------------------------------------------------------------*/
# Sidebar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_xxx_sidebar' ) ) {
	function geo_xxx_sidebar() {
			if ( is_home() && ! is_paged() ) { ?>
			<div class="container">
				<div class="row">
					<div class="widget-area full-width col-md-12">
						<?php dynamic_sidebar( 'Homepage Full Width' ); ?>
					</div>
				</div>
			</div>
	<?php } 
	}
}
add_action( 'geo_sidebar', 'geo_xxx_sidebar', 15 );
/*-----------------------------------------------------------------------------------*/
# Post Format
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_post_formats' ) ) {
	function geo_post_formats() {
		$format = get_post_format(); if (false === $format) $format = 'standard';
		if ($format == 'gallery') : ?>
			<div class="geo-post-format"><svg xmlns="http://www.w3.org/2000/svg" height="512pt" viewBox="0 0 512 512" width="512pt"><path d="m452 70h-40v-10c0-33.085938-26.914062-60-60-60h-192c-33.085938 0-60 26.914062-60 60v10h-40c-33.085938 0-60 26.914062-60 60v251c0 33.085938 26.914062 60 60 60h40v11c0 33.085938 26.914062 60 60 60h192c33.085938 0 60-26.914062 60-60v-11h40c33.085938 0 60-26.914062 60-60v-251c0-33.085938-26.914062-60-60-60zm-392 331c-11.027344 0-20-8.972656-20-20v-251c0-11.027344 8.972656-20 20-20h40v291zm312 51c0 11.027344-8.972656 20-20 20h-192c-11.027344 0-20-8.972656-20-20v-392c0-11.027344 8.972656-20 20-20h192c11.027344 0 20 8.972656 20 20zm100-71c0 11.027344-8.972656 20-20 20h-40v-291h40c11.027344 0 20 8.972656 20 20zm0 0"/></svg></div>
		<?php elseif ($format == 'video') : ?>
			<div class="geo-post-format">
<svg enable-background="new 0 0 407.51 407.51" version="1.1" viewBox="0 0 407.51 407.51" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
			<path d="m260.18 252.34l-99.788-58.514c-3-2.022-6.926-2.022-9.927 0-2.95 1.941-4.565 5.371-4.18 8.882v117.03c-0.385 3.51 1.229 6.941 4.18 8.882l4.702 1.567c1.863 0.038 3.691-0.51 5.224-1.567l99.788-58.514c4.905-2.448 6.897-8.41 4.448-13.315-0.96-1.928-2.522-3.489-4.447-4.45zm-92.996 49.11v-80.457l68.441 40.229-68.441 40.228z"/>
			<path d="m360.49 112.33h-313.47c-25.969 0-47.02 21.052-47.02 47.02v198.53c0 25.969 21.052 47.02 47.02 47.02h313.47c25.969 0 47.02-21.052 47.02-47.02v-198.53c0-25.969-21.052-47.02-47.02-47.02zm26.122 245.55c0 14.427-11.695 26.122-26.122 26.122h-313.47c-14.427 0-26.122-11.695-26.122-26.122v-198.53c0-14.427 11.695-26.122 26.122-26.122h313.47c14.427 0 26.122 11.695 26.122 26.122v198.53z"/>
			<path d="m53.812 80.98h300.41c5.771 0 10.449-4.678 10.449-10.449s-4.678-10.449-10.449-10.449h-300.41c-5.771 0-10.449 4.678-10.449 10.449s4.678 10.449 10.449 10.449z"/>
			<path d="M98.22,23.51H309.29c5.771,0,10.449-4.678,10.449-10.449S315.061,2.612,309.29,2.612H98.22     c-5.771,0-10.449,4.678-10.449,10.449S92.45,23.51,98.22,23.51z"/>
</svg>
</div>
		<?php elseif ($format == 'audio') : ?>
			<div class="geo-post-format"><i class="fa fa-music"></i></div>
		<?php else:
		endif;
	}
}

/*-----------------------------------------------------------------------------------*/
# Mobil için paylaşma butonları
/*-----------------------------------------------------------------------------------*/
function geo_mobile_share() { 
	global $post;
	$style = ot_get_option('social_share');
	if ($style != 'off'): ?>
	<div class="geo_mobile_share">
		<ul>
			<li><a class="facebook" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php echo get_permalink(); ?>" data-balloon="<?php _e('Facebook\'ta Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-facebook"></div></a></li>
			<li><a target="_blank" class="twitter" href="http://www.twitter.com/intent/tweet?text=<?php echo get_the_title(); ?> via <?php echo get_permalink(); ?>" data-balloon="<?php _e('Twitter\'da Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-twitter"></div></a></li>
			<li><a target="_blank" class="whatsapp" href="whatsapp://send?text=<?php echo get_permalink(); ?>" data-balloon="<?php _e("Whatsapp'ta Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-whatsapp"></div></a></li>
			<?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>
			<li><a target="_blank" class="pinterest" href="https://pinterest.com/pin/create/button/?url=&media=<?php echo $image[0]; ?>&description=<?php echo get_permalink(); ?>" data-balloon="<?php _e("Pinterest'te Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-pinterest"></div></a></li>
			<li><a target="_blank" class="mail" onclick="window.open('https://mail.google.com/mail/u/0/?view=cm&fs=1&to&su=<?php echo get_the_title(); ?>&body=<?php echo get_permalink(); ?>&ui=2&tf=1','mail','width=600,height=400')" href="https://mail.google.com/mail/u/0/?view=cm&fs=1&to&su=<?php echo get_the_title();?>&body=<?php echo get_permalink(); ?>&ui=2&tf=1" data-balloon="<?php _e('Gmail ile Gönder', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-envelope "></div></a></li>
		</ul>
	</div>
	<?php endif;
}

/*-----------------------------------------------------------------------------------*/
# Avatar
/*-----------------------------------------------------------------------------------*/
class basic_user_avatars {

	/**
	 * User ID
	 *
	 * @since 1.0.0
	 * @var int
	 */
	private $user_id_being_edited;

	/**
	 * Initialize all the things
	 *
	 * @since 1.0.0
	 */
	public function __construct() {


		// Actions
		add_action( 'admin_init',                array( $this, 'admin_init'               )        );
		add_action( 'show_user_profile',         array( $this, 'edit_user_profile'        )        );
		add_action( 'edit_user_profile',         array( $this, 'edit_user_profile'        )        );
		add_action( 'personal_options_update',   array( $this, 'edit_user_profile_update' )        );
		add_action( 'edit_user_profile_update',  array( $this, 'edit_user_profile_update' )        );
		add_action( 'bbp_user_edit_after_about', array( $this, 'bbpress_user_profile'     )        );

		// Filters
		add_filter( 'get_avatar',                array( $this, 'get_avatar'               ), 10, 5 );
		add_filter( 'avatar_defaults',           array( $this, 'avatar_defaults'          )        );
	}

	/**
	 * Start the admin engine.
	 *
	 * @since 1.0.0
	 */
	public function admin_init() {

		// Register/add the Discussion setting to restrict avatar upload capabilites
		register_setting( 'discussion', 'basic_user_avatars_caps', array( $this, 'sanitize_options' ) );
		add_settings_field( 'basic-user-avatars-caps', __( 'Local Avatar Permissions', 'geo' ), array( $this, 'avatar_settings_field' ), 'discussion', 'avatars' );
	}

	/**
	 * Discussion settings option
	 *
	 * @since 1.0.0
	 * @param array $args [description]
	 */
	public function avatar_settings_field( $args ) {
		$options = get_option( 'basic_user_avatars_caps' );
		?>
		<label for="basic_user_avatars_caps">
			<input type="checkbox" name="basic_user_avatars_caps" id="basic_user_avatars_caps" value="1" <?php checked( $options['basic_user_avatars_caps'], 1 ); ?>/>
			<?php _e( 'Only allow users with file upload capabilities to upload local avatars (Authors and above)', 'geo' ); ?>
		</label>
		<?php
	}

	/**
	 * Sanitize the Discussion settings option
	 *
	 * @since 1.0.0
	 * @param array $input
	 * @return array
	 */
	public function sanitize_options( $input ) {
		$new_input['basic_user_avatars_caps'] = empty( $input['basic_user_avatars_caps'] ) ? 0 : 1;
		return $new_input;
	}

	/**
	 * Filter the avatar WordPress returns
	 *
	 * @since 1.0.0
	 * @param string $avatar 
	 * @param int/string/object $id_or_email
	 * @param int $size 
	 * @param string $default
	 * @param boolean $alt 
	 * @return string
	 */
	public function get_avatar( $avatar = '', $id_or_email, $size = 96, $default = '', $alt = false ) {

		// Determine if we recive an ID or string
		if ( is_numeric( $id_or_email ) )
			$user_id = (int) $id_or_email;
		elseif ( is_string( $id_or_email ) && ( $user = get_user_by( 'email', $id_or_email ) ) )
			$user_id = $user->ID;
		elseif ( is_object( $id_or_email ) && ! empty( $id_or_email->user_id ) )
			$user_id = (int) $id_or_email->user_id;

		if ( empty( $user_id ) )
			return $avatar;

		$local_avatars = get_user_meta( $user_id, 'basic_user_avatar', true );

		if ( empty( $local_avatars ) || empty( $local_avatars['full'] ) )
			return $avatar;

		$size = (int) $size;

		if ( empty( $alt ) )
			$alt = get_the_author_meta( 'display_name', $user_id );

		// Generate a new size
		if ( empty( $local_avatars[$size] ) ) {

			$upload_path      = wp_upload_dir();
			$avatar_full_path = str_replace( $upload_path['baseurl'], $upload_path['basedir'], $local_avatars['full'] );
			$image            = wp_get_image_editor( $avatar_full_path );
			$image_sized      = null;

			if ( ! is_wp_error( $image ) ) {
				$image->resize( $size, $size, true );
				$image_sized = $image->save();
			}

			// Deal with original being >= to original image (or lack of sizing ability).
			if ( empty( $image_sized ) || is_wp_error( $image_sized ) ) {
				$local_avatars[ $size ] = $local_avatars['full'];
			} else {
				$local_avatars[ $size ] = str_replace( $upload_path['basedir'], $upload_path['baseurl'], $image_sized['path'] );
			}

			// Save updated avatar sizes
			update_user_meta( $user_id, 'basic_user_avatar', $local_avatars );

		} elseif ( substr( $local_avatars[$size], 0, 4 ) != 'http' ) {
			$local_avatars[$size] = home_url( $local_avatars[$size] );
		}

		$author_class = is_author( $user_id ) ? ' current-author' : '' ;
		$avatar       = "<img alt='" . esc_attr( $alt ) . "' src='" . $local_avatars[$size] . "' class='avatar avatar-{$size}{$author_class} photo' height='{$size}' width='{$size}' />";

		return apply_filters( 'basic_user_avatar', $avatar );
	}

	/**
	 * Form to display on the user profile edit screen
	 *
	 * @since 1.0.0
	 * @param object $profileuser
	 * @return
	 */
	public function edit_user_profile( $profileuser ) {

		// bbPress will try to auto-add this to user profiles - don't let it.
		// Instead we hook our own proper function that displays cleaner.
		if ( function_exists( 'is_bbpress') && is_bbpress() )
			return;
		?>

		<h3><?php _e( 'Profil Fotoğrafı', 'geo' ); ?><?php if(!is_admin()): ?><?php if(ot_get_option('geo_puan_sistem') == 'on'): ?><span class="puan_label geo_trending_post" data-balloon-pos="top" data-balloon="<?php printf( __('Tek seferliğine %1$s puan kazandırır.', 'geo'), ot_get_option('geo_puan_cover'));?>"><i class="fa fa-question"></i></span><?php endif; ?><?php endif; ?></h3>
		<table class="form-table form-avatar">
			<tr>

				<td style="width: 50px;" valign="top">
					<?php echo get_avatar( $profileuser->ID ); ?>
				</td>
				<td>
				<?php
				$options = get_option( 'basic_user_avatars_caps' );
				if ( empty( $options['basic_user_avatars_caps'] ) || current_user_can( 'upload_files' ) ) {
					// Nonce security ftw
					wp_nonce_field( 'basic_user_avatar_nonce', '_basic_user_avatar_nonce', false );
					
					// File upload input
					echo '<input type="file" name="basic-user-avatar" id="basic-local-avatar" /><br />';

					if ( empty( $profileuser->basic_user_avatar ) ) {
						echo '<span class="description">' . __( 'Profil fotoğrafı yüklemek için yükleme alanını kullanabilirsiniz.', 'geo' ) . '</span>';
					} else {
						echo '<input type="checkbox" name="basic-user-avatar-erase" value="1" /> ' . __( 'Avatarımı Kaldır', 'geo' ) . '<br />';
					}

				} else {
					if ( empty( $profileuser->basic_user_avatar ) ) {
						echo '<span class="description">' . __( 'No local avatar is set. Set up your avatar at Gravatar.com.', 'geo' ) . '</span>';
					} else {
						echo '<span class="description">' . __( 'You do not have media management permissions. To change your local avatar, contact the site administrator.', 'geo' ) . '</span>';
					}	
				}
				?>
				</td>
			</tr>
		</table>
		<script type="text/javascript">var form = document.getElementById('your-profile');form.encoding = 'multipart/form-data';form.setAttribute('enctype', 'multipart/form-data');</script>
		<?php
	}

	/**
	 * Update the user's avatar setting
	 *
	 * @since 1.0.0
	 * @param int $user_id
	 */
	public function edit_user_profile_update( $user_id ) {

		// Check for nonce otherwise bail
		if ( ! isset( $_POST['_basic_user_avatar_nonce'] ) || ! wp_verify_nonce( $_POST['_basic_user_avatar_nonce'], 'basic_user_avatar_nonce' ) )
			return;

		if ( ! empty( $_FILES['basic-user-avatar']['name'] ) ) {
			
			$filename = $_FILES['basic-user-avatar']['name'];
			$ext = pathinfo($filename, PATHINFO_EXTENSION);
			$allowed = array('jpg', 'png', 'jpeg');
			if( in_array( $ext, $allowed ) ){
				

				// Allowed file extensions/types
				$mimes = array(
					'jpg|jpeg|jpe' => 'image/jpeg',
					'png'          => 'image/png',
				);

				// Front end support - shortcode, bbPress, etc
				if ( ! function_exists( 'wp_handle_upload' ) )
					require_once ABSPATH . 'wp-admin/includes/file.php';

				// Delete old images if successful
				$this->avatar_delete( $user_id );


				// Make user_id known to unique_filename_callback function
				$this->user_id_being_edited = $user_id; 
				$avatar = wp_handle_upload( $_FILES['basic-user-avatar'], array( 'mimes' => $mimes, 'test_form' => false, 'unique_filename_callback' => array( $this, 'unique_filename_callback' ) ) );

				// Handle failures
				if ( empty( $avatar['file'] ) ) {  
					switch ( $avatar['error'] ) {
					case 'File type does not meet security guidelines. Try another.' :
						add_action( 'user_profile_update_errors', create_function( '$a', '$a->add("avatar_error",__("Please upload a valid image file for the avatar.","basic-user-avatars"));' ) );
						break;
					default :
						add_action( 'user_profile_update_errors', create_function( '$a', '$a->add("avatar_error","<strong>".__("There was an error uploading the avatar:","basic-user-avatars")."</strong> ' . esc_attr( $avatar['error'] ) . '");' ) );
					}
					return;
				}
				
				update_user_meta( $user_id, 'basic_user_avatar', array( 'full' => $avatar['url'] ) );
			
				}
				else {
					wp_die(__('Yüklemeye çalıştığınız dosya uzantısı kabul edilmemektedir. Sadece jpg, jpeg ve png uzantılı dosya yükleyebilirsiniz.', 'geo'));
				}
			} elseif ( ! empty( $_POST['basic-user-avatar-erase'] ) ) {
				
			// Nuke the current avatar
			$this->avatar_delete( $user_id );
			
			
			
			}
	}

	/**
	 * Enable avatar management on the frontend via this shortocde.
	 *
	 * @since 1.0.0
	 */
	function shortcode() {

		// Don't bother if the user isn't logged in
		if ( ! is_user_logged_in() )
			return;

		$user_id     = get_current_user_id();
		$profileuser = get_userdata( $user_id );

		if ( isset( $_POST['manage_avatar_submit'] ) ){
			$this->edit_user_profile_update( $user_id );
		}

		ob_start();
		?>
		<form id="basic-user-avatar-form" action="<?php the_permalink(); ?>" method="post" enctype="multipart/form-data">
			<?php
			echo get_avatar( $profileuser->ID );

			$options = get_option( 'basic_user_avatars_caps' );
			if ( empty( $options['basic_user_avatars_caps'] ) || current_user_can( 'upload_files' ) ) {
				// Nonce security ftw
				wp_nonce_field( 'basic_user_avatar_nonce', '_basic_user_avatar_nonce', false );
				
				// File upload input
				echo '<p><input type="file" name="basic-user-avatar" id="basic-local-avatar" /></p>';

				if ( empty( $profileuser->basic_user_avatar ) ) {
					echo '<p class="description">' . __( 'No local avatar is set. Use the upload field to add a local avatar.', 'geo' ) . '</p>';
				} else {
					echo '<input type="checkbox" name="basic-user-avatar-erase" value="1" /> ' . __( 'Delete local avatar', 'geo' ) . '<br />';
					echo '<p class="description">' . __( 'Replace the local avatar by uploading a new avatar, or erase the local avatar (falling back to a gravatar) by checking the delete option.', 'geo' ) . '</p>';
				}

			} else {
				if ( empty( $profileuser->basic_user_avatar ) ) {
					echo '<p class="description">' . __( 'No local avatar is set. Set up your avatar at Gravatar.com.', 'geo' ) . '</p>';
				} else {
					echo '<p class="description">' . __( 'You do not have media management permissions. To change your local avatar, contact the site administrator.', 'geo' ) . '</p>';
				}	
			}
			?>
			<input type="submit" name="manage_avatar_submit" value="<?php _e( 'Update Avatar', 'geo' ); ?>" />
		</form>
		<?php
		return ob_get_clean();
	}

	/**
	 * Form to display on the bbPress user profile edit screen
	 *
	 * @since 1.0.0
	 */
	public function bbpress_user_profile() {

		if ( !bbp_is_user_home_edit() )
			return;

		$user_id     = get_current_user_id();
		$profileuser = get_userdata( $user_id );

		echo '<div>';
			echo '<label for="basic-local-avatar">' . __( 'Avatar', 'geo' ) . '</label>';
 			echo '<fieldset class="bbp-form avatar">';

	 			echo get_avatar( $profileuser->ID );
				$options = get_option( 'basic_user_avatars_caps' );
				if ( empty( $options['basic_user_avatars_caps'] ) || current_user_can( 'upload_files' ) ) {
					// Nonce security ftw
					wp_nonce_field( 'basic_user_avatar_nonce', '_basic_user_avatar_nonce', false );
					
					// File upload input
					echo '<br /><input type="file" name="basic-user-avatar" id="basic-local-avatar" /><br />';

					if ( empty( $profileuser->basic_user_avatar ) ) {
						echo '<span class="description" style="margin-left:0;">' . __( 'No local avatar is set. Use the upload field to add a local avatar.', 'geo' ) . '</span>';
					} else {
						echo '<input type="checkbox" name="basic-user-avatar-erase" value="1" style="width:auto" /> ' . __( 'Delete local avatar', 'geo' ) . '<br />';
						echo '<span class="description" style="margin-left:0;">' . __( 'Replace the local avatar by uploading a new avatar, or erase the local avatar (falling back to a gravatar) by checking the delete option.', 'geo' ) . '</span>';
					}

				} else {
					if ( empty( $profileuser->basic_user_avatar ) ) {
						echo '<span class="description" style="margin-left:0;">' . __( 'No local avatar is set. Set up your avatar at Gravatar.com.', 'geo' ) . '</span>';
					} else {
						echo '<span class="description" style="margin-left:0;">' . __( 'You do not have media management permissions. To change your local avatar, contact the site administrator.', 'geo' ) . '</span>';
					}	
				}

			echo '</fieldset>';
		echo '</div>';
		?>
		<script type="text/javascript">var form = document.getElementById('bbp-your-profile');form.encoding = 'multipart/form-data';form.setAttribute('enctype', 'multipart/form-data');</script>
		<?php
	}

	/**
	 * Remove the custom get_avatar hook for the default avatar list output on 
	 * the Discussion Settings page.
	 *
	 * @since 1.0.0
	 * @param array $avatar_defaults
	 * @return array
	 */
	public function avatar_defaults( $avatar_defaults ) {
		remove_action( 'get_avatar', array( $this, 'get_avatar' ) );
		return $avatar_defaults;
	}

	/**
	 * Delete avatars based on user_id
	 *
	 * @since 1.0.0
	 * @param int $user_id
	 */
	public function avatar_delete( $user_id ) {
		$old_avatars = get_user_meta( $user_id, 'basic_user_avatar', true );
		$upload_path = wp_upload_dir();

		if ( is_array( $old_avatars ) ) {
			foreach ( $old_avatars as $old_avatar ) {
				$old_avatar_path = str_replace( $upload_path['baseurl'], $upload_path['basedir'], $old_avatar );
				@unlink( $old_avatar_path );
			}
		}

		delete_user_meta( $user_id, 'basic_user_avatar' );
	}

	/**
	 * File names are magic
	 *
	 * @since 1.0.0
	 * @param string $dir
	 * @param string $name
	 * @param string $ext
	 * @return string
	 */
	public function unique_filename_callback( $dir, $name, $ext ) {
		$user = get_user_by( 'id', (int) $this->user_id_being_edited );
		$name = $base_name = sanitize_file_name( $user->display_name . '_avatar' );
		$number = 1;

		while ( file_exists( $dir . "/$name$ext" ) ) {
			$name = $base_name . '_' . $number;
			$number++;
		}

		return $name . $ext;
	}
}
$basic_user_avatars = new basic_user_avatars;

/**
 * During uninstallation, remove the custom field from the users and delete the local avatars
 *
 * @since 1.0.0
 */
function basic_user_avatars_uninstall() {
	$basic_user_avatars = new basic_user_avatars;
	$users = get_users_of_blog();

	foreach ( $users as $user )
		$basic_user_avatars->avatar_delete( $user->user_id );

	delete_option( 'basic_user_avatars_caps' );
}
register_uninstall_hook( __FILE__, 'basic_user_avatars_uninstall' );



// Upload File
function upload_user_file( $file = array() ) {
	require_once( ABSPATH . 'wp-admin/includes/admin.php' );
			$mimes = array(
				'jpg|jpeg|jpe' => 'image/jpeg',
				'png'          => 'image/png',
			);
      $file_return = wp_handle_upload( $file, array('mimes' => $mimes, 'test_form' => false ) );
			
      if( isset( $file_return['error'] ) || isset( $file_return['upload_error_handler'] ) ) {
          return false;
      } else {
          $filename = $file_return['file'];
          $attachment = array(
              'post_mime_type' => $file_return['type'],
              'post_title' => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),
              'post_content' => '',
              'post_status' => 'inherit',
              'guid' => $file_return['url']
          );
          $attachment_id = wp_insert_attachment( $attachment, $file_return['file'] );
          require_once(ABSPATH . 'wp-admin/includes/image.php');
          $attachment_data = wp_generate_attachment_metadata( $attachment_id, $filename );
          wp_update_attachment_metadata( $attachment_id, $attachment_data );
          if( 0 < intval( $attachment_id ) ) {
          	return $attachment_id;
          }
      }
      return false;
}



/*-----------------------------------------------------------------------------------*/
# Emojileri Kaldır
/*-----------------------------------------------------------------------------------*/
function disable_emojis() {
	if(!is_singular()) {
	 remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	}
}
add_action( 'init', 'disable_emojis' );

/*-----------------------------------------------------------------------------------*/
# Get Avatar
/*-----------------------------------------------------------------------------------*/
function geoit_get_avatar($author, $size) {
	$out = '';
	$nick = get_the_author_meta('user_nicename', $author);
	$avatar = get_user_meta( $author, 'basic_user_avatar', true );
	if (empty($avatar)) {
		$avatar = get_avatar_url($author, array("size" => $size));
	} else {
		$avatar = $avatar['full'];
	}
	if(ot_get_option('geoit_lazy_images') == 'on') {
		$out = '<img width="'.$size.'" height="'.$size.'" class="geo-lazy" alt="'.$nick.'_avatar" data-src="'.$avatar.'" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mPk5ODkAQAAZAAoQWYOjQAAAABJRU5ErkJggg==">';
	} else {
		$out = get_avatar( $author, $size );
	}
	return $out;
}

/*-----------------------------------------------------------------------------------*/
# Get Post Thumbnail {background-image}
/*-----------------------------------------------------------------------------------*/
function geoit_thumbnail_background_image($thumbnail_id, $size, $class = 'w-slider_image') {
	if(ot_get_option('geoit_lazy_images') == 'on') {
		if ( $image_src = wp_get_attachment_image_src( $thumbnail_id, $size) ) {
			echo 'class="'.$class.' owl-lazy" data-src="'.$image_src[0].'"';
		}
		else {
		    echo 'class="'.$class.'"';
		}
	} else {
		if ( $image_src = wp_get_attachment_image_src( $thumbnail_id, $size) ) {
			echo 'class="'.$class.'" style="background-image: url('.$image_src[0].')"';
		}
		else {
		    echo 'class="'.$class.'"';
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Get Post Thumbnail2 {background-image}
/*-----------------------------------------------------------------------------------*/
function geoit_thumbnail_background_image2($thumbnail_id, $size, $class = 'w-slider_image') {
	if(ot_get_option('geoit_lazy_images') == 'on') {
		if ( $image_src = wp_get_attachment_image_src( $thumbnail_id, $size) ) {
			echo 'class="'.$class.' geo-lazy" data-src="'.$image_src[0].'"';
		} else {
			echo 'class="'.$class.'"';
		}
	} else {
		if ( $image_src = wp_get_attachment_image_src( $thumbnail_id, $size) ) {
			echo 'class="'.$class.'" style="background-image: url('.$image_src[0].')"';
		} else {
		    echo 'class="'.$class.'"';
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Kullanıcı Kayıt Tarihi
/*-----------------------------------------------------------------------------------*/
function add_custom_user_profile_fields( $user ){
	$udata = get_userdata( $user->ID );
	$registered = $udata->user_registered;
	return date_i18n( "j M Y", strtotime( $registered ));
}

/*-----------------------------------------------------------------------------------*/
# Footer 
/*-----------------------------------------------------------------------------------*/
add_action('geoit_footer', 'geoit_popup', 10);
add_action('geoit_footer', 'geoit_login', 20);
add_action('geoit_footer', 'geo_mobil_close', 30);
add_action('geoit_footer', 'geo_mobil_menu', 40);
add_action('geoit_footer', 'geo_social_links', 50);
add_action('geoit_footer', 'geo_mobil_lr', 60);
add_action('geoit_footer', 'geoit_footer_temps', 999);
/*-----------------------------------------------------------------------------------*/
# Footer #1
/*-----------------------------------------------------------------------------------*/
function geoit_footer_temps() {
	$footer = ot_get_option( 'footer-layout-select' );
	if ($footer == '2') {
		get_template_part('frameworks/template-parts/footer/footer-2' );
	} else {
		get_template_part('frameworks/template-parts/footer/footer-1' );
	}
}

/*-----------------------------------------------------------------------------------*/
# Filter: Navigation Markup Template
/*-----------------------------------------------------------------------------------*/
function change_reader_heading( $template, $class ) {

    $template = str_replace( 'h2', 'div', $template );

    return $template;
}
add_filter( 'navigation_markup_template', 'change_reader_heading', 10, 2 );

/*-----------------------------------------------------------------------------------*/
# Geoit Stories
/*-----------------------------------------------------------------------------------*/
require_once get_template_directory() . '/frameworks/stories.php';

/*-----------------------------------------------------------------------------------*/
# Js Minifier
/*-----------------------------------------------------------------------------------*/
function geoit_minify_js($input) {
    if(trim($input) === "") return $input;
    return preg_replace(
        array(
            // Remove comment(s)
            '#\s*("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')\s*|\s*\/\*(?!\!|@cc_on)(?>[\s\S]*?\*\/)\s*|\s*(?<![\:\=])\/\/.*(?=[\n\r]|$)|^\s*|\s*$#',
            // Remove white-space(s) outside the string and regex
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/)|\/(?!\/)[^\n\r]*?\/(?=[\s.,;]|[gimuy]|$))|\s*([!%&*\(\)\-=+\[\]\{\}|;:,.<>?\/])\s*#s',
            // Remove the last semicolon
            '#;+\}#',
            // Minify object attribute(s) except JSON attribute(s). From `{'foo':'bar'}` to `{foo:'bar'}`
            '#([\{,])([\'])(\d+|[a-z_][a-z0-9_]*)\2(?=\:)#i',
            // --ibid. From `foo['bar']` to `foo.bar`
            '#([a-z0-9_\)\]])\[([\'"])([a-z_][a-z0-9_]*)\2\]#i'
        ),
        array(
            '$1',
            '$1$2',
            '}',
            '$1$3',
            '$1.$3'
        ),
    $input);
}

function geoit_register_custom_sidebar() {
	$sidebars = ot_get_option('geoit_custom_sidebars');
	$style = ot_get_option('block_title_style');
	$class = 'block_title_'.$style;
	
	if ($sidebars) {
		foreach($sidebars as $sidebar) {
			register_sidebar(array(
				'name' => $sidebar['title'],
				'description' => 'Özel olarak oluşturulmuş sidebar.',
				'id' => $sidebar['id'],
				'before_widget' => '<aside id="%1$s" class="widget widget-0 %2$s">',
				'after_widget' => '</aside>',
				'before_title' => '<div class="content__title '.$class.'"><h4 class="uckan-btn">',
				'after_title' => '</h4></div>',
			));
		}
	}
		
}
add_action( 'widgets_init', 'geoit_register_custom_sidebar' );

/*-----------------------------------------------------------------------------------*/
# Logo
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_site_logo' ) ) {
	function geoit_site_logo() {
		$m = [
			'img'  => ot_get_option('geo-logo'),
			'img-mobil'  => ot_get_option('geo-logo-mobil'),
			'name' => get_bloginfo('name'),
			'url'  => esc_url( get_home_url( '/' ))
		];
		$out = '';
		$lazy = ot_get_option('geoit_lazy_images');
		if($m['img-mobil'] !== '') {
			if (geo_is_mobile())
			$m['img'] = $m['img-mobil'];
		}
		if ($m['img']) {
			if (!is_singular())
			$out .= '<h1 class="screen-reader-text">'.$m['name'].'</h1>';
			if ($lazy == 'on')
			$out .= '<a href="'.$m['url'].'"><img class="geo-lazy" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mPk5ODkAQAAZAAoQWYOjQAAAABJRU5ErkJggg==" data-src="'.$m['img'].'" alt="'.$m['name'].'" title="'.$m['name'].'" /></a>';
			else
			$out .= '<a href="'.$m['url'].'"><img src="'.$m['img'].'" alt="'.$m['name'].'" title="'.$m['name'].'" /></a>';
		} else {
			$tag = 'h1';
			if (is_singular())
			$tag = 'div';
			$out .= '<'.$tag.'><a class="logo-no" href="'.$m['url'].'" title="'.$m['name'].'">'.$m['name'].'</a></'.$tag.'>'; 
		}
		return $out;
	}
}

/*-----------------------------------------------------------------------------------*/
# Gutenberg
/*-----------------------------------------------------------------------------------*/
function geoit_gutenberg_editor_css() {
    wp_enqueue_style(
        'paul-editor-style',
        get_stylesheet_directory_uri() . "/editor-styles.css",
        array(),
        '1.0'
    );
}
add_action('enqueue_block_editor_assets', 'geoit_gutenberg_editor_css');

add_action('admin_init', 'geoit_gutenberg_editor_font_load');
function geoit_gutenberg_editor_font_load() {
	global $pagenow;
	if ( $pagenow == 'post.php' ) {
		add_action('admin_head', 'dynamic_scripts');
	}
}

add_action('admin_head', 'geoit_gutenberg_editor_font');
function geoit_gutenberg_editor_font() {
	$font = get_theme_mod('geoit_theme_font');
	$first_big = ucwords(strtolower($font));
	$first_word2 = ucwords(strtolower($first_big), '_');
	$bul = '_';
	$degistir = ' ';
	$h_font = str_replace($bul, $degistir, $first_word2);
	if ($h_font == '') {
		$h_font = 'Poppins';
		$p_font = '-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif';
	} else {
	}
	$styles = '<style type="text/css">
		.editor-post-title__block .editor-post-title__input, .wp-block-heading , .wp-block-freeform h1, .wp-block-freeform h2, .wp-block-freeform h3, .wp-block-freeform h4, .wp-block-freeform h5, .wp-block-freeform h6{
			font-family: "'.$h_font.'","Noto Serif", serif !important
		}
		
	</style>';
	echo $styles;
}
