<?php
/**
 * Login functions
 *
 * @package Geoit
 * @duzenleme Kan Themes
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
function geoit_login_error_messages() {
	$serror = '';
	if ( is_user_logged_in() )
		return;
	if (isset($_GET['islem'])){
		Switch ($_GET['islem']){
			case 'basarisiz':
				$serror = __('Kullanıcı adınız veya şifreniz hatalı.', 'geo');
				break;
			case 'bos':
				$serror = __('Kullanıcı adınızı ve şifrenizi girin.', 'geo');
				break;
			case 'rc':
				$serror = __('Güvenlik doğrulamasını gerçekleştirin.', 'geo');
				break;
		}
	}
	return $serror;
}
add_action('init', 'geoit_login_error_messages');
/*-----------------------------------------------------------------------------------*/
# Yönlendirme: Wp Loginden Anasayfaya
/*-----------------------------------------------------------------------------------*/
if( ! function_exists( 'possibly_redirect' )){
	function possibly_redirect(){
		if (ot_get_option('geo_yonlendirme') == 'on' && geoit__get__status() == true) {
			global $pagenow;
			if( 'wp-login.php' == $pagenow ) {
				if ( isset( $_POST['wp-submit'] ) ||   // in case of LOGIN
					( isset($_GET['action']) && $_GET['action']=='logout') ||   // in case of LOGOUT
					( isset($_GET['checkemail']) && $_GET['checkemail']=='confirm') ||   // in case of LOST PASSWORD
					( isset($_GET['checkemail']) && $_GET['checkemail']=='registered') ||    // in case of REGISTER
					( isset($_GET['action']) == 'lostpassword') ||
					( isset($_GET['loginSocial'])) ||
					( isset($_GET['action']) == 'rp') ) return;
				else wp_redirect(home_url());
				exit();
			}
		}
	}
}
add_action('init','possibly_redirect');

/*-----------------------------------------------------------------------------------*/
# Yönlendirme: Çıkış
/*-----------------------------------------------------------------------------------*/
if( ! function_exists( 'logout_redirect' )){
	function logout_redirect()
	{
			$redirect_url = $_SERVER['HTTP_REFERER'];
			wp_redirect($redirect_url);
			exit;
	}
}
add_action('wp_logout', 'logout_redirect');

/*-----------------------------------------------------------------------------------*/
# Yönlendirme: Hata
/*-----------------------------------------------------------------------------------*/
if( ! function_exists( 'login_failed' )){
	function login_failed()
	{
		if (ot_get_option('geo_yonlendirme') == 'on' && geoit__get__status() == true) {
			if (isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response'] == 0) {
				$login_page = ''.$_SERVER['HTTP_REFERER'].'?islem=rc';
				wp_redirect($login_page);
				exit;
			}else {
				$login_page = ''.$_SERVER['HTTP_REFERER'].'?islem=basarisiz';
				wp_redirect($login_page);
				exit;
			}
		}
	}
}
add_action('wp_login_failed', 'login_failed');

/*-----------------------------------------------------------------------------------*/
# Yönlendirme: Boş
/*-----------------------------------------------------------------------------------*/
if( ! function_exists( 'verify_user' )){
	function verify_user($user, $username, $password)
	{
		if (ot_get_option('geo_yonlendirme') == 'on' && geoit__get__status() == true) {
			$login_page = home_url('?islem=bos');
			if ($username == '' || $password == '') {
					wp_redirect($login_page);
					exit;
			}
		}
	}
}
add_filter('authenticate', 'verify_user', 10, 3);

/*-----------------------------------------------------------------------------------*/
# Yönlendirme: Wp Admini Profilimi Düzenle Sayfasına
/*-----------------------------------------------------------------------------------*/
function restrict_admin_with_redirect() {
	if (ot_get_option('geo_wp_admin') == 'on') {
		$settings_url = ot_get_option('geo_profile');
		if ($settings_url != '') {
			$page = get_page_link($settings_url);
		}
	  else {
			$page = get_edit_user_link();
		}
    if ( ! current_user_can( 'manage_options' ) && ( ! wp_doing_ajax() ) ) {
      wp_redirect($page);
      exit;
    }
	}
}

add_action( 'admin_init', 'restrict_admin_with_redirect', 1 );

/*-----------------------------------------------------------------------------------*/
# Recaptcha #bws_google_captcha
/*-----------------------------------------------------------------------------------*/
add_filter('login_form_middle','geoit_recaptcha_login');
function geoit_recaptcha_login(){
	$opt = get_option( 'gglcptch_options' );
	if ($opt['login_form'] == 1 && $opt['keys_verified'] == 1 ) {
		$shortcode = do_shortcode('[bws_google_captcha]');
		if ($shortcode != '[bws_google_captcha]') {
			return $shortcode;
		}
	}
}
function geoit_recaptcha($what){
	$opt = get_option( 'gglcptch_options' );
	// print_r($opt);
	if ($opt[$what] == 1 && $opt['keys_verified'] == 1 ) {
		$shortcode = do_shortcode('[bws_google_captcha]');
		if ($shortcode != '[bws_google_captcha]') {
			return $shortcode;
		}
	}
}


if( ! function_exists( 'geoit_login' )){
	function geoit_login() {
		if ( ! is_user_logged_in() && ot_get_option('header_top_login') != 'off' ) {
			echo '<div id="geoit-login" class="geoit_login">';
			echo '';
			echo '<div class="geoit_login-wrapper userLogin">';	
			echo '<div class="login_headline"><span>'.__('Giriş Yap', 'geo').'</span> <button type="button" data-toggle="geoit-login" class="uckan-btn--fab login-close"><i class="fa fa-close"></i></button></div>';
			$serror = geoit_login_error_messages();
			if (!empty($serror)){
				echo '<div class="geoit_login-hata">'.$serror.'</div>';
			}
			if ( get_option( 'users_can_register' ) ) {
				echo '<div class="widget-social-accounts">';
					if (ot_get_option('geo_facebook_login') == 'on') {
						echo '<a title="'.__('Facebook ile Bağlan', 'geo').'" class="s-link social-btn facebook" href="'.get_site_url().'/wp-login.php?loginSocial=facebook" data-plugin="nsl" data-action="connect" data-redirect="current" data-provider="facebook" data-popupwidth="475" data-popupheight="175">
							<i class="fa fa-facebook"></i>
						</a>';
					}
					if (ot_get_option('geo_twitter_login') == 'on') {
						echo '<a title="'.__('Twitter ile Bağlan', 'geo').'"  class="s-link social-btn twitter" href="'.get_site_url().'/wp-login.php?loginSocial=twitter" data-plugin="nsl" data-action="connect" data-redirect="current" data-provider="twitter" data-popupwidth="600" data-popupheight="600">
							<i class="fa fa-twitter"></i>
						</a>';
					}
					if (ot_get_option('geo_google_login') == 'on') {
						if(ot_get_option('geoit_lazy_images') == 'on') {
							$img = '<img class="geo-lazy" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mPk5ODkAQAAZAAoQWYOjQAAAABJRU5ErkJggg==" data-src="'.get_template_directory_uri().'/assets/img/google.svg" width="18" height="18" alt="google_login" />';
						} else {
							$img = '<img src="'.get_template_directory_uri().'/assets/img/google.svg" width="18" height="18" alt="google_login" />';
						}
						echo '<a title="'.__('Google ile Bağlan', 'geo').'" class="s-link social-btn" href="'.get_site_url().'/wp-login.php?loginSocial=google" data-plugin="nsl" data-action="connect" data-redirect="current" data-provider="google" data-popupwidth="600" data-popupheight="600">
							'.$img.'
						</a>';
					}
				echo '</div>';
				
			}
			wp_login_form([
				'redirect' => $_SERVER['REQUEST_URI'].'?login=true',
				'label_log_in' => __('Giriş Yap', 'geo'),
			]);
			$register_url = ot_get_option('geo-register');
			$forgot_url = ot_get_option('geo-forgot');
			if ( get_option( 'users_can_register' ) ) {
				echo '<div class="geoit_login_232"><div class="or-div"><span>'.__('veya', 'geo').'</span></div>';
				echo '<div class="widget-social-accounts">';
				if ($register_url != '') {
					echo '<a class="reg_btn" href="'.get_page_link($register_url).'">'.__("Kayıt Ol", "geo").'</a>';
				}
				else {
					echo '<a class="reg_btn" href="'.site_url().'/wp-login.php?action=register">'.__("Kayıt Ol", "geo").'</a>';
				}
				if ($forgot_url != '') {
					echo '<a class="forgot_btn" href="'.get_page_link($forgot_url).'">'.__("Şifremi Unuttum", "geo").'</a>';
				}
				else {
					echo '<a class="forgot_btn" href="'.get_site_url(null, '/wp-login.php?action=lostpassword').'">'.__("Şifremi Unuttum", "geo").'</a>';
				}
				echo '</div>';
				echo '</div>';
			}
			echo '</div>';
			echo '</div>';
		}
	}
}

if( ! function_exists( 'geoit_login_button' )){
	function geoit_login_button() {
		$whatx = ot_get_option('header_top_login');
		$dark_theme = ot_get_option('dark_theme');
		$darktheme = ot_get_option('header_dark_mode');

		if ( is_user_logged_in() ) {
			if ( $whatx != 'off' ) {
				$current_user = wp_get_current_user();
				$avatar = geoit_get_avatar($current_user->ID, 25);
				$fav_page_url = ot_get_option('geo-favorites');
				$posting_url = ot_get_option('geo-posting');
				$settings_url = ot_get_option('geo_profile');
				$logout = wp_logout_url( home_url() );
				echo '<div class="has-login-area">';
				echo '<button data-toggle="geoit-login" class="uckan_login-button">'.$avatar.' '. $current_user->display_name .' <i class="fa fa-caret-down" aria-hidden="true"></i></button>';
				echo '<div id="geoit-login" class="dropdown-content has_login">';
				echo '<ul>';

				if ( current_user_can('administrator') ) {
					echo '<li><a href="'.site_url().'/wp-admin">'.__('Admin Panel', 'geo').'</a></li>';
				}
				echo '<li><a href="'.get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ).'">'.__('Profilim', 'geo').'</a></li>';
				if ($settings_url != '') {
					echo '<li><a href="'.get_page_link($settings_url).'">'.__('Profilimi Düzenle', 'geo').'</a></li>';
				}
				else {
					echo '<li><a href="'.get_edit_user_link().'">'.__('Profilimi Düzenle', 'geo').'</a></li>';
				}
				if ($fav_page_url != '') {
					echo '<li><a href="'.get_page_link($fav_page_url).'">'.__('Favorilerim', 'geo').'</a></li>';
				}
				if ($posting_url != '') {
					echo '<li><a href="'.get_page_link($posting_url).'">'.__('Yazı Gönder', 'geo').'</a></li>';
				}
				if ($dark_theme != 'on' && $darktheme != 'off' ) {
				echo '<li class="geoit_dark_button"><i class="fa fa-flash"></i> <div class="geo-switch-button Off"><div class="geo-switch"></div></div></li>';
				}
				echo '<li><a href="'.$logout.'"><i class="fa fa-sign-out" aria-hidden="true"></i> '.__('Çıkış Yap', 'geo').'</a></li>';
				echo '</ul>';
				echo '</div>';
				echo '</div>';
			}
		} else {
			if ($dark_theme != 'on' && $darktheme != 'off' ) {
				echo '<div class="geoit_dark_button"><i class="fa fa-flash"></i> <div class="geo-switch-button Off"><div class="geo-switch"></div></div></div>';
			}
			if ( $whatx != 'off' ) {
				echo '<button data-toggle="geoit-login" class="uckan_login-button"><i class="fa fa-user"></i> '.__('Giriş Yap', 'geo').'</button>';
			}
		}
	}
}