<?php

class PTMCW_Plugin {
	public function __construct() {
		add_action( 'admin_enqueue_scripts', 'PTMCW_Plugin::enqueue_admin_scripts' );
	}
	public static function enqueue_admin_scripts() {

		wp_enqueue_script( 'ptmcw-admin-js', get_template_directory_uri() . '/assets/admin/mailchimp.js', array( 'jquery' ), 1523, true );

		wp_localize_script( 'ptmcw-admin-js', 'PTMCWAdminVars', array(
			'ajax_url'    => admin_url( 'admin-ajax.php' ),
			'ajax_nonce'  => wp_create_nonce( 'pt-mcw-ajax-verification' ),
			'text'        => array(
				'ajax_error'        => esc_html__( 'An error occurred while retrieving data via the AJAX request!', 'pt-mcw' ),
				'no_api_key'        => esc_html__( 'Please input the MailChimp API key!', 'pt-mcw' ),
				'incorrect_api_key' => esc_html__( 'This MailChimp API key is not formatted correctly, please copy the whole API key from the MailChimp dashboard!', 'pt-mcw' ),
			)
		) );
	}

}
$ptmcw_plugin = new PTMCW_Plugin();