<?php
/*
Name:  WordPress Post Like System
Description:  A simple and efficient post like system for WordPress.
Version:      0.4
Author:       Jon Masterson
Author URI:   http://jonmasterson.com/
License:
Copyright (C) 2014 Jon Masterson
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
 
/**
 * (1) Enqueue scripts for like system
 */

add_action( 'wp_ajax_nopriv_jm-post-like', 'jm_post_like' );
add_action( 'wp_ajax_jm-post-like', 'jm_post_like' );
function jm_post_like() {
	$nonce = $_POST['nonce'];
    if ( ! wp_verify_nonce( $nonce, 'ajax-nonce' ) )
        die ( 'Nope!' );
	
	if ( isset( $_POST['jm_post_like'] ) ) {
	
		$post_id = $_POST['post_id']; // post id
		$post_like_count = get_post_meta( $post_id, "_post_like_count", true ); // post like count
		
		if ( function_exists ( 'wp_cache_post_change' ) ) {
			$GLOBALS["super_cache_enabled"]=1;
			wp_cache_post_change( $post_id );
		}
		
		if ( is_user_logged_in() ) { // user is logged in
			$user_id = get_current_user_id(); // current user
			$meta_POSTS = get_user_option( "_liked_posts", $user_id  ); // post ids from user meta
			$meta_USERS = get_post_meta( $post_id, "_user_liked" ); // user ids from post meta
			$liked_POSTS = NULL; // setup array variable
			$liked_USERS = NULL; // setup array variable
			
			if ( count( $meta_POSTS ) != 0 ) { // meta exists, set up values
				$liked_POSTS = $meta_POSTS;
			}
			
			if ( !is_array( $liked_POSTS ) ) // make array just in case
				$liked_POSTS = array();
				
			if ( count( $meta_USERS ) != 0 ) { // meta exists, set up values
				$liked_USERS = $meta_USERS[0];
			}		
			if ( !is_array( $liked_USERS ) ) // make array just in case
				$liked_USERS = array();
				
			$liked_POSTS['post-'.$post_id] = $post_id; // Add post id to user meta array
			$liked_USERS['user-'.$user_id] = $user_id; // add user id to post meta array
			$user_likes = count( $liked_POSTS ); // count user likes
	
			if ( !AlreadyLiked( $post_id ) ) { // like the post
				update_post_meta( $post_id, "_user_liked", $liked_USERS ); // Add user ID to post meta
				update_post_meta( $post_id, "_post_like_count", ++$post_like_count ); // +1 count post meta
				update_user_option( $user_id, "_liked_posts", $liked_POSTS ); // Add post ID to user meta
				update_user_option( $user_id, "_user_like_count", $user_likes ); // +1 count user meta
				echo $post_like_count; // update count on front end
			} else { // unlike the post
				$pid_key = array_search( $post_id, $liked_POSTS ); // find the key
				$uid_key = array_search( $user_id, $liked_USERS ); // find the key
				unset( $liked_POSTS[$pid_key] ); // remove from array
				unset( $liked_USERS[$uid_key] ); // remove from array
				$user_likes = count( $liked_POSTS ); // recount user likes
				update_post_meta( $post_id, "_user_liked", $liked_USERS ); // Remove user ID from post meta
				update_post_meta($post_id, "_post_like_count", --$post_like_count ); // -1 count post meta
				update_user_option( $user_id, "_liked_posts", $liked_POSTS ); // Remove post ID from user meta			
				update_user_option( $user_id, "_user_like_count", $user_likes ); // -1 count user meta
				echo "already".$post_like_count; // update count on front end
				
			}
			
		} else { // user is not logged in (anonymous)
			$ip = $_SERVER['REMOTE_ADDR']; // user IP address
			$meta_IPS = get_post_meta( $post_id, "_user_IP" ); // stored IP addresses
			$liked_IPS = NULL; // set up array variable
			
			if ( count( $meta_IPS ) != 0 ) { // meta exists, set up values
				$liked_IPS = $meta_IPS[0];
			}
	
			if ( !is_array( $liked_IPS ) ) // make array just in case
				$liked_IPS = array();
				
			if ( !in_array( $ip, $liked_IPS ) ) // if IP not in array
				$liked_IPS['ip-'.$ip] = $ip; // add IP to array
			
			if ( !AlreadyLiked( $post_id ) ) { // like the post
				update_post_meta( $post_id, "_user_IP", $liked_IPS ); // Add user IP to post meta
				update_post_meta( $post_id, "_post_like_count", ++$post_like_count ); // +1 count post meta
				echo $post_like_count; // update count on front end
				
			} else { // unlike the post
				$ip_key = array_search( $ip, $liked_IPS ); // find the key
				unset( $liked_IPS[$ip_key] ); // remove from array
				update_post_meta( $post_id, "_user_IP", $liked_IPS ); // Remove user IP from post meta
				update_post_meta( $post_id, "_post_like_count", --$post_like_count ); // -1 count post meta
				echo "already".$post_like_count; // update count on front end
				
			}
		}
	}
	
	exit;
}
/**
 * (4) Test if user already liked post
 */
function AlreadyLiked( $post_id ) { // test if user liked before
	if ( is_user_logged_in() ) { // user is logged in
		$user_id = get_current_user_id(); // current user
		$meta_USERS = get_post_meta( $post_id, "_user_liked" ); // user ids from post meta
		$liked_USERS = ""; // set up array variable
		
		if ( count( $meta_USERS ) != 0 ) { // meta exists, set up values
			$liked_USERS = $meta_USERS[0];
		}
		
		if( !is_array( $liked_USERS ) ) // make array just in case
			$liked_USERS = array();
			
		if ( in_array( $user_id, $liked_USERS ) ) { // True if User ID in array
			return true;
		}
		return false;
		
	} else { // user is anonymous, use IP address for voting
	
		$meta_IPS = get_post_meta( $post_id, "_user_IP" ); // get previously voted IP address
		$ip = $_SERVER["REMOTE_ADDR"]; // Retrieve current user IP
		$liked_IPS = ""; // set up array variable
		
		if ( count( $meta_IPS ) != 0 ) { // meta exists, set up values
			$liked_IPS = $meta_IPS[0];
		}
		
		if ( !is_array( $liked_IPS ) ) // make array just in case
			$liked_IPS = array();
		
		if ( in_array( $ip, $liked_IPS ) ) { // True is IP in array
			return true;
		}
		return false;
	}
	
}
/**
 * (5) Front end button
 */
function get_simple_likes_button( $post_id ) {
	$like_count = get_post_meta( $post_id, "_post_like_count", true ); // get post likes
	$count = ( empty( $like_count ) || $like_count == "0" ) ? '' : esc_attr( $like_count );
	$admin = ot_get_option('geo_favorites');
	if ( AlreadyLiked( $post_id ) ) {
		$class = esc_attr( ' faved' );
		$fav = '<i class="fa fa-bookmark"></i>';
		$title = __('Favorilerimden Çıkar', 'geo');
	} else {
		$class = esc_attr( '' );
		$fav = '<i class="fa fa-bookmark-o"></i>';
		$title = __('Favorilerime Ekle', 'geo' );
	}
	if ( is_user_logged_in() ) {
		$output = '<div class="jm-post-like'.$class.'" data-post_id="'.$post_id.'" title="'.$title.'">'.$fav.' '.$count.'</div>';
	}
	else {
		if (ot_get_option('geo_favorites_guest') != 'off') {
			$output = '<div class="jm-post-like'.$class.'" data-post_id="'.$post_id.'" title="'.$title.'">'.$fav.' '.$count.'</div>';
		}
		else {
			$output = '<div data-toggle="geoit-login" class="jm-post-like'.$class.'" title="'.$title.'">'.$fav.' '.$count.'</div>';
		}
		
	}
	if ($admin != 'on'){
		return false;
	}
	else
		return $output;
}
/**
 * (6) Retrieve User Likes and Show on Profile
 */
// add_action( 'show_user_profile', 'show_user_likes' );
// add_action( 'edit_user_profile', 'show_user_likes' );
function show_user_likes( $user ) { ?>        
    <table class="form-table">
        <tr>
			<th><label for="user_likes"><?php _e( 'Favorilerim' ); ?></label></th>
			<td>
            <?php
			$user_likes = get_user_option( "_liked_posts", $user->ID );
			if ( !empty( $user_likes ) && count( $user_likes ) > 0 ) {
				$the_likes = $user_likes;
			} else {
				$the_likes = '';
			}
			if ( !is_array( $the_likes ) )
			$the_likes = array();
			$count = count( $the_likes ); 
			$i=0;
			if ( $count > 0 ) {
				$like_list = '';
				echo "<p>\n";
				foreach ( $the_likes as $the_like ) {
					$i++;
					$like_list .= "<a href=\"" . esc_url( get_permalink( $the_like ) ) . "\" title=\"" . esc_attr( get_the_title( $the_like ) ) . "\">" . get_the_title( $the_like ) . "</a>\n";
					if ($count != $i) $like_list .= " &middot; ";
					else $like_list .= "</p>\n";
				}
				echo $like_list;
			} else {
				echo "<p>" . _e( 'Henüz favorilerinize bir şey eklememişsiniz.', 'geo' ) . "</p>\n";
			} ?>
            </td>
		</tr>
    </table>
<?php }
/**
 * (7) Add a shortcode to your posts instead
 * type [jmliker] in your post to output the button
 */
function jm_like_shortcode() {
	return get_simple_likes_button( get_the_ID() );
}
add_shortcode('jmliker', 'jm_like_shortcode');
/**
 * (8) If the user is logged in, output a list of posts that the user likes
 * Markup assumes sidebar/widget usage
 */
function frontEndUserLikes($user_id) {
	global $post;
	if ( is_user_logged_in() ) { // user is logged in
		$like_list = '';
		$user_likes = get_user_option( "_liked_posts", $user_id );
		if ( !empty( $user_likes ) && count( $user_likes ) > 0 ) {
			$the_likes = $user_likes;
		} else {
			$the_likes = '';
		}
		if ( !is_array( $the_likes ) )
			$the_likes = array();
		$count = count( $the_likes );
		if ( $count > 0 ) {
			$limited_likes = array_slice( $the_likes, 0, 5 ); // this will limit the number of posts returned to 5
			$like_list .= "<div class='content__recent-posts--group'><div class='content__title'><h3 class='uckan-btn'>".__('Favorilerim', 'geo')."</h3></div>\n";
			$like_list .= "<div class='post-list-group post-counter'>\n";
			foreach ( $limited_likes as $the_like ) {
				$like_list .= "<div class='uck-card uck-card-list'>\n";
				if ( has_post_thumbnail($the_like) ) {
					$image = wp_get_attachment_image_src(get_post_thumbnail_id($the_like), 'geo-medium');
					$like_list .= "<div class='uck-card--image'><a href='" . esc_url( get_permalink( $the_like ) ) . "' title='" . esc_attr( get_the_title( $the_like ) ) . "'><img src='".$image[0]."' alt='" . esc_attr( get_the_title( $the_like ) ) . "'  width='335' height='195'/></a></div>\n";
				}	
				$like_list .= "<div class='uck-card--content'>\n";
					$like_list .= "<div class='uck-card-top'>\n";
						$like_list .= "<span class='date'><i class='fa fa-clock-o'></i> ".get_the_time('j M, Y', $the_like)."</span>\n";
					$like_list .= "</div>\n";
					$like_list .= "<h2 class='headline'><a href='" . esc_url( get_permalink( $the_like ) ) . "' title='" . esc_attr( get_the_title( $the_like ) ) . "'>" . get_the_title( $the_like ) . "</a></h2>\n";
					if (ot_get_option('excerpt-length') != '0') {
						$dapost = get_post($the_like);
						$my_excerpt = wp_trim_words( apply_filters( "the_excerpt", get_the_excerpt($dapost) ? get_the_excerpt($dapost) : $dapost->post_content  ), "20" );
						$like_list .= "<p>".$my_excerpt."</p>\n";
					}
					$like_list .= "<div class='uck-card--meta'>\n";
					$like_list .= "<div class='uck-card--left'>\n";
						// $like_list .= "<div class='uck-card--right'><a href='" . esc_url( get_permalink( $the_like ) ) . "'>".__('Devamını Oku', 'geo')."</a></div>\n";
					$like_list .= "</div>\n";
					$like_list .= "</div>\n";
				$like_list .= "</div>\n";
				$like_list .= "</div>\n";
			}
			$like_list .= "</div>\n";
			$like_list .= "</div>\n";
		}
		else {
			$like_list .= "<div class='content__recent-posts--group'><div class='content__title'><h3 class='uckan-btn'>".__('Favorilerim', 'geo')."</h3></div>\n";
			$like_list .= "<div style='width: 100% !important; padding: 0 1em 1em' class='uck-card box-sd'><div class='uck-card--content'>".__('Herhangi bir yazıyı favorilerinize eklememişsiniz.', 'geo')."</div></div></div>\n";
		}
		echo $like_list;
	}
	else {
		$like_list .= "<div class='content__recent-posts--group'><div class='content__title'><h3 class='uckan-btn'>".__('Favorilerim', 'geo')."</h3></div>\n";
		$like_list .= "<div style='width: 100% !important; padding: 0 1em 1em' class='uck-card box-sd'><div class='uck-card--content'>".__('Favorilerinizi görmek için lütfen giriş yapın', 'geo')."</div></div></div>\n";
		echo $like_list;
	}
}

