<?php
/*
Sayfa Adı: Yazı-List(2x)
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
?>
<div id="post-<?php the_ID(); ?>" class="uck-card post">
	<div class="uck-card-flex">
		<?php if(has_post_thumbnail()): ?>
			<div class="uck-card--image">
				<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
					<?php the_post_thumbnail('geo-medium'); ?>
				</a>
				<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
				<?php echo get_simple_likes_button( get_the_ID() ); ?>
			</div>
		<?php endif; ?>
		<div class="uck-card--content">
			
			<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
			<div class="uck-card--meta uck-card--border">
				<div class="uck-card--left">
					
					<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
					<?php echo geoit_block_views(); ?>
					<?php geoit_trending_post(get_the_ID()); ?>
					<?php geo_reaction_badge($post->ID); ?>
				</div>
			</div>
		</div>
	</div>
</div>
