<?php
add_action( 'widgets_init', 'geo_manset' );
function geo_manset() {
	register_widget( 'geo_manset_slider' );
}
class geo_manset_slider extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'classname' => 'geoit_manset' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'geoit_manset_widget' );
		parent::__construct( 'geoit_manset_widget', THEME_NAME .' - '.__( "Manşet" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$no_of_posts = $instance['no_of_posts'];
		$cats_id = $instance['cats_id'];

		echo $before_widget;
		if(!empty($title)) {
			echo $before_title;
				echo $title; 
			echo $after_title;
		}
		$sss = '';
		if ($cats_id != 'all') {
			$sss = array(
					array(
						'taxonomy' => 'topics',
						'field'    => 'term_id',
						'terms'    => array($cats_id),
					),
				);
		}
		$geo_query = new WP_Query(
			array( 
				'post_type' => 'geoit_manset',
				'tax_query' => $sss,
				'showposts' => $no_of_posts,
			)
		);
		if ($geo_query->have_posts()) : ?>	
					<div class="slider-style-2">
						<div style="margin-top: 0" class="owl-carousel loop h-slider w-slider owl-theme manset_slider">
						<?php while($geo_query->have_posts()): $geo_query->the_post(); global $post; $title = get_post_meta( $post->ID, 'geo_' . 'manset_baslik', true );?>
							<div class="carousel__item item">
								<a href="<?php echo get_post_meta( $post->ID, 'geo_' . 'manset_link', true ); ?>" class="uckan-card--url"></a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
								<div class="w-slider_image" <?php if ( $thumbnail_id = get_post_thumbnail_id() ) { if ( $image_src = wp_get_attachment_image_src( $thumbnail_id, 'geo-slider') ) printf( ' style="background-image: url(%s)"', $image_src[0] );} ?>></div>
								<?php if(!empty($title)): ?>
									<div class="manset_content">
										<h2 class="headline"><?php echo $title; ?></h2>
									</div>
								<?php endif; ?>
							</div>
						<?php endwhile;?>
						</div>
					</div>
		<?php endif; 
		wp_reset_query(); ?>
	
	
	<?php 
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['no_of_posts'] = $new_instance['no_of_posts'];
		$instance['cats_id'] = $new_instance['cats_id'];

		return $instance;
	}

	public function form( $instance ) {
		$defaults = array( 'title' =>__( 'Modül' , 'geo'), 'no_of_posts' => '5' , 'cats_id' => '1',  );
		$instance = wp_parse_args( (array) $instance, $defaults );
	?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('cats_id'); ?>"><?php _e( 'Kategori' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('cats_id'); ?>" name="<?php echo $this->get_field_name('cats_id'); ?>" class="widefat categories" style="width:100%;">
				<option value='all' <?php if ('all' == $instance['cats_id']) echo 'selected="selected"'; ?>><?php _e( 'Hepsi' , 'geo') ?></option>
				<?php $cats_id = get_categories('hide_empty=0&depth=1&type=geoit_manset&taxonomy=topics'); ?>
				<?php foreach($cats_id as $cats_id) { ?>
				<option value='<?php echo $cats_id->term_id; ?>' <?php if ($cats_id->term_id == $instance['cats_id']) echo 'selected="selected"'; ?>><?php echo $cats_id->cat_name; ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>"><?php _e( 'Yazı Sayısı' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance['no_of_posts']; ?>" type="text" size="3" />
		</p>
	<?php
	}
}
?>