<?php
  /**
 * Add function to widgets_init that'll load our widget.
 */
add_action('widgets_init','geo_submitpost_widgets');

function geo_submitpost_widgets(){
	register_widget("geo_submitpost_widget");
}

/**
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 */
class geo_submitpost_widget extends WP_widget{
	
	/**
	 * Widget setup.
	 */
	public function __construct(){
		
		/* Widget settings. */
		$widget_ops = array('classname' => 'widget_submit_post');
		
		/* Create the widget. */
		parent::__construct('geo_submitpost_widget', THEME_NAME .' - '.__( "Yazı Gönder" , 'geo' ) , $widget_ops );		
	}
	
	/**
	 *display the widget on the screen.
	 */
	public function widget($args,$instance){
		extract($args);
			$title = apply_filters('widget_title', $instance['title'] );
			$desc = $instance['desc'];
			
			echo $before_widget;
				$posting = ot_get_option('geo-posting');
				echo '<div class="geo_submit_post">';
					echo '<h5>'.$title.'</h5>';
					echo '<p>'.$desc.'</p>';
					echo '<a href="'.get_page_link($posting).'" class="uckan-btn uckan-btn--middle colored"><i class="fa fa-plus"></i> '.__('Oluşturun', 'geo').'</a>';
				echo '</div>';
			echo $after_widget;
	}
	
	/**
	 * update widget settings
	 */
	public function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['desc'] = $new_instance['desc'];
		
		return $instance;
	}

	public function form($instance){
		$defaults = array('title' => __('Yazı Gönder', 'geo'), 'desc' => __('Yaratıcılığınızı açığa çıkarın, hikayenizi bizimle paylaşın!', 'geo'));
		$instance = wp_parse_args((array) $instance, $defaults);
		?>	
				
		<p>			
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Başlık', 'geo') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		<p>			
			<label for="<?php echo $this->get_field_id( 'desc' ); ?>"><?php _e('Açıklama', 'geo') ?></label>
			<textarea rows="4" class="widefat" id="<?php echo $this->get_field_id( 'desc' ); ?>" name="<?php echo $this->get_field_name( 'desc' ); ?>"><?php echo $instance['desc']; ?></textarea>
		</p>
		<?php
	}
}
?>