<?php
/*
Sayfa Adı: Header Sayfası
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div class="uck-layout__container">
	<div class="uck-layout">
		<header id="header" class="header-default">
			<?php if(ot_get_option('header-top-status') != 'off'): ?>
				<div class="header__top">
					<div class="container">
						<div class="header__row">
							<div class="header__top--left">
								<?php geo_news_ticker();?>
							</div>
							<div class="header__top--right">
								<div class="header__search">
									<button class="header__search--icon"><i class="fa fa-search"></i></button>
								</div>
								<div class="header__search--form">
									<form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
										<input autofocus id="searchInput" name="s" placeholder="<?php _e('Aradığınız kelimeyi bu alana girin..', 'geo');?>" type="text">
										<button type="submit" class="search-submit"><i class="fa fa-search"></i></button>
									</form>
								</div>
								<?php if(ot_get_option('header-top-social') != 'off'): 
									geo_social_links();
								endif; ?>
								<?php geoit_login_button(); ?>
							</div>
						</div>
					</div>
				</div>
			<?php endif; ?>
			<div class="header__middle">
				<div class="container">
					<div class="header__row">
						<?php if( ot_get_option('geo-1-ads') || ot_get_option('geo-1-ads-m') ): ?>
							<div class="header__logo_wrapper">
								<div class="header__logo header__logo--left">
									<?php echo geoit_site_logo(); ?>
								</div>
								<?php geo_mobil_login(); ?>
								<button data-toggle="geo_mobil_menu" id="mobile-menu-icon"><i class="fa fa-bars"></i></button>
							</div>
							<?php if(geo_is_mobile()): ?>
								<?php if(ot_get_option('geo-1-ads-m')): ?><div class="ad ad728 ad-right"><?php echo ot_get_option('geo-1-ads-m'); ?></div><?php endif; ?>
							<?php else: ?>
								<?php if(ot_get_option('geo-1-ads')): ?><div class="ad ad728 ad-right"><?php echo ot_get_option('geo-1-ads'); ?></div><?php endif; ?>
							<?php endif; ?>
						<?php else: ?>
							<div class="header__logo_wrapper logo_center_wrapper">
								<div class="header__logo header__logo--center">
									<?php echo geoit_site_logo(); ?>
								</div>
								<?php geo_mobil_login(); ?>
								<button data-toggle="geo_mobil_menu" id="mobile-menu-icon"><i class="fa fa-bars"></i></button>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<div class="header__bottom">
				<div class="header___bottom">
					<div class="container">
						<div class="header__row row">
							<?php if( ot_get_option('geo-1-ads') || ot_get_option('geo-1-ads-m') ): ?>
							<div class="header__bottom--menu-left col-md-12">
							<?php else: ?>
							<div class="col-md-12 header__bottom--menu-center">
							<?php endif; ?>
								<button class="mobil-menu-button"><i class="fa fa-bars"></i></button>
								<nav class="header__bottom--menu">
									<?php if ( has_nav_menu( 'geo-header' ) ) :
										wp_nav_menu( array(
											'theme_location' => 'geo-header',
											'menu_class'     => 'geo-menu',
											'walker' => new description_walker(),
										)
									);
									else: ?>
										<ul class="menu">
											<li><a class="header__bottom--link current-menu-item create-menu-link" href="<?php echo esc_url( home_url( '/' ) ); ?>wp-admin/nav-menus.php"><?php _e( 'Menü Oluştur', 'geo' ); ?></a></li>
										</ul>
									<?php endif; ?>
								</nav>
							</div>
						</div>
					</div>
				</div>
			</div>
			</header>
		
		<?php echo geoit_stories_html(); ?>