<?php
/**
 * Template Name: Profilimi Düzenle
 * @url kanthemes.com
 */
__( 'Profilimi Düzenle', 'geo' );
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
/* Get user info. */
global $current_user, $wp_roles;
wp_get_current_user();
//get_currentuserinfo(); //deprecated since 3.1

/* Load the registration file. */
//require_once( ABSPATH . WPINC . '/registration.php' ); //deprecated since 3.1
$error = array();    
/* If profile was saved, update profile. */
if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'update-user' ) {

	$success = '';
    /* Update user password. */
    if ( !empty($_POST['pass1'] ) && !empty( $_POST['pass2'] ) ) {
        if ( $_POST['pass1'] == $_POST['pass2'] ) {
					wp_update_user( array( 'ID' => $current_user->ID, 'user_pass' => esc_attr( $_POST['pass1'] ) ) );
				}
        else
          $error[] = __('Girdiğiniz parolalar uyuşmuyor. Parolanız güncellenmedi.', 'geo');
    }

    /* Update user information. */
    if ( !empty( $_POST['url'] ) )
       wp_update_user( array ('ID' => $current_user->ID, 'user_url' => esc_attr( $_POST['url'] )));
    if ( !empty( $_POST['email'] ) ){
        if (!is_email(esc_attr( $_POST['email'] )))
            $error[] = __('Girdiğiniz e-posta geçerli değil. lütfen tekrar deneyin.', 'geo');
        elseif( email_exists(esc_attr( $_POST['email'] ) ) && email_exists(esc_attr( $_POST['email'] )) != $current_user->ID )
            $error[] = __('Bu e-posta başka bir kullanıcı tarafından zaten kullanılıyor. farklı bir e-posta deneyin.', 'geo');
        else{
            wp_update_user( array ('ID' => $current_user->ID, 'user_email' => esc_attr( $_POST['email'] )));
        }
    }

    if ( !empty( $_POST['first-name'] ) )
        update_user_meta( $current_user->ID, 'first_name', esc_attr( $_POST['first-name'] ) );
    if ( !empty( $_POST['last-name'] ) )
        update_user_meta($current_user->ID, 'last_name', esc_attr( $_POST['last-name'] ) );
    if ( !empty( $_POST['description'] ) )
        update_user_meta( $current_user->ID, 'description', esc_attr( $_POST['description'] ) );
    if ( !empty( $_POST['nickname'] ) )
        update_user_meta( $current_user->ID, 'nickname', esc_attr( $_POST['nickname'] ) );
		if ( !empty( $_POST['display_name'] ) ) {
				wp_update_user(array('ID' => $current_user->ID, 'display_name' => esc_attr( $_POST['display_name'] )));
				update_user_meta($current_user->ID, 'display_name' , esc_attr( $_POST['display_name'] ));
		}
		if ( !empty( $_POST['_basic_user_avatar_nonce'] ) ) {
			if ( get_the_author_meta('avatar_puan', $current_user->ID) != '1') {
				$points = get_user_meta( $current_user->ID, 'geo_user_points', true );
				$points += ot_get_option('geo_puan_avatar');
				update_user_meta( $current_user->ID, 'geo_user_points', $points );
				update_user_meta( $current_user->ID, 'avatar_puan', '1' );
			}
			update_user_meta($current_user->ID, '_basic_user_avatar_nonce' , esc_attr( $_POST['_basic_user_avatar_nonce'] ));
	  }
		 

		if ( ! empty( $_FILES['cover_bg']['name'] ) ) {
			$filename = $_FILES['cover_bg']['name'];
			$ext = pathinfo($filename, PATHINFO_EXTENSION);
			$allowed = array('jpg', 'png', 'jpeg');
			if( in_array( $ext, $allowed ) ){
				// Allowed file extensions/types
				$mimes = array(
					'jpg|jpeg|jpe' => 'image/jpeg',
					'png'          => 'image/png',
				);

				// Front end support - shortcode, bbPress, etc
				if ( ! function_exists( 'wp_handle_upload' ) )
					require_once ABSPATH . 'wp-admin/includes/file.php';
				
				$r = wp_handle_upload( $_FILES['cover_bg'], array( 'mimes' => $mimes, 'test_form' => false) );
			
				// Save user information (overwriting previous)
				if (isset($r)) {
					update_user_meta( $current_user->ID, 'cover_bg', $r );
					if ( get_the_author_meta('cover_puan', $current_user->ID) != '1') {
						$points = get_user_meta( $current_user->ID, 'geo_user_points', true );
						$points += ot_get_option('geo_puan_cover');
						update_user_meta( $current_user->ID, 'geo_user_points', $points );
						update_user_meta( $current_user->ID, 'cover_puan', '1' );
					}
				}
			
			}
			else {
				$error[] = __('Yüklemeye çalıştığınız dosya uzantısı kabul edilmemektedir. Sadece jpg, jpeg ve png uzantılı dosya yükleyebilirsiniz.', 'geo');
			}
		}
		
	  /* Redirect so the page will show updated info.*/
		/*I am not Author of this Code- i dont know why but it worked for me after changing below line to if ( count($error) == 0 ){ */
    if ( count($error) == 0 ) {
        //action hook for plugins and extra fields saving
        do_action('edit_user_profile_update', $current_user->ID, $_FILES);
         wp_redirect( get_permalink().'?updated=true' ); exit;
        exit;
    }
		
}
geoit_header(); ?>
<main class="uck-layout__content" role="main">
	<div class="page__content">
		<div class="container">
			<div class="row">
			<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
			
				
    <div class="kfm_profile-forms" id="post-<?php the_ID(); ?>">
        <div class="entry-content entry">
            <?php the_content(); ?>
            <?php if ( !is_user_logged_in() ) : ?>
							<div class="col-md-12">
							<div class="geo_post-submit-full">
								<h2><?php _e('Giriş Yapmanız Gerekiyor!', 'geo'); ?></h2>
							</div>
						</div>
            <?php else : ?>
	
				
				<div class="col-md-4 sidebar" style="display: block !important">
					<div class="twPc-div">
						<?php $pic_data = get_user_meta( $current_user->ID, 'cover_bg', true );  ?>
						<?php $cover_empty = ''; if(empty($pic_data['url']))
							$cover_empty = 'twPc-bg-empty'; ?> 
						<a class="twPc-bg twPc-block <?php echo $cover_empty; ?>" <?php if(!empty($pic_data['url'])) {echo 'style="background-image:url('.$pic_data['url'].')"'; } ?>></a>
						<div class="twPC-cont">

							<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ); ?>" class="twPc-avatarLink">
								<?php echo geoit_get_avatar(get_the_author_meta('ID', $current_user->ID),'90'); ?>
							</a>

							<div class="twPc-divUser">
								<div class="twPc-divName">
									<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ); ?>"><?php the_author_meta('display_name', $current_user->ID); ?><?php geoit_verified_user($current_user->ID); ?></a>
								</div>
								<?php if (ot_get_option('geo_puan_sistem') == 'on') : ?>
								<span>
									<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ); ?>"><?php echo geo_get_rank($current_user->ID); ?></a>
								</span>
								<?php endif; ?>
							</div>
							<div class="twPC-middle">
									<?php if(get_the_author_meta('description', $current_user->ID) != '') : ?>
										<p class="desc"><?php the_author_meta('description', $current_user->ID); ?></p>
									<?php endif; ?>
									<?php $twitter = get_the_author_meta('twitter_profile', $current_user->ID); if($twitter): ?> <a class="twitter" href="http://www.twitter.com/<?php echo $twitter; ?>"><i class="fa fa-twitter"></i></a><?php endif; ?>
									<?php $facebook = get_the_author_meta('facebook_profile', $current_user->ID); if($facebook): ?><a class="facebook" href="<?php echo $facebook; ?>"><i class="fa fa-facebook"></i></a> <?php endif; ?>
									<?php $google = get_the_author_meta('instagram_profile', $current_user->ID); if($google): ?><a class="gplus" href="<?php echo $google; ?>"><i class="fa fa-instagram"></i></a> <?php endif; ?>
									<?php $mail = get_the_author_meta('user_email', $current_user->ID); if($mail): ?> <a href="mailto:<?php echo $mail; ?>"><i class="fa fa-envelope"></i></a> <?php endif; ?>
							</div>
							<div class="twPc-divStats">
								<ul class="twPc-Arrange">
									<li class="twPc-ArrangeSizeFit">
										<a data-toggle="tab" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ); ?>#recent" title="<?php echo count_user_posts( $current_user->ID ); ?> <?php _e('Yazılar', 'geo'); ?>">
											<span class="twPc-StatLabel twPc-block"><?php _e('Yazılar', 'geo'); ?></span>
											<span class="twPc-StatValue"><?php echo count_user_posts( $current_user->ID ); ?></span>
										</a>
									</li>
									<li class="twPc-ArrangeSizeFit">
										<a data-toggle="tab" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ); ?>#tabcomments" title="<?php global $wpdb; $userId = $current_user->ID; $where = 'WHERE comment_approved = 1 AND user_id = ' . $userId ; $comment_count = $wpdb->get_var("SELECT COUNT( * ) AS total FROM {$wpdb->comments} {$where}"); echo $comment_count; ?> <?php _e('Yorumlar', 'geo'); ?>">
											<span class="twPc-StatLabel twPc-block"><?php _e('Yorumlar', 'geo'); ?></span>
											<span class="twPc-StatValue"><?php echo $comment_count; ?></span>
										</a>
									</li>
									<?php if (ot_get_option('geo_puan_sistem') == 'on') : ?>
									<li class="twPc-ArrangeSizeFit">
										<a href="#" title="<?php echo geo_get_points($current_user->ID); ?> <?php _e('Puanı', 'geo'); ?>">
											<span class="twPc-StatLabel twPc-block"><?php _e('Puanı', 'geo'); ?></span>
											<span class="twPc-StatValue"><?php echo geo_get_points($current_user->ID); ?></span>
										</a>
						
									</li>
									<?php endif; ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-8 geo_login-widget register-frontend">
          <?php 
					echo '<script type="text/javascript">setTimeout(function () {';
						if ( $_GET['updated'] == 'true' ) {
							echo 'swal("'.__('Başarılı', 'geo').'","'.__('Yaptığınız değişiklikler başarıyla kaydedilmiştir', 'geo').'.","success", {button: "'.__('Tamam', 'geo').'",});';
						}
						if ( count($error) > 0 ) {
							echo 'swal("'.__('Hata', 'geo').'","' . implode("<br />", $error) . '","error", {button: "'.__('Tamam', 'geo').'",});';
						}		
					echo '}, 1000);</script>';
					?> 
					
						<form method="post" id="your-profile" action="<?php the_permalink(); ?>" enctype="multipart/form-data">
								<h3><?php _e('Profilimi Düzenle', 'geo'); ?></h3>
								
								<div class="form-group">
									<div class="form-label-group">
										<input type="text" id="first-name" name="first-name" class="form-control" value="<?php the_author_meta( 'first_name', $current_user->ID ); ?>" placeholder="<?php _e('Adınız', 'geo'); ?>">
										<label for="first-name"><?php _e('Adınız', 'geo'); ?></label>
									</div>
								</div>
								
								<div class="form-group">
									<div class="form-label-group">
										<input type="text" id="last-name" name="last-name" class="form-control" value="<?php the_author_meta( 'last_name', $current_user->ID ); ?>" placeholder="<?php _e('Soyadınız', 'geo'); ?>">
										<label for="last-name"><?php _e('Soyadınız', 'geo'); ?></label>
									</div>
								</div>
								
								<div class="form-group">
									<div class="form-label-group">
										<input type="text" id="username_disable" name="username_disable" class="form-control" value="<?php the_author_meta( 'user_nicename', $current_user->ID ); ?>" placeholder="<?php _e('Kullanıcı Adınız', 'geo'); ?>" disabled>
										<label for="username_disable"><?php _e('Kullanıcı Adınız', 'geo'); ?></label>
									</div>
								</div>
								
								<div class="form-group">
									<div class="form-label-group">
										<input type="text" id="nickname" name="nickname" class="form-control" value="<?php the_author_meta( 'nickname', $current_user->ID ); ?>" placeholder="<?php _e('Takma Adınız', 'geo'); ?>">
										<label for="nickname"><?php _e('Takma Adınız', 'geo'); ?></label>
									</div>
								</div>
								
								<div class="form-group">
									<div class="form-label-group">
										<select name="display_name" class="form-control" id="display_name"><br/>
										<?php
											$public_display = array();
											$public_display['display_nickname']  = $current_user->nickname;
											$public_display['display_username']  = $current_user->user_login;

											if ( !empty($current_user->first_name) )
												$public_display['display_firstname'] = $current_user->first_name;

											if ( !empty($current_user->last_name) )
												$public_display['display_lastname'] = $current_user->last_name;

											if ( !empty($current_user->first_name) && !empty($current_user->last_name) ) {
												$public_display['display_firstlast'] = $current_user->first_name . ' ' . $current_user->last_name;
												$public_display['display_lastfirst'] = $current_user->last_name . ' ' . $current_user->first_name;
											}

											if ( ! in_array( $current_user->display_name, $public_display ) ) // Only add this if it isn't duplicated elsewhere
												$public_display = array( 'display_displayname' => $current_user->display_name ) + $public_display;

											$public_display = array_map( 'trim', $public_display );
											$public_display = array_unique( $public_display );

											foreach ( $public_display as $id => $item ) {
										?>
											<option <?php selected( $current_user->display_name, $item ); ?>><?php echo $item; ?></option>
										<?php
											}
										?>
										</select>
										<label for="display_name"><?php _e('Görünecek Adınız', 'geo'); ?></label>
									</div>
								</div>
								
								<div class="form-group">
									<div class="form-label-group">
										<input type="email" id="email" name="email" class="form-control" value="<?php the_author_meta( 'user_email', $current_user->ID ); ?>" placeholder="<?php _e('E-Posta Adresiniz', 'geo'); ?>">
										<label for="email"><?php _e('E-Posta Adresiniz', 'geo'); ?></label>
									</div>
								</div>
								
								<div class="form-group">
									<div class="form-label-group">
										<input type="text" id="url" name="url" class="form-control" value="<?php the_author_meta( 'user_url', $current_user->ID ); ?>" placeholder="<?php _e('Web Siteniz', 'geo'); ?>">
										<label for="url"><?php _e('Websiteniz', 'geo'); ?></label>
									</div>
								</div>
								
								<div class="form-group">
									<div class="form-label-group">
										<textarea name="description" id="description" rows="5" class="form-control" placeholder="<?php _e('Hakkınızda', 'geo'); ?>" cols="50"><?php the_author_meta( 'description', $current_user->ID ); ?></textarea>
										<label for="description"><?php _e('Hakkınızda', 'geo'); ?></label>
									</div>
								</div>
								
								<h3><?php _e('Hesap Yönetimi', 'geo'); ?></h3>
								
								
								<div class="form-group">
									<div class="form-label-group">
										<input type="password" id="pass1" name="pass1" class="form-control" placeholder="<?php _e('Şifreniz', 'geo'); ?>">
										<label for="pass1"><?php _e('Şifreniz', 'geo'); ?></label>
									</div>
								</div>
								
								<div class="form-group">
									<div class="form-label-group">
										<input type="password" id="pass2" name="pass2" class="form-control" placeholder="<?php _e('Şifreniz Tekrar', 'geo'); ?>">
										<label for="pass2"><?php _e('Şifreniz Tekrar', 'geo'); ?></label>
									</div>
								</div>
								
								
										<h3><?php _e('Profil Arkaplanı', 'geo'); ?> <?php if(ot_get_option('geo_puan_sistem') == 'on'): ?><span class="puan_label geo_trending_post" data-balloon-pos="top" data-balloon="<?php printf( __('Tek seferliğine %1$s puan kazandırır.', 'geo'), ot_get_option('geo_puan_cover'));?>"></span><?php endif; ?></h3>
										<div class="form-group">
										<input type="file" name="cover_bg" class="form-control" id="cover_bg" accept="image/*">
										</div>
										<p style="font-size:12px;"><?php _e('Önerilen boyut 410x150px.'); ?></p>
										<div class="clearfix"></div>
										<hr>
                    <?php 
										$false = 'off';
                        //action hook for plugin and extra fields
                        do_action('edit_user_profile',$current_user, $false); 
                    ?>
                    <p class="form-submit">
                        <?php $referer = ''; echo $referer; ?>
                        <input name="updateuser" type="submit" id="updateuser" class="submit button geo-post-submit" value="<?php _e('Değişiklikleri Kaydet', 'geo'); ?>" />
                        <?php wp_nonce_field( 'update-user_'. $current_user->ID ); ?>
                        <input name="action" type="hidden" id="action" value="update-user" />
                    </p><!-- .form-submit -->
										<div class="clearfix"></div>
               </form><!-- #adduser -->
				</div>
        <?php endif; ?>
        </div><!-- .entry-content -->
    </div><!-- .hentry .post -->
    <?php endwhile; ?>
<?php else: ?>
    <p class="no-data">
        <?php _e('Bulunamadı.', 'geo'); ?>
    </p><!-- .no-data -->
<?php endif; ?>
<div class="clear"></div>
</div>
</div>
</div>
</main>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<?php if ( ! is_user_logged_in() ) : ?>
<script>
function updateURLParameter(url, param, paramVal){
    var newAdditionalURL = "";
    var tempArray = url.split("?");
    var baseURL = tempArray[0];
    var additionalURL = tempArray[1];
    var temp = "";
    if (additionalURL) {
        tempArray = additionalURL.split("&");
        for (var i=0; i<tempArray.length; i++){
            if(tempArray[i].split('=')[0] != param){
                newAdditionalURL += temp + tempArray[i];
                temp = "&";
            }
        }
    }

    var rows_txt = temp + "" + param + "=" + paramVal;
    return baseURL + "?" + newAdditionalURL + rows_txt;
}

var newURL = updateURLParameter(window.location.href, 'locId', 'newLoc');
newURL = updateURLParameter(newURL, 'resId', 'newResId');

window.history.replaceState('', '', updateURLParameter(window.location.href, "login", "true"));
</script>
<?php endif; ?>
<?php get_footer();?>