<?php
/**
 * Template Name: Üye Puanları
 * @url kanthemes.com
 */
__('Üye Puanları', 'geo');
geoit_header(); ?>
<main class="uck-layout__content" role="main" style="margin:3em 0">
	<div class="page__content">
		<div class="container">
			<div class="row">
				<div id="content "class="content content__single col-md-8" style="margin: 0 auto;float:none">
					<?php if ( have_posts() ) : 
					while ( have_posts() ) : the_post();
						$content = get_the_content();
						if (!empty($content))
							echo '<div class="alert alert-secondary" role="alert">'.$content.'</div>';
					endwhile;
					endif; ?>
					<div class="widget geowidgetusers page-users">
						<div class="content__title"><h3 class="uckan-btn"><?php the_title(); ?></h3></div>
						<?php
								$rank = ot_get_option('geo_user_ranking_role');
								if ($rank == '-1') {
									$rank = -1;
								}
								$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
								$count = 10;
								if( $paged==1 ){
									 $offset = 0;  
								}
								else {
									 $offset= ($paged-1) * $count;
								}
								$geo_userquery = new WP_User_Query( 
									array (
									'meta_query' => array(
										array(
											'type' => 'NUMERIC'
										)
									),
									'meta_key' => 'geo_user_points', 'order' => 'DESC', 'orderby' => 'meta_value_num',
									'role' => $rank,
									'number' => $count,
									'offset' => $offset
									)
								);
								if (ot_get_option('geo_puan_sistem') == 'on') {
									if (  !empty( $geo_userquery->results ) ) {
										echo '<div class="geo_users-list">'; $counter = 0;
											foreach ( $geo_userquery->results as $users ) { $counter++; ?>
												<div class="geoit_user_ranking <?php if($paged == 1 && $counter=='1'):?>birinci_uye<?php endif;?>">
												<div>
													<span class="user_count">
													<?php if($paged != 1): ?>
														<?php echo $count+$counter; ?>
													<?php else: ?>
														<?php echo $counter; ?>
													<?php endif; ?>
													</span>
													<?php echo get_avatar(get_the_author_meta('user_email', $users->ID),'25'); ?>
													<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $users->ID ) ); ?>"><?php the_author_meta('display_name', $users->ID); ?><?php geoit_verified_user($users->ID); ?></a>
												</div>
												<?php echo geo_get_points($users->ID); ?> <?php _e('Puan', 'geo'); ?>
											</div>
											<?php }
										echo '</div>';
										
									}
									else {
										echo '<p style="padding:1em">'.__('Listelenecek üye bulunamadı.', 'geo').'</p>';
									}
								}
								else {
									echo '<p style="padding:1em">'.__('Puan sistemini etkinleştirmeniz gerekiyor.', 'geo').'</p>';
								}
								
								?>
					</div>
					<?php $top_user = $geo_userquery->total_users;  
										$pages = ceil($top_user/$count);
										if ($paged > 1):
										echo '<nav class="navigation pagination">';
											echo paginate_links(array(  
												'base' => get_pagenum_link(1) . '%_%',  
												'format' => '?paged=%#%',  
												'current' => $paged,  
												'total' => $pages,  
												'prev_text' => __('Önceki Sayfa', 'geo'),  
												'next_text' => __('Sonraki Sayfa', 'geo'),
												'type'     => 'plain',
											)); 
										echo '</nav>';  endif;?>
				</div>
			</div>
		</div>
	</div>
</main>
<?php get_footer();