<?php
if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

/*-----------------------------------------------------------------------------------*/
# Geoit: Admin Menü Oluştur
/*-----------------------------------------------------------------------------------*/
add_action( 'admin_menu', 'my_admin_menu' );
if ( ! function_exists( 'my_admin_menu' ) ) {
	function my_admin_menu() {
		
		$xml = get_latest_theme_version( NOTIFIER_CACHE_INTERVAL );
		if (
					isset( $xml->latest )
					&& version_compare( $xml->latest, THEME_VER, '>' )
				) {
			$title = 'Geoit <span class="update-plugins count-1"><span class="plugin-count">1</span></span>';
			$title2 = __('Güncellemeler', 'geo-admin').' <span class="update-plugins count-1"><span class="plugin-count">1</span></span>';
		}
		else {
			$title = 'Geoit';
			$title2 = __('Güncellemeler', 'geo-admin');
		}
		add_menu_page( __('Tema Ayarları', 'geo-admin'), ''.$title.'', 'manage_options', 'ot-theme-options', 'geoit_theme_option', ''.get_template_directory_uri().'/assets/img/kanthemes_favicon.png', 60  );
		add_submenu_page('ot-theme-options', __('Tema Ayarları', 'geo-admin'), __('Tema Ayarları', 'geo-admin'), 'manage_options', 'ot-theme-options', 'geoit_theme_option' );
		add_submenu_page('ot-theme-options', __('Geoit Temasına Hoşgeldiniz', 'geo-admin'), __('Hoşgeldiniz', 'geo-admin'), 'manage_options', 'geoit-welcome', 'geoit_welcome_message' );
		add_submenu_page('ot-theme-options', __('Güncellemeler', 'geo-admin'), ''.$title2.'', 'manage_options', 'geoit-update', 'geoit_update' );
		// add_submenu_page(null, __('Lisans Durumu', 'geo-admin'),  __('Lisans Durumu', 'geo-admin'), 'manage_options', 'geoit-system', 'geoit_system_status' );
		add_submenu_page('ot-theme-options', __('Ayarları İçe Aktar', 'geo-admin'), __('Ayarları İçe Aktar', 'geo-admin'), 'manage_options', 'geoit-import', 'geoit_import_data' );
		add_submenu_page('ot-theme-options', __('Uyumlu Eklentiler', 'geo-admin'), __('Uyumlu Eklentiler', 'geo-admin'), 'manage_options', 'geoit-plugins', 'geoit_plugin_data' );
		// add_submenu_page('ot-theme-options', __('Destek Masası', 'geo-admin'), __('Destek Masası', 'geo-admin'), 'manage_options', 'https://www.kanthemes.com/theme/geoit', null );
		// add_submenu_page('ot-theme-options', __('Neler Yeni', 'geo-admin'), __('Neler Yeni', 'geo-admin'), 'manage_options', 'geoit-about', 'geoit_neler_yeni' );
		
	}
}


function add_item($admin_bar)  {
$args = array(
    'id'        => 'geoit-theme-admin-bar', // Must be a unique name
    'title'     => '<img src="'.get_template_directory_uri().'/assets/img/kanthemes_favicon.png" width="12" height="12" style="width:18px!important;height:18px!important;vertical-align:-4px;margin-right:8px;"/>'.__('Geoit Ayarları', 'geo-admin'), // Label for this item
    'href'      => get_admin_url() . 'admin.php?page=ot-theme-options',
);
$admin_bar->add_menu( $args);
}
add_action('admin_bar_menu', 'add_item', 900); // 10 = Position on the admin bar
/*-----------------------------------------------------------------------------------*/
# Geoit: Admin Menü Tab
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_admin_tab' ) ) {
	function geoit_admin_tab($aktif1, $aktif2, $aktif3, $aktif4, $aktif5) { ?>
		<h2 class="nav-tab-wrapper geo-nav-tab-wrapper wp-clearfix">
			<a href="<?php echo admin_url(); ?>admin.php?page=geoit-welcome" class="nav-tab <?php echo $aktif1; ?>"><?php _e('Hoş geldiniz', 'geo-admin'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=ot-theme-options" class="nav-tab <?php echo $aktif2; ?>"><?php _e('Tema Ayarları', 'geo-admin'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=geoit-license" class="nav-tab <?php echo $aktif3; ?>"><?php _e('Lisans Kontrolü', 'geo-admin'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=geoit-update" class="nav-tab <?php echo $aktif4; ?>"><?php _e('Güncellemeler', 'geo-admin'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=geoit-import" class="nav-tab <?php echo $aktif5; ?>"><?php _e('Ayarları İçe Aktar', 'geo-admin'); ?></a>
			<a target="_blank" href="https://www.kanthemes.com/theme/geoit" class="nav-tab"><?php _e('Destek Masası', 'geo-admin'); ?></a>
		</h2>
		<?php 

		$xml = get_latest_theme_version( NOTIFIER_CACHE_INTERVAL ); // Get the latest remote XML file on our server
		if (
					isset( $xml->latest )
					&& version_compare( $xml->latest, THEME_VER, '>' )
				): ?>
		<br><div class="update-nag" style="margin: 5px 0 0;border-left-color: #dc3232;">

					<?php

					if ( isset( $xml->message ) && trim( $xml->message ) ) {
						echo '<strong>' . trim( $xml->message ) . '</strong><br />';
					}

					printf( __('<strong>%1$s</strong> temasının %2$s sürümü kurulu. <strong>%3$s</strong> sürümüne yükseltebilirsiniz. <a href="%4$s">Güncellemek için tıklayın.</a>', 'geo-admin'),
						THEME_NAME,
						THEME_VER,
						trim( $xml->latest ),
						admin_url().'admin.php?page=geoit-update'
					);
					?>

				</div>
				<?php endif; ?>
	<?php }
}

/*-----------------------------------------------------------------------------------*/
# Geoit: Tema Ayarları
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_theme_option' ) ) {
	function geoit_theme_option(){
		echo '<div class="wrap s-wrap"><h1>'.__('Geoit Tema Ayarlarına Hoş Geldiniz!').'</h1>';
		echo '<p>'.__('Geoit temasını kendi zevkinize göre şekilendirmeye hemen başlayabilirsiniz', 'geo-admin').'.</p>';
		echo '</div>';
		echo geoit_admin_tab(null, 'nav-tab-active', null, null, null);
	}
}

/*-----------------------------------------------------------------------------------*/
# Geoit: Uyumlu Eklentiler
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_plugin_data' ) ) {
	function geoit_plugin_data(){ ?>
	<div class="wrap s-wrap">
		<h3><?php _e('Geoit ile Uyumlu Eklentiler', 'geo-admin'); ?></h3><br>
				<table class="wp-list-table widefat fixed">
					<thead>
						<tr>
							<th scope="col" id="plugin" class="manage-column column-plugin column-primary"><?php _e('Plugin'); ?></th>
							<th scope="col" id="tur" class="manage-column column-tur"><?php _e('Type'); ?></th>
							<th scope="col" id="status" class="manage-column column-status"><?php _e('Status'); ?></th>
						</tr>
					</thead>
					<tbody id="one-list">
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="<?php $plugin = 'litespeed-cache'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								Litespeed Cache</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Hız', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'litespeed-cache'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="<?php $plugin = 'wordpress-soe'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								Wordpress Seo by Yoast</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Seo', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'wordpress-soe'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="<?php $plugin = 'contact-form-7'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								Contact Form 7</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('İletişim', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'contact-form-7'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="<?php $plugin = 'wp-smushit'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								Smush</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Optimizasyon', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'wp-smushit'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="https://www.kanthemes.com/files/wp-ultimate-crypto.zip" class="thickbox">
								WP Ultimate Crypto</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'wp-ultimate-crypto'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="<?php $plugin = 'wp-quiz'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								WP Quiz</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'wp-quiz'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="<?php $plugin = 'table-of-contents-plus'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Table of Contents Plus</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'table-of-contents-plus'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="<?php $plugin = 'nextend-facebook-connect'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Nextend Social Login</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'nextend-facebook-connect'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="<?php $plugin = 'google-captcha'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Google Captcha (reCAPTCHA)</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Güvenlik', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'google-captcha'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a href="<?php $plugin = 'post-views-counter'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Post Views Counter</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'geo-admin'); ?></td>
							<td class="source column-status" data-colname="status">
								<a class="install-now button" href="<?php $plugin = 'post-views-counter'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'geo-admin'); ?></a>
							</td>
						</tr>

					</tbody>
				</table>
				</div>
	<?php }
}

/*-----------------------------------------------------------------------------------*/
# Geoit: Hoşgeldiniz
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_welcome_message' ) ) {
	function geoit_welcome_message(){
		?>
		<div class="wrap s-wrap">
			<h1>
			<?php 
			printf( __('Geoit v<strong>%1$s</strong> sürümüne hoşgeldiniz.', 'geo-admin'),
				THEME_VER
			);
			?>
			</h1>
			<p class="about-text"><?php _e('Harika! Geoit wordpress teması başarıyla kuruldu ve kullanıma hazır durumda!', 'geo-admin'); ?></p>
			<div class="wp-badge" style="position: absolute;top: 0;right: 0;">v<?php echo THEME_VER; ?></div>
			<?php geoit_admin_tab('nav-tab-active', null, null, null, null); ?>
			<div class="geoit-row">
				<div id="welcome-panel" class="welcome-panel">
					<div class="welcome-panel-content">
						<h3 style="margin:0;"><?php _e('Geoit ile başlarken', 'geo-admin'); ?></h3>
						<div class="welcome-panel-column-container">
							<div class="welcome-panel-column">
								<h4><?php _e('Geoit\'i Ayarla', 'geo-admin'); ?></h4>
								<ul>
									<li><a href="<?php echo admin_url('edit.php?post_type=page'); ?>" class="welcome-icon welcome-edit-page"><?php _e('Gerekli Sayfaları Oluştur', 'geo-admin'); ?></a></li>
									<li><a href="<?php echo admin_url('nav-menus.php'); ?>" class="welcome-icon welcome-edit-page"><?php _e('Menü Ayarlarını yap', 'geo-admin'); ?></a></li>
									<li><a href="<?php echo admin_url('admin.php?page=ot-theme-options');?>" class="welcome-icon welcome-edit-page"><?php _e('Tema Ayarlarına Yap', 'geo-admin'); ?></a></li>
									<li><a href="<?php echo admin_url('widgets.php');?>" class="welcome-icon welcome-edit-page"><?php _e('Bileşenleri Ayarla', 'geo-admin'); ?></a></li>
									<li><a href="<?php echo admin_url('options-general.php?page=geo_options');?>" class="welcome-icon welcome-edit-page"><?php _e('Reaksiyon Butonları', 'geo-admin'); ?></a></li>
								</ul>
								<a class="button button-primary button-hero" style="margin-bottom:20px;margin-top:0;" href="<?php echo admin_url('admin.php?page=ot-theme-options');?>"><?php _e('Tema Ayarları', 'geo-admin'); ?></a>
								<a class="button button-primary button-hero" style="margin-bottom:20px;margin-top:0;" href="https://www.kanthemes.com/theme/geoit"><?php _e('Destek Masası', 'geo-admin'); ?></a>
							</div>
							<div class="welcome-panel-column">
								<h4><?php _e('Hızlı Erişim', 'geo-admin'); ?></h4>
								<ul>
									<li><a target="_blank" href="https://www.kanthemes.com/theme/geoit/update.html" class="welcome-icon welcome-add-page"><?php _e('Güncelleme Notları', 'geo-admin'); ?></a></li>
									<li><a target="_blank" href="https://www.kanthemes.com/theme/geoit" class="welcome-icon welcome-add-page"><?php _e('Destek Masası', 'geo-admin'); ?></a></li>																				
									<li><a target="_blank" href="https://www.kanthemes.com/iletisim" class="welcome-icon welcome-add-page"><?php _e('İletişim', 'geo-admin'); ?></a></li>
								</ul>
							</div>
							<div class="welcome-panel-column welcome-panel-last">
								<h4><?php _e('Destek', 'geo-admin'); ?></h4>
								<p class="welcome-icon welcome-learn-more" style="margin-right:10px"><a target="_blank" href="https://www.kanthemes.com/theme/geoit/docs.html"><?php _e('Çevrimiçi Dökümantasyon', 'geo-admin'); ?></a></p>
								<p class="welcome-icon welcome-learn-more" style="margin-right:10px"><?php _e('İhtiyacınız olanı bulamadınız mı? O halde bize e-posta gönderin.', 'geo-admin'); ?> </p>
								<p  style="margin-right:10px"><a href="mailto:destek@kanthemes.com">destek@kanthemes.com</a> </p>
							</div>
						</div>
					</div>
				</div>

				<h3 style="border-top: 1px solid #ddd;padding-top:15px" class="headline">Bizden Haberler</h3>
				<p class="about-text">Kurumumuz ve tema ile alakalı son haberlerin yer aldığı bölümdür, sayfanın en üstünde bulunan versiyon numarasına göre haberi dikkate alıp almayacağını anlayabilirsiniz.</p>
				<iframe class="item-demo-iframe" frameborder="0" noresize="noresize" src="//kanthemes.com/files/geoit/duyuru.html"></iframe>
			</div>
			<a href="https://twitter.com/share?ref_src=twsrc%5Etfw" class="twitter-share-button" data-size="large" data-text="Geoit Wordpress temasını siteme kurdum, sizede tavsiye ederim." data-url="http://www.cagriuckan.com/landing/geoit" data-via="kanthemes" data-hashtags="geoitwptheme" data-show-count="false">Tweet</a><script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
			
		</div>
		<?php
	}
}

/*-----------------------------------------------------------------------------------*/
# Geoit: Güncellemeler
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_update' ) ) {
	function geoit_update(){
		?>
		<div class="wrap s-wrap">
			<h1><?php 
			printf( __('Geoit <strong>%1$s</strong> sürümüne hoşgeldiniz.', 'geo-admin'),
				THEME_VER
			);
			?></h1>
		<p class="about-text"><?php _e('Geoit\'in en son yayınlanan güncellemesini buradan indirip yükleyebilirsiniz.', 'geo-admin'); ?></p>
			<div class="wp-badge" style="position: absolute;top: 0;right: 0;">v<?php echo THEME_VER; ?></div>
			<?php geoit_admin_tab(null, null, null, 'nav-tab-active', null); ?>
			<div class="geoit-row">
				<h3><?php _e('Güncelleme Nasıl Yapılır', 'geo-admin'); ?></h3>
				<ul>
					<li>1. <a href="https://www.kanthemes.com/hesabim/" target="_blank">Hesabım</a> sayfasına giderek giriş yapın.</li>
					<li>2. Sol sidebardan <strong>İndirmeler</strong> sekmesine tıklayın.</li>
					<li>2. <strong>İndirme</strong> sütununda bulunan indirme linkine tıklayarak tema dosyaları indirin.</li>
					<li>3. <a href="<?php echo admin_url(); ?>plugin-install.php?tab=plugin-information&plugin=easy-theme-and-plugin-upgrades&TB_iframe=true&width=600&height=550" target="_blank">Easy Theme and Plugin Upgrades</a> eklentisi sitenize kurup etkinleştirin.</li>
					<li>4. <strong>Wp admin > Görünüm</strong> sayfasını açın</li>
					<li>5. <strong>Yeni Ekle</strong> butonuna tıklayın açılan sayfadan <strong>Tema Yükle</strong> butonuna ardındada <strong>Dosya Seç</strong> butonuna tıklayın.</li>
					<li>6. Açılan ekranda indirdiğiniz <strong>geoit.zip</strong> dosyasını bulun ve seçin</li>
					<li>7. Son olarak <strong>Hemen Yükle</strong> butonuna tıklayın ve temayı güncelleyin.</li>
				</ul>
				
				<h3><?php _e('Yardımcı Linkler', 'geo-admin'); ?></h3>
				<a href="https://www.kanthemes.com/theme/geoit/update.html" target="_blank" class="button button-primary">Güncelleme Notları</a>
				<a href="https://www.youtube.com/watch?v=kAala6AAY0g" target="_blank" class="button button-primary">Güncelleme Nasıl Yapılır?</a>
			</div>
		</div>
		<?php
	}
}


/*-----------------------------------------------------------------------------------*/
# Geoit: Import Data
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_import_data' ) ) {
	function geoit_import_data(){ ?>
		<div class="wrap s-wrap">
			<h1><?php _e('Tema Ayarlarını İçe Aktar', 'geo-admin');?></h1>
			<p class="about-text"><?php _e('Önceden hazırlanmış demo ayarlarından birini sitenize hızlı bir şekilde uygulayabilirsiniz.', 'geo-admin');?></p>
			<?php geoit_admin_tab(null, null, null, null, 'nav-tab-active'); ?>
			<div class="geoit-row">
				<h3>1. <?php _e('Demo İçeriğini İçe Aktar', 'geo-admin');?></h3>
				<a target="_blank" href="<?php echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin=one-click-demo-import&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="button button-primary">1. <?php _e('Eklentiyi Kur ve Etkinleştir', 'geo-admin'); ?></a>
				<a target="_blank" href="<?php admin_url(); ?>themes.php?page=pt-one-click-demo-import" class="button button-primary">2. <?php _e('Demo İçeriğini İçe Aktarmak için Tıkla', 'geo-admin'); ?></a>
				<h3>2. <?php _e('Demo Tema Ayarlarını İçe Aktar', 'geo-admin');?></h3>
				<?php $temp = get_template_directory(); ?>
				<p><?php _e('Kullanmak istediğiniz demonun butonuna tıklayın, karşınıza çıkan sayfadaki kodu kopyalayın ve aşağıdaki beyaz kutucuğa yapıştırın, son olarakta "Import Theme Options" butonuna tıklayın.', 'geo-admin'); ?></p>
				<a target="_blank" href="https://www.kanthemes.com/files/geoit/demo/genel/options.txt" class="button button-primary"><?php _e('Genel Demo', 'geo-admin'); ?></a>
				<a target="_blank" href="https://www.kanthemes.com/files/geoit/demo/teknoloji/options.txt" class="button button-primary"><?php _e('Teknoloji Demo', 'geo-admin'); ?></a>
				<a target="_blank" href="https://www.kanthemes.com/files/geoit/demo/viral/options.txt" class="button button-primary"><?php _e('Viral Demo', 'geo-admin'); ?></a>
				<a target="_blank" href="https://www.kanthemes.com/files/geoit/demo/moda/options.txt" class="button button-primary"><?php _e('Moda Demo', 'geo-admin'); ?></a>
				<a target="_blank" href="https://www.kanthemes.com/files/geoit/demo/gezi/options.txt" class="button button-primary"><?php _e('Gezi Demo', 'geo-admin'); ?></a>
				<a target="_blank" href="https://www.kanthemes.com/files/geoit/demo/blog/options.txt" class="button button-primary"><?php _e('Kişisel Blog Demo', 'geo-admin'); ?></a>
				<a target="_blank" href="https://www.kanthemes.com/files/geoit/demo/viral-2/options.txt" class="button button-primary"><?php _e('Viral Demo 2', 'geo-admin'); ?></a>
				<?php geoit_demo_import(); ?>
			</div>
		</div>
	<?php }
}

// One Click Demo Import
if ( ! function_exists( 'geoit_import_files' ) ) :
function geoit_import_files() {
	return array(
		array(
			'import_file_name'           => __('Genel Demo', 'geo-admin'),
			'categories'                 => array( 'Blog', 'Magazine' ),
			'import_file_url'            => 'https://www.kanthemes.com/files/geoit/demo/genel/wordpress.xml',
			'import_widget_file_url'     => 'https://www.kanthemes.com/files/geoit/demo/genel/widgets.wie',
			'import_customizer_file_url' => 'https://www.kanthemes.com/files/geoit/demo/genel/customizer.txt',
			'import_preview_image_url'   => 'https://www.kanthemes.com/landing/geoit/demo/img/1.png',
			'preview_url'                => 'https://demo.kanthemes.com/geoit/tr/',
		),
		array(
			'import_file_name'           => __('Teknoloji Demo', 'geo-admin'),
			'categories'                 => array( 'Blog', 'Magazine' ),
			'import_file_url'            => 'https://www.kanthemes.com/files/geoit/demo/teknoloji/wordpress.xml',
			'import_widget_file_url'     => 'https://www.kanthemes.com/files/geoit/demo/teknoloji/widgets.wie',
			'import_customizer_file_url' => 'https://www.kanthemes.com/files/geoit/demo/teknoloji/customizer.txt',
			'import_preview_image_url'   => 'https://www.kanthemes.com/landing/geoit/demo/img/2.png',
			'preview_url'                => 'https://demo.kanthemes.com/geoit/tr/teknoloji',
		),
		array(
			'import_file_name'           => __('Viral Demo', 'geo-admin'),
			'categories'                 => array( 'Viral' ),
			'import_file_url'            => 'https://www.kanthemes.com/files/geoit/demo/viral/wordpress.xml',
			'import_widget_file_url'     => 'https://www.kanthemes.com/files/geoit/demo/viral/widgets.wie',
			'import_customizer_file_url' => 'https://www.kanthemes.com/files/geoit/demo/viral/customizer.txt',
			'import_preview_image_url'   => 'https://www.kanthemes.com/landing/geoit/demo/img/3.png',
			'preview_url'                => 'https://demo.kanthemes.com/geoit/tr/viral',
		),
		array(
			'import_file_name'           => __('Moda/Kadın Demo', 'geo-admin'),
			'categories'                 => array( 'Blog', 'Magazine' ),
			'import_file_url'            => 'https://www.kanthemes.com/files/geoit/demo/moda/wordpress.xml',
			'import_widget_file_url'     => 'https://www.kanthemes.com/files/geoit/demo/moda/widgets.wie',
			'import_customizer_file_url' => 'https://www.kanthemes.com/files/geoit/demo/moda/customizer.txt',
			'import_preview_image_url'   => 'https://www.kanthemes.com/landing/geoit/demo/img/4.png',
			'preview_url'                => 'https://demo.kanthemes.com/geoit/tr/moda',
		),
		array(
			'import_file_name'           => __('Gezi Demo', 'geo-admin'),
			'categories'                 => array( 'Blog' ),
			'import_file_url'            => 'https://www.kanthemes.com/files/geoit/demo/gezi/wordpress.xml',
			'import_widget_file_url'     => 'https://www.kanthemes.com/files/geoit/demo/gezi/widgets.wie',
			'import_customizer_file_url' => 'https://www.kanthemes.com/files/geoit/demo/gezi/customizer.txt',
			'import_preview_image_url'   => 'https://www.kanthemes.com/landing/geoit/demo/img/5.png',
			'preview_url'                => 'https://demo.kanthemes.com/geoit/tr/gezi',
		),
		array(
			'import_file_name'           => __('Kişisel Blog', 'geo-admin'),
			'categories'                 => array( 'Blog' ),
			'import_file_url'            => 'https://www.kanthemes.com/files/geoit/demo/blog/wordpress.xml',
			'import_widget_file_url'     => 'https://www.kanthemes.com/files/geoit/demo/blog/widgets.wie',
			'import_customizer_file_url' => 'https://www.kanthemes.com/files/geoit/demo/blog/customizer.txt',
			'import_preview_image_url'   => 'https://www.kanthemes.com/landing/geoit/demo/img/6.png',
			'preview_url'                => 'https://demo.kanthemes.com/geoit/tr/blog',
		),
		array(
			'import_file_name'           => __('Viral Demo #2', 'geo-admin'),
			'categories'                 => array( 'Viral' ),
			'import_file_url'            => 'https://www.kanthemes.com/files/geoit/demo/viral-2/wordpress.xml',
			'import_widget_file_url'     => 'https://www.kanthemes.com/files/geoit/demo/viral-2/widgets.wie',
			'import_customizer_file_url' => 'https://www.kanthemes.com/files/geoit/demo/viral-2/customizer.txt',
			'import_preview_image_url'   => 'https://kanthemes.com/landing/geoit/demo/img/7.png',
			'preview_url'                => 'https://demo.kanthemes.com/geoit/',
		),
		
	);
}
add_filter( 'pt-ocdi/import_files', 'geoit_import_files' );
endif;



// Demo Import Theme Options
if ( ! function_exists( 'geoit_demo_import' ) ) {
	function geoit_demo_import() {
		if(current_user_can('administrator')) {
		echo '<form method="post" id="import-data-form">';
		 
				/* form nonce */
				wp_nonce_field( 'import_data_form', 'import_data_nonce' );
					
				/* format setting outer wrapper */
				echo '<div class="format-setting type-textarea has-desc">';
					
					/* description */
					echo '<div class="description">';
						
						if ( OT_SHOW_SETTINGS_IMPORT ) echo '<p>' . __( 'Only after you\'ve imported the Settings should you try and update your Theme Options.', 'geo-admin' ) . '</p>';
						
						echo '<p>' . __( 'To import your Theme Options copy and paste what appears to be a random string of alpha numeric characters into this textarea and press the "Import Theme Options" button.', 'geo-admin' ) . '</p>';
						
						/* button */
						
					echo '</div>';
					
					/* textarea */
					echo '<div class="format-setting-inner">';
						
						echo '<textarea rows="10" cols="40" name="import_data" id="import_data" class="textarea"></textarea>';
						echo '<button class="option-tree-ui-button button button-primary">' . __( 'Import Theme Options', 'geo-admin' ) . '</button>';

					echo '</div>';
					
				echo '</div>';
			
			echo '</form>';
	}
	else {
		echo '<p>Bu işlemi sadece site yöneticileri yapabilir.</p>';
	}
	}
}

/*-----------------------------------------------------------------------------------*/
# Geoit: ADmin Yönlendir
/*-----------------------------------------------------------------------------------*/
function geoit_theme_active_redirect_page() {
	global $pagenow;
	if ( 'themes.php' == $pagenow && isset( $_GET['activated'] ) ) {
		if (geoit__get__status() == true) {
			wp_redirect(admin_url("admin.php?page=geoit-welcome"));
		} else {
			wp_redirect(admin_url("admin.php?page=geoit-license"));
		}
	}
}
add_action('admin_init', 'geoit_theme_active_redirect_page');

/*-----------------------------------------------------------------------------------*/
# Geoit: Dashboard Widget
/*-----------------------------------------------------------------------------------*/
function register_geoit_dashboard_widget() {
 	global $wp_meta_boxes;
	wp_add_dashboard_widget(
		'geoit_dashboard_widget',
		__('Geoit Wordpress Teması', 'geo-admin'),
		'geoit_dashboard_widget_display'
	);

 	$dashboard = $wp_meta_boxes['dashboard']['normal']['core'];

	$my_widget = array( 'geoit_dashboard_widget' => $dashboard['geoit_dashboard_widget'] );
 	unset( $dashboard['geoit_dashboard_widget'] );

 	$sorted_dashboard = array_merge( $my_widget, $dashboard );
 	$wp_meta_boxes['dashboard']['normal']['core'] = $sorted_dashboard;
}
add_action( 'wp_dashboard_setup', 'register_geoit_dashboard_widget' );

function geoit_dashboard_widget_display() {
	?>

<div id="activity-widget">
	<div id="published-posts" class="activity-block">
		<a class="button button-primary" style="margin-bottom:20px;margin-top:0;" href="<?php echo admin_url('admin.php?page=ot-theme-options'); ?>">Tema Ayarları</a>
		<a class="button button-success" style="margin-bottom:20px;margin-top:0;" href="https://www.kanthemes.com/theme/geoit">Destek Masası</a>
	</div>
	<div id="published-posts" class="activity-block">
		<h3>Gündem</h3>
		<div class="rss-widget">
			<ul>
				<li><a href="https://www.bit.ly/geoit-dashboard-1-1">Geoit WordPress Teması: v4.9’de Neler Yeni?</a></li>
				<li><a href="https://www.kanthemes.com/geoit-wordpress-temasi-v4-8de-neler-yeni/">Geoit WordPress Teması: v4.8’de Neler Yeni?</a></li>
			</ul>
		</div>
	</div>
</div>

	<?php
}