<?php 
function custom_meta_boxes() { 

$my_meta_box2 = array( 
	'id' => 'my_meta_box2',
    'title'       => __( 'Sayfa Ayarları', 'geo' ),
    'pages'       => array( 'page' ),
    'context'     => 'normal',
    'priority'    => 'high',
    'fields'      => array(
	array(
        'label'       => __( 'Bu Sayfa İçin Özel Bileşen Alanı Oluşturun', 'geo' ),
        'desc'       => __( 'Sayfa şablonu olarak "Özel Sidebar" şablonlarından bir tanesini seçmelisiniz. Daha sonra bu sayfa için görünüm>bileşenler sayfasında bu sayfa için oluşturulan sidebarlara bileşenleri ekleyebilirsiniz.', 'geo' ),
        'id'          => 'page_sidebar_status',
		'std'					=> 'off',
		'type'				=> 'on-off',
      ),
	),
);

$my_meta_box = array( 
	'id' => 'my_meta_box',
    'title'       => __( 'Geoit Ayarları', 'geo' ),
    'pages'       => array( 'post' ),
    'context'     => 'normal',
    'priority'    => 'high',
    'fields'      => array(
			array(
        'label'       => __( 'Genel Ayarlar', 'geo' ),
        'id'          => 'post_general',
        'type'        => 'tab'
      ),
			array(
        'label'       => __( 'Trendlere Ekle', 'geo' ),
        'id'          => 'geoit_post_trending',
				'std'					=> 'off',
				'type'				=> 'on-off',
      ),
			
			array(
        'label'       => __( 'Öne Çıkarılan Görsel', 'geo' ),
        'id'          => 'post_show_featured_image',
				'std'					=> 'on',
				'type'				=> 'on-off',
      ),
	  array(
        'label'       => __( 'Reaksiyon Butonları', 'geo' ),
        'id'          => 'geo_reaction_enable',
				'std'					=> 'on',
				'type'				=> 'on-off',
      ),
	  array(
				'id'		=> 'post_meta_position',
				'label'		=>  __( 'Yazı Detaylarının Konumu', 'geo' ),
				'std'		=> 'above',
				'type'		=> 'select',
				'choices'	=> array(
					array(
						'value'		=> 'above',
						'label'		=> __('Öne Çıkan Görselin Üstünde', 'geo'),
					),
					array(
						'value'		=> 'under',
						'label'		=> __('Öne Çıkan Görselin Altında', 'geo'),
					),
				)
			),
			array(
        'label' => __('Yazının Kısa Açıklaması', 'geo'),
				'desc'	=> __('Yazı sayfasında başlığın hemen altında gözükür, ayrıca google ve sosyal medya sitelerinde yazının açıklaması olarak tanınır.', 'geo'),
        'id'          => 'geo_post_desc',
        'type'        => 'textarea',
				'rows'        => '2',
      ),
			array(
        'label'       => __( 'Video Ayarları', 'geo' ),
        'id'          => 'post_video',
        'type'        => 'tab'
      ),
			array(
        'label' => __('Video Embed Kodu', 'geo'),
				'desc'	=> __('Videolara özel sayfayı kullanmak için sağ üst bölümden video formatını seçmeyi unutmayın.', 'geo'),
        'id'          => 'geo_video_url',
        'type'        => 'textarea',
				'rows'        => '2',
      ),
			array(
        'label'       => __( 'Galeri Ayarları', 'geo' ),
        'id'          => 'post_galleries',
        'type'        => 'tab'
      ),
			array(
        'label' => __('Galeri Sayfa Açıklaması', 'geo'),
				'desc'	=> __('Eğer yazı formatı galeri olarak seçiliyse galeri hakkında kısa bir açıklama yapabilirsiniz.', 'geo'),
        'id'          => 'geo_gallery_desc',
        'type'        => 'textarea',
				'rows'        => '2',
      ),
    )
  );
  if ( function_exists( 'ot_register_meta_box' ) ) {
    ot_register_meta_box( $my_meta_box );
    ot_register_meta_box( $my_meta_box2 );
  }
}
add_action( 'admin_init', 'custom_meta_boxes' );