<?php

add_filter( 'amp_customizer_is_enabled', '__return_false' );

function geoit_amp_post_thumbnail() {
	$thumbnail_id = get_post_thumbnail_id();
	if ( $thumbnail_id ) {
		$url = wp_get_attachment_image_url( $thumbnail_id, 'geo-big' );
		echo '<a href="' . get_the_permalink() . '" title="' . get_the_title() . '"><amp-img layout="responsive" src="' . $url . '" width="390" height="218"></amp-img></a>';
	}
}
		
function geoit_amp_reading_time($post) {
	if (ot_get_option('geo-amp-post-reading') != 'off') {
		$uckicerik = $post->post_content; # yazı iceriğini çekiyor
		$word = str_word_count(strip_tags($uckicerik)); # içerikteki kelime sayısını hesaplıyor
		$m = floor($word / 200); # kelime sayısını 200'e bölerek dakika sayısını hesaplıyor
		$s = floor($word % 200 / (200 / 60)); # kelime sayısının %200'ünü alıp 3.33'e bölerek saniyeyi hesaplıyor
		echo '<div class="amp-wp-meta amp-wp-post-reading-time">';
		echo __('Okuma süresi:', 'geo');
		$uckokunma = ' '.$m . __('dk', 'geo') . ($m == 1 ? '' : '') . ', ' . $s . __('sn', 'geo') . ($s == 1 ? '' : '');
		echo $uckokunma;
		echo '</div>';
	}
}
class Geoit_AMP_Menu_Walker extends Walker_Nav_Menu {

	protected $accordion_started = FALSE;
	protected $accordion_childs_started = FALSE;

	public function start_lvl( &$output, $depth = 0, $args = array() ) {
	}

	public function end_lvl( &$output, $depth = 0, $args = array() ) {

		if ( $this->accordion_childs_started && $depth == 0 ) {

			$this->end_accordion_child_wrapper( $output, $depth );
		}

		if ( $this->accordion_started && $depth == 0 ) {
			$this->end_accordion( $output, $depth );
		}

	}

	public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {

		$args = apply_filters( 'nav_menu_item_args', $args, $item, $depth );

		// Remove menu-item-has-children class
		if ( $depth ) {
			$index = array_search( 'menu-item-has-children', $item->classes );
			if ( $index !== FALSE ) {
				unset( $item->classes[ $index ] );
			}
		}

		$classes   = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;

		if ( $depth > 1 ) {
			$classes[] = 'menu-item-deep';
		}

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

		if ( $this->has_children && $depth == 0 ) {
			add_theme_support( 'better-amp-has-nav-child', TRUE );

			$this->start_accordion( $output, $depth );

			$output .= '<h6><span ' . $class_names . '>';
			$output .= $this->get_anchor_tag( $item, $depth, $args, $id );
			$output .= '</span> <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 490.688 490.688" style="enable-background:new 0 0 490.688 490.688;" xml:space="preserve"><path style="fill:#FFC107;" d="M472.328,120.529L245.213,347.665L18.098,120.529c-4.237-4.093-10.99-3.975-15.083,0.262c-3.992,4.134-3.992,10.687,0,14.82l234.667,234.667c4.165,4.164,10.917,4.164,15.083,0l234.667-234.667c4.237-4.093,4.354-10.845,0.262-15.083c-4.093-4.237-10.845-4.354-15.083-0.262c-0.089,0.086-0.176,0.173-0.262,0.262L472.328,120.529z"/><path d="M245.213,373.415c-2.831,0.005-5.548-1.115-7.552-3.115L2.994,135.633c-4.093-4.237-3.975-10.99,0.262-15.083c4.134-3.992,10.687-3.992,14.82,0l227.136,227.115l227.115-227.136c4.093-4.237,10.845-4.354,15.083-0.262c4.237,4.093,4.354,10.845,0.262,15.083c-0.086,0.089-0.173,0.176-0.262,0.262L252.744,370.279C250.748,372.281,248.039,373.408,245.213,373.415z"/><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg></h6>';

			$this->start_accordion_child_wrapper( $output, $depth );

		} else {

			$output .= '<span ' . $class_names . '>';
			$output .= $this->get_anchor_tag( $item, $depth, $args, $id );
			$output .= '</span>';

		}

	} // start_el


	public function end_el( &$output, $item, $depth = 0, $args = array() ) {
	}

	public function start_accordion( &$output, $depth = 0 ) {

		$output .= "<amp-accordion><section>";

		$this->accordion_started = TRUE;
		$this->enqueue_accordion = TRUE;
	}

	public function end_accordion( &$output, $depth = 0 ) {

		$output .= "</section></amp-accordion>";

		$this->accordion_started = FALSE;
	}

	public function start_accordion_child_wrapper( &$output, $depth = 0 ) {

		$output .= "\n<div>\n";

		$this->accordion_childs_started = TRUE;
	}

	public function end_accordion_child_wrapper( &$output, $depth = 0 ) {

		$output .= "</div>\n";

		$this->accordion_childs_started = FALSE;
	}

	public function get_anchor_tag( $item, $depth, $args, $id ) {

		$current_el = '';

		parent::start_el( $current_el, $item, $depth, $args, $id );

		// Unwrap li tag
		if ( preg_match( '#<\s*li\s* [^>]* > (.+) #ix', $current_el, $matched ) ) {
			return $matched[1];
		}

		return $this->make_anchor_tag( $item, $args, $depth );
	}

	protected function make_anchor_tag( $item, $args, $depth ) {

		$atts           = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target ) ? $item->target : '';
		$atts['rel']    = ! empty( $item->xfn ) ? $item->xfn : '';
		$atts['href']   = ! empty( $item->url ) ? $item->url : '';

		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}

		/** This filter is documented in wp-includes/post-template.php */
		$title = apply_filters( 'the_title', $item->title, $item->ID );

		$title = apply_filters( 'nav_menu_item_title', $title, $item, $args, $depth );

		$item_output = $args->before;
		$item_output .= '<a' . $attributes . '>';
		$item_output .= $args->link_before . $title . $args->link_after;
		$item_output .= '</a>';
		$item_output .= $args->after;

		return $item_output;
	}
}