<?php
/**
 * Header bar template part.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */

?>
<header class="amp-wp-header">
	<div class="amp-wp-container">
		<div class="amp-wp-header-left">
			<a href="<?php echo esc_url( $this->get( 'home_url' ) ); ?>"><svg version="1.1" class="arrow-left-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 492 492" style="enable-background:new 0 0 492 492;" xml:space="preserve"><g><g><path d="M464.344,207.418l0.768,0.168H135.888l103.496-103.724c5.068-5.064,7.848-11.924,7.848-19.124c0-7.2-2.78-14.012-7.848-19.088L223.28,49.538c-5.064-5.064-11.812-7.864-19.008-7.864c-7.2,0-13.952,2.78-19.016,7.844L7.844,226.914C2.76,231.998-0.02,238.77,0,245.974c-0.02,7.244,2.76,14.02,7.844,19.096l177.412,177.412c5.064,5.06,11.812,7.844,19.016,7.844c7.196,0,13.944-2.788,19.008-7.844l16.104-16.112c5.068-5.056,7.848-11.808,7.848-19.008c0-7.196-2.78-13.592-7.848-18.652L134.72,284.406h329.992c14.828,0,27.288-12.78,27.288-27.6v-22.788C492,219.198,479.172,207.418,464.344,207.418z"/></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg></a>
		</div>
		
		<a href="<?php echo esc_url( $this->get( 'home_url' ) ); ?>" class="amp-logo-link">
			<?php 
			$logo = (!empty(get_theme_mod('geoit_logo_amp'))) ? get_theme_mod('geoit_logo_amp') : ''; 
			$text = (!empty(get_theme_mod('geoit_logo_text'))) ? get_theme_mod('geoit_logo_text') : ''; 
			if ( $logo ) :  list($width, $height) = getimagesize($logo);?>
        <amp-img width="<?php echo $width; ?>" height="<?php echo $height; ?>" layout="responsive" src="<?php echo $logo; ?>" class="amp-logo"></amp-img>
			<?php else: ?>
        <span class="amp-site-title">
					<?php if($text != ''): ?>
						<?php echo esc_html( $text ); ?>
					<?php else: ?>
						<?php echo esc_html( wptexturize( $this->get( 'blog_name' ) ) ); ?>
					<?php endif; ?>
				</span>
			<?php endif; ?>
    </a>
		
		<div class="amp-wp-header-right">
			<button id="amp-wp-search-btn" type="button" class="amp-wp-search-btn" on="tap:geoit-wp-amp-form.toggleClass(class='active'), amp-wp-search-btn.toggleClass(class='active')">
					<svg version="1.1" class="search-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 192.904 192.904" style="enable-background:new 0 0 192.904 192.904;" xml:space="preserve"><path d="M190.707,180.101l-47.078-47.077c11.702-14.072,18.752-32.142,18.752-51.831C162.381,36.423,125.959,0,81.191,0C36.422,0,0,36.423,0,81.193c0,44.767,36.422,81.187,81.191,81.187c19.688,0,37.759-7.049,51.831-18.751l47.079,47.078c1.464,1.465,3.384,2.197,5.303,2.197c1.919,0,3.839-0.732,5.304-2.197C193.637,187.778,193.637,183.03,190.707,180.101z M15,81.193C15,44.694,44.693,15,81.191,15c36.497,0,66.189,29.694,66.189,66.193c0,36.496-29.692,66.187-66.189,66.187C44.693,147.38,15,117.689,15,81.193z"/><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>
					<svg version="1.1" class="close-icon"  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512.001 512.001" style="enable-background:new 0 0 512.001 512.001;" xml:space="preserve"><g><g><path d="M284.286,256.002L506.143,34.144c7.811-7.811,7.811-20.475,0-28.285c-7.811-7.81-20.475-7.811-28.285,0L256,227.717L34.143,5.859c-7.811-7.811-20.475-7.811-28.285,0c-7.81,7.811-7.811,20.475,0,28.285l221.857,221.857L5.858,477.859c-7.811,7.811-7.811,20.475,0,28.285c3.905,3.905,9.024,5.857,14.143,5.857c5.119,0,10.237-1.952,14.143-5.857L256,284.287l221.857,221.857c3.905,3.905,9.024,5.857,14.143,5.857s10.237-1.952,14.143-5.857c7.811-7.811,7.811-20.475,0-28.285L284.286,256.002z"/></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>
			</button>
			<button type="button" class="hamburger" on="tap:amp-menu.toggle">
				<svg version="1.1" class="menu-icon"  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 341.333 341.333" style="enable-background:new 0 0 341.333 341.333;" xml:space="preserve"><g><g><rect y="277.333" width="341.333" height="42.667"/></g></g><g><g><rect y="149.333" width="341.333" height="42.667"/></g></g><g><g><rect y="21.333" width="341.333" height="42.667"/></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>
			</button>
			
		</div>


		<form id="geoit-wp-amp-form" action="<?php echo home_url( '/' ); ?>">
			<input type="search" placeholder="<?php _e('Aradığınız kelimeyi bu alana girin..', 'geo');?>" name="s">
			<button type="submit" class="amp-wp-search-submit">
				 <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24"><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/><path d="M0 0h24v24H0z" fill="none"/></svg>
			</button>
		</form>
		
	</div>
</header>


<amp-sidebar id="amp-menu" layout="nodisplay" side="right">
	<?php
	if ( has_nav_menu( 'geo-header-amp' ) ) {
		wp_nav_menu( $args = array(
			'menu_class'     => 'amp-wp-navigation',
			'container'      => false,
			'theme_location' => 'geo-header-amp',
			'walker'				 => new Geoit_AMP_Menu_Walker()
		) );
	} else {
		echo '<p style="padding: 1em">Menü oluşturun</p>';
	}
	?>
</amp-sidebar>
<div id="top"  class="header-clone" style="display:block;height:64px;"></div>
<div class="amp-wp-container">
<?php if(! empty( ot_get_option( 'geoit_ad_amp_header' ))): ?>
	<div class="empty-height" style="display:block;height:15px;"></div>
	<?php echo ot_get_option('geoit_ad_amp_header'); ?>
	<div class="empty-height" style="display:block;height:15px;"></div>
<?php endif; ?>