<?php
$cat = wp_get_post_categories( get_the_ID() );

$args_query = array(
	'order'          => 'DESC',
	'post__not_in'   => array( get_the_ID() ),
	'category__in'   => $cat,
	'orderby'        => 'rand',
	'posts_per_page' => 6,
);

$query = new WP_Query( $args_query );

if( $query->have_posts() ) {
	?>
    <div class="amp-wp-section">
        <h4 class="amp-wp-block-title"><?php esc_html_e( 'Benzer Yazılar', 'geo' ); ?></h4>
        <div class="amp-wp-related-posts">
			<?php
			while ( $query->have_posts() ) {
				$query->the_post(); ?>
				<article class="amp-wp-related-post">
					<?php geoit_amp_post_thumbnail(); ?>

						<a href="<?php amp_get_permalink(get_the_ID()); ?>" title="<?php the_title(); ?>" class="amp-wp-related-post-title">
						<?php the_title(); ?>
						</a>
				</article>
			<?php }
			?>
        </div>
    </div>
	<?php
}

wp_reset_postdata();
?>