<?php
/**
 * Single view template.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */

$this->load_parts( [ 'html-start' ] );
?>

<?php $this->load_parts( [ 'header' ] ); ?>

<article class="amp-wp-article">
	<header class="amp-wp-article-header">
		<h1 class="amp-wp-title"><?php echo esc_html( $this->get( 'post_title' ) ); ?></h1>
		<?php $post_desc = get_post_meta(get_the_ID(), 'geo_post_desc', true);
			if($post_desc != '') {
				echo '<p>'.$post_desc.'</p>';
			}  ?>
		<?php $this->load_parts( apply_filters( 'amp_post_article_header_meta', [ 'post-meta' ] ) ); ?>
	</header>
	
	<?php if(ot_get_option('geo-amp-share') != 'off'): ?>
	<div class="amp-wp-article-social-share amp-wp-article-social-share-<?php echo ot_get_option('geo-amp-share'); ?>">
		
		<amp-social-share type="twitter" width="35" height="35"
    data-param-text="<?php echo get_the_title($this->ID) ?>"
    data-param-url="<?php echo get_the_permalink($this->ID); ?>">
		</amp-social-share>
		
		<amp-social-share type="pinterest" width="35" height="35"
    data-param-text="<?php echo get_the_title($this->ID) ?>"
    data-param-href="<?php echo get_the_permalink($this->ID); ?>"
		data-param-media="<?php echo get_the_post_thumbnail_url( 'featured_image' ); ?>">
		</amp-social-share>
		
		<amp-social-share type="whatsapp" width="35" height="35"
    data-param-text="<?php echo get_the_title($this->ID) ?> - <?php echo get_the_permalink($this->ID); ?>">
		</amp-social-share>
		
		<amp-social-share type="linkedin" width="35" height="35"
    data-param-text="<?php echo get_the_title($this->ID) ?>"
    data-param-url="<?php echo get_the_permalink($this->ID); ?>">
		</amp-social-share>
		
		<amp-social-share type="email" width="35" height="35"
    data-param-subject="<?php echo get_the_title($this->ID) ?>">
		</amp-social-share>
	</div>
	<?php endif; ?>
	
	<?php $this->load_parts( [ 'featured-image' ] ); ?>

	<div class="amp-wp-article-content">
	
		<?php if(! empty( ot_get_option( 'geoit_ad_amp_above' ))): ?>
			<div class="empty-height" style="display:block;height:15px;"></div>
			<?php echo ot_get_option( 'geoit_ad_amp_above' ); ?>
			<div class="empty-height" style="display:block;height:15px;"></div>
		<?php endif; ?>
		
		<?php 
		$meta = get_post_meta( $this->ID, 'geoit_private_post', true );
		$author = get_post_field ('post_author', $this->ID);
		$user = get_current_user_id();
		
		if($author == $user) { ?>
			<?php echo $this->get( 'post_amp_content' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		
			<?php geoit_recipe(get_post($this->ID)); ?>
			
			<?php if(get_post_meta( $this->ID, 'geo_enable_review', true ) == 'true' || get_post_meta( $this->ID, 'geo_enable_review', true ) == 'on') : ?>
				<?php if(get_post_meta( $this->ID, 'geo_review_position', true ) == 'bottom') : ?>
					<div class="gp-review-box-bottom">
						<?php geo_print_review_box($this->ID, true );  ?>
					</div>
				<?php endif; ?>
			<?php endif; ?>
		<?php } elseif( $meta != 'on' || get_the_author_meta('verified_user', $user) == 'yes' ) { ?>
			<?php echo $this->get( 'post_amp_content' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		
			<?php geoit_recipe(get_post($this->ID)); ?>
			
			<?php if(get_post_meta( $this->ID, 'geo_enable_review', true ) == 'true' || get_post_meta( $this->ID, 'geo_enable_review', true ) == 'on') : ?>
				<?php if(get_post_meta( $this->ID, 'geo_review_position', true ) == 'bottom') : ?>
					<div class="gp-review-box-bottom">
						<?php geo_print_review_box($this->ID, true );  ?>
					</div>
				<?php endif; ?>
			<?php endif; ?>
		<?php } else {
$out = '...<div class="geo-private-read-more"></div><div class="geo-private-post"><div class="geo-private-post-inner">
	<h2>'. esc_html__( 'Bu yazı onaylı üyelerimiz için hazırlanmıştır.', 'geo' ) .'</h2>';
	if(!is_user_logged_in()) {
	$out .= '<p>'. esc_html__( 'İlgili içeriğin devamını okuyabilmek için onaylı üye olmalı veya zaten onaylı üye iseniz giriş yapmalısınız.', 'geo' ) .'</p>
	<button data-toggle="geoit-login" class="uckan-btn uckan-btn--red">'.esc_html__( 'Giriş Yap', 'geo' ).'</button>';
	if(ot_get_option('geo-onay') != '')
		$out .= '<a href="'.get_page_link(ot_get_option('geo-onay')).'" class="uckan-btn uckan-btn--green">'.esc_html__( 'Onaylı Üyelik Nedir?', 'geo' ).'</a>';
	} else {
		$out .= '<p>'. esc_html__( 'İlgili içeriğin devamını okuyabilmek için onaylı üye olmalısınız.', 'geo' ) .'</p>';
		if(ot_get_option('geo-onay') != '')
		$out .= '<a href="'.get_page_link(ot_get_option('geo-onay')).'" class="uckan-btn uckan-btn--colored">'.esc_html__( 'Onaylı Üyelik Nedir?', 'geo' ).'</a>';
	}
	$out .= '</div></div>';

	echo wp_trim_words( $this->get( 'post_amp_content' ), 40, $out);
		} ?>
		
		
		
		<?php echo get_geo_post_source($this->ID); ?>
		
		<?php if(! empty( ot_get_option( 'geoit_ad_amp_below' ))): ?>
			<div class="empty-height" style="display:block;height:15px;"></div>
			<?php echo ot_get_option('geoit_ad_amp_below'); ?>
			<div class="empty-height" style="display:block;height:15px;"></div>
		<?php endif; ?>

	</div>

	<footer class="amp-wp-article-footer">
		<?php $this->load_parts( apply_filters( 'amp_post_article_footer_meta', [ 'meta-taxonomy', 'meta-comments-link' ] ) ); ?>
	</footer>
	
</article>

<?php if(ot_get_option('geo-amp-post-related') != 'off'): ?>
	<?php $this->load_parts( array( 'related-posts' ) ); ?>
<?php endif; ?>

<?php $this->load_parts( [ 'footer' ] ); ?>

<?php
$this->load_parts( [ 'html-end' ] );
