<?php
/**
 * Style template.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */
 
$customizer = [
	'bg' => (!empty(get_theme_mod('geoit_bg_color'))) ? get_theme_mod('geoit_bg_color') : '#fff',
	'primary' => (!empty(get_theme_mod('geoit_primary_color'))) ? get_theme_mod('geoit_primary_color') : '#e62f2f',
];

$content_max_width       = absint( $this->get( 'content_max_width' ) );
$theme_color             = $customizer['bg'];
$text_color              = '#333';
$muted_text_color        = '#888';
$border_color            = '#ececec';
$primary_color           = $customizer['primary'];
$link_color              = $customizer['primary'];
$header_background_color = $customizer['primary'];
$header_color            = '#fff';

$alignwide_max = $content_max_width > 0 ? $content_max_width * 2 : 1920;

$font = get_theme_mod('geoit_theme_font');
$first_big = ucwords(strtolower($font));
$first_word2 = ucwords(strtolower($first_big), '_');
$bul = '_';
$degistir = '+';
$font_final = str_replace($bul, $degistir, $first_word2);
if ($font_final == '') {
$font_final = 'Poppins';
}

$customizer = [
'single-page-headline-font-size' => (!empty(get_theme_mod('geoit_single_page_headline_fsize'))) ? get_theme_mod('geoit_single_page_headline_fsize') : '',
'single-page-headline-color' => (!empty(get_theme_mod('geoit_single_page_headline_color'))) ? get_theme_mod('geoit_single_page_headline_color') : '',
'single-page-content-font-size' => (!empty(get_theme_mod('geoit_single_page_content_fsize'))) ? get_theme_mod('geoit_single_page_content_fsize') : '',
'single-page-content-link-color' => (!empty(get_theme_mod('geoit_single_page_link_color'))) ? get_theme_mod('geoit_single_page_link_color') : '',
'single-page-content-link-color-visited' => (!empty(get_theme_mod('geoit_single_page_link_color_visited'))) ? get_theme_mod('geoit_single_page_link_color_visited') : '',
'single-page-content-link-color-hover' => (!empty(get_theme_mod('geoit_single_page_link_color_hover'))) ? get_theme_mod('geoit_single_page_link_color_hover') : '',
];

### Single Page Headline Font Size
if (!empty($customizer['single-page-headline-font-size'])) {
	echo '

		.amp-wp-title {font-size: '.$customizer['single-page-headline-font-size'].'px !important; line-height: calc(1.54 * '.$customizer['single-page-headline-font-size'].'px);}
	
	';
}

### Single Page Headline Color
if (!empty($customizer['single-page-headline-color'])) {
	echo '
		.amp-wp-title {color: '.$customizer['single-page-headline-color'].';}
	';
}

### Single Page Content Font Size
if (!empty($customizer['single-page-content-font-size'])) {
	echo '

	.amp-wp-article-content {font-size: '.$customizer['single-page-content-font-size'].'px; line-height: calc(1.54 * '.$customizer['single-page-content-font-size'].'px);}

	';
}

### Single Page Link Colors
if (!empty($customizer['single-page-content-link-color'])) {
	echo '
		.amp-wp-article-content a, .amp-wp-article-content a span {color: '.$customizer['single-page-content-link-color'].';}
	';
}
if (!empty($customizer['single-page-content-link-color-hover'])) {
	echo '
		.amp-wp-article-content a:hover, .amp-wp-article-content a:hover span {color: '.$customizer['single-page-content-link-color-hover'].' !important;}
	';
}
if (!empty($customizer['single-page-content-link-color-visited'])) {
	echo '
		.amp-wp-article-content a:visited, .amp-wp-article-content a:visited span {color: '.$customizer['single-page-content-link-color-visited'].';}
	';
}

?>
/* Generic WP styling */

.alignnone,
.aligncenter,
.alignleft,
.alignright,
.alignwide {
	margin-top: 1em;
	margin-right: auto;
	margin-bottom: 1em;
	margin-left: auto;
}

.alignright {
	float: right;
}

.alignleft {
	float: left;
}

.aligncenter {
	display: block;
	text-align: center;
	margin-left: auto;
	margin-right: auto;
}

.alignwide {
	width: 100%;
}

@media (min-width: calc(840px - 48px)) {
	.alignwide {
		width: calc(100vw - 48px);
		max-width: calc(100vw - 48px);
		margin-left: calc(50% - 50vw + 24px);
		margin-right: calc(50% - 50vw + 24px);
	}
}

@media (min-width: calc(<?php echo sprintf( '%dpx', $alignwide_max ); ?>)) {
	.alignwide {
		width: calc(<?php echo sprintf( '%dpx', $alignwide_max ); ?> - 48px);
		max-width: calc(<?php echo sprintf( '%dpx', $alignwide_max ); ?> - 48px);
		margin-left: calc(calc(50% - <?php echo sprintf( '%dpx', $alignwide_max ); ?> / 2) + 24px);
		margin-right: calc(calc(50% - <?php echo sprintf( '%dpx', $alignwide_max ); ?> / 2) + 24px);
	}
}

.alignfull {
	width: 100vw;
	max-width: 100vw;
	margin-left: calc(50% - 50vw);
	margin-right: calc(50% - 50vw);
}

.amp-wp-enforced-sizes {
	/** Our sizes fallback is 100vw, and we have a padding on the container; the max-width here prevents the element from overflowing. **/
	max-width: 100%;
	margin: 0 auto;
}

<?php echo file_get_contents( AMP__DIR__ . '/assets/css/amp-default.css' ); // phpcs:ignore WordPress.WP.AlternativeFunctions ?>

/* Template Styles */

.amp-wp-content,
.amp-wp-title-bar div {
	<?php if ( $content_max_width > 0 ) : ?>
	margin: 0 auto;
	max-width: <?php echo sprintf( '%dpx', $content_max_width ); ?>;
	<?php endif; ?>
}

body {
	background: <?php echo sanitize_hex_color( $theme_color ); ?>;
	color: <?php echo sanitize_hex_color( $text_color ); ?>;
	font-family: <?php echo $font_final; ?>, sans-serif;
	font-weight: 300;
	line-height: 1.75em;
}

p,
ol,
ul,
figure {
	margin: 0 0 1em;
	padding: 0;
}


/* Quotes */

blockquote {
border-left:7px solid <?php echo sanitize_hex_color( $primary_color ); ?>;
margin:2em 0;
padding:1em 2em!important;
position:relative;
transition:.2s border ease-in-out;
z-index:0
}

blockquote p {
margin:0!important;
font-size:22px!important;
line-height:28px!important
}

blockquote p+p,blockquote .uckan-btn {
margin-top:15px!important
}

/* UI Fonts */

.amp-wp-meta,
.wp-caption-text,
.amp-wp-tax-category,
.amp-wp-tax-tag,
.amp-wp-comments-link,
.amp-wp-footer p,
.amp-wp-article-content p,
.amp-wp-article-content ul,
amp-wp-article-content ol,
.back-to-top,
.menu-item a {
	font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",Arial,sans-serif;
}

/* Header */

.amp-wp-header {
	background-color: <?php echo sanitize_hex_color( $header_background_color ); ?>;
	position: fixed;
	top: 0;
	left: 0;
	right: 0;
  box-shadow: 1px 0px 10px 0 rgba(0,0,0,.5);
	z-index:999;
}

.amp-wp-header div {
color: <?php echo sanitize_hex_color( $header_color ); ?>;
font-size: 1em;
font-weight: 400;
display: flex;
align-items: center;
justify-content: center;
height: 64px;
position: relative;
text-align:center;
}

.amp-wp-header-left {
text-align:right;
position: absolute !important;
left: 15px;
top: 0;
}

.amp-wp-header-right {
text-align:right;
position: absolute !important;
right: 15px;
top: 0;
}

.amp-wp-container {
max-width: 830px;
margin: 0 auto;
padding-left: 15px;
padding-right: 15px;
}

.amp-logo-link {
max-width: 175px;
font-size: 28px;
color:#fff;
text-decoration:none;
max-height: 60px;
-ms-flex: 0 0 100%;
flex: 0 0 100%;
}

.amp-logo {
max-height: 60px;
max-width: 175px;
}


/* Article */

.amp-wp-article {
	color: <?php echo sanitize_hex_color( $text_color ); ?>;
	font-weight: 400;
	margin: 1.5em auto;
	max-width: 840px;
	overflow-wrap: break-word;
	word-wrap: break-word;
}

/* Article Header */

.amp-wp-article-header {
	align-items: center;
	align-content: stretch;
	display: flex;
	flex-wrap: wrap;
	justify-content: space-between;
	margin: 3em 0 1em;
}

.amp-wp-title {
	color: <?php echo sanitize_hex_color( $text_color ); ?>;
	display: block;
	font-size: 28px;
	flex: 1 0 100%;
	font-weight: 700;
	line-height:1.4;
	margin: 0 0 10px;
	width: 100%;
}

/* Article Meta */

.amp-wp-meta {
	color: <?php echo sanitize_hex_color( $muted_text_color ); ?>;
	display: inline-block;
	font-size: .875em;
	line-height: 1.5em;
	margin: 0 0 1.5em;
	padding: 0;
}
.amp-wp-meta:after {
	content: '-';
	display: inline-block;
	margin: 0 15px;
	opacity: .5
}
.amp-wp-meta:last-child:after {
	content: none
}

.amp-wp-article-header .amp-wp-meta:last-of-type {
	text-align: <?php echo is_rtl() ? 'left' : 'right'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>;
}

.amp-wp-article-header .amp-wp-meta:first-of-type {
	text-align: <?php echo is_rtl() ? 'right' : 'left'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>;
}

.amp-wp-byline amp-img,
.amp-wp-byline .amp-wp-author {
	display: inline-block;
	vertical-align: middle;
}

.amp-wp-byline amp-img {
	border: 1px solid <?php echo sanitize_hex_color( $link_color ); ?>;
	border-radius: 50%;
	position: relative;
	margin-<?php echo is_rtl() ? 'left' : 'right'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>: 6px;
}

.amp-wp-posted-on {
	text-align: <?php echo is_rtl() ? 'left' : 'right'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>;
}

/* Featured image */

.amp-wp-article-featured-image {
	margin: 0 0 1em;
}
.amp-wp-article-featured-image amp-img {
	margin: 0 auto;
	width: 100%;
}
.amp-wp-article-featured-image.wp-caption .wp-caption-text {
	margin: 0 18px;
}

/* Article Content */


.amp-wp-article-content ul,
.amp-wp-article-content ol {
	margin-<?php echo is_rtl() ? 'right' : 'left'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>: 1em;
}

.amp-wp-article-content .wp-caption {
	max-width: 100%;
}

.amp-wp-article-content amp-img {
	margin: 0 auto;
}

.amp-wp-article-content amp-img.alignright,
.amp-wp-article-content .wp-block-cover.alignright {
	margin: 0 0 1em 16px;
}

.amp-wp-article-content amp-img.alignleft,
.amp-wp-article-content .wp-block-cover.alignleft {
	margin: 0 16px 1em 0;
}

/* Captions */

.wp-caption {
	padding: 0;
}

.wp-caption.alignleft {
	margin-right: 16px;
}

.wp-caption.alignright {
	margin-left: 16px;
}

.wp-caption .wp-caption-text {
	border-bottom: 1px solid <?php echo sanitize_hex_color( $border_color ); ?>;
	color: <?php echo sanitize_hex_color( $muted_text_color ); ?>;
	font-size: .875em;
	line-height: 1.5em;
	margin: 0;
	padding: .66em 10px .75em;
}

/* AMP Media */

.alignwide,
.alignfull {
	clear: both;
}

amp-carousel {
	background: <?php echo sanitize_hex_color( $border_color ); ?>;
	margin: 0 -16px 1.5em;
}
amp-iframe,
amp-youtube,
amp-instagram,
amp-vine {
	background: <?php echo sanitize_hex_color( $border_color ); ?>;
	margin: 0 -16px 1.5em;
}

.amp-wp-article-content amp-carousel amp-img {
	border: none;
}

amp-carousel > amp-img > img {
	object-fit: contain;
}

.amp-wp-iframe-placeholder {
	background: <?php echo sanitize_hex_color( $border_color ); ?> url( <?php echo esc_url( $this->get( 'placeholder_image_url' ) ); ?> ) no-repeat center 40%;
	background-size: 48px 48px;
	min-height: 48px;
}

/* Article Footer Meta */

.amp-wp-article-footer .amp-wp-meta {
	display: block;
	margin: 0 0 1em
}

.amp-wp-article-footer .amp-wp-meta a, .back-to-top {
font-size: 12px!important;
line-height: 20px;
color:#2d2d2d;
letter-spacing: .05em;
text-transform: uppercase;
text-decoration:none;
padding: 5px 15px;
border-radius: 3px;
border: 1px #d2d6dc solid;
background: transparent;
margin: 5px 6px 5px 0;
white-space: nowrap;
display: inline-block;
transition: all .3s ease;
vertical-align: top;
}
.amp-wp-article-footer .amp-wp-meta a:hover, .back-to-top:hover, .view-full-version {
color: <?php echo $primary_color; ?>;
border-color: <?php echo $primary_color; ?>;
}
.amp-wp-article-footer .amp-wp-meta:after {
	content: none;
}

.amp-wp-comments-link a {
padding-top: 15px !important;
color: #fff !important;
border-color: <?php echo $primary_color; ?> !important;
background: <?php echo $primary_color; ?> !important;
padding-bottom: 15px !important;
padding-right: 5em !important;
padding-left: 5em !important;
}

.amp-wp-comments-link a:hover {
color:<?php echo $primary_color; ?> !important;
background:transparent !important;
}

/* AMP Footer */

.amp-wp-footer {
	border-top: 1px solid <?php echo sanitize_hex_color( $border_color ); ?>;
	width: 100%;
	
}

.amp-wp-footer>div {
	margin: 0 auto;
	width: 100%;
	padding: 2em 0;
	position: relative;
		display: -webkit-box;
	display: -ms-flexbox;
	display: flex;
	-webkit-box-align:center;
	-ms-flex-align:center;
	        align-items:center;
	-webkit-box-pack:justify;
	-ms-flex-pack:justify;
	        justify-content:space-between;
}

.amp-wp-footer h2 {
    font-size: 1.75em;
    font-weight: 600;
    line-height: 1.375em;
    margin: 0;
}

.amp-wp-footer p {
	color: <?php echo sanitize_hex_color( $muted_text_color ); ?>;
	line-height: 1.5em;
	margin: 0 85px 0 0;
}

.amp-wp-footer a {
	text-decoration: none;
}


.amp-wp-header svg {
fill:#fff;
vertical-align:middle;
cursor:pointer;
width: 24px;
height:24px;
}
.amp-wp-header button {
background:transparent;
border:0;
margin-left: 10px;
}
#geoit-wp-amp-form {
position: absolute;
z-index: -1;
margin: 0;
top: 100%;
right: 15px;
width: 325px;
visibility: hidden;
opacity: 0;
background:#333;
padding: 1em;
transition: all .3s ease;
}
#geoit-wp-amp-form.active {
opacity: 1;
visibility: visible;
z-index:1;
}
#geoit-wp-amp-form input {
width: 100%;
height: 40px;
line-height: 40px;
position:relative;
border: 0;
display: block;
background:#fff;
padding: 15px;
margin: 0;
}
.amp-wp-search-submit {
position: absolute;
margin:0 !important;
padding:0 !important;
top:24px;
right: 25px;
}
.amp-wp-search-submit svg>path:first-child {
fill:#000
}
#amp-wp-search-btn.active svg.search-icon, #amp-wp-search-btn svg.close-icon {
display: none;
}
#amp-wp-search-btn.active svg.close-icon {
display: block
}
amp-social-share {
border-radius: 100%;
margin-right: 15px;
margin-bottom: 2em;
margin-top:-1em;
background-size:24px!important
}
.amp-wp-article-social-share-default amp-social-share{
-ms-flex-preferred-size: 0;
display: block;
padding: 8px 10px;
flex-basis: 0;
border-radius: 4px;
-webkit-box-flex: 1;
-ms-flex-positive: 1;
flex-grow: 1;
list-style: none!important;
margin: -1em 5px 2em;
text-align: center;
}
.amp-wp-article-social-share-default {
display: -webkit-box!important;
margin-left: -5px;
margin-right: -5px;
display: -ms-flexbox!important;
display: flex!important;
}
.amp-wp-article-social-share-style-3 amp-social-share{
border-radius: 4px
}
.amp-wp-post-meta {
display: flex;
align-items:center;
width: 100%
}
amp-img.amp-wp-enforced-sizes[layout="intrinsic"] > img {
	object-fit:cover
}

.uckan-card {
width: 100%;
border-radius: 3px;
box-sizing: border-box;
display: inline-block;
border: 1px solid #d2d6dc;
padding: 2em;
margin: 1em 0;
position: relative;
}

.uckan-card--url {
position:absolute;
width:100%;
height:100%;
left:0;
bottom:0;
top:0;
cursor:pointer;
z-index:2
}

.uckan-card--left {
float:left;
margin-right:20px
}

.uckan-card--right>.type {
font-size:12px!important;
line-height:20px;
letter-spacing:.05em;
text-transform:uppercase;
padding:5px 15px;
border-radius:3px;
border:1px #d2d6dc solid;
background:transparent;
margin:5px 6px 5px 0;
white-space:nowrap;
display:inline-block;
vertical-align:top;
transition:all .3s ease
}

.uckan-card:hover .type {
border-color:<?php echo $primary_color; ?>;
background:<?php echo $primary_color; ?>;
color:#fff
}

.uckan-card--right>.headline {
margin:5px 0 0;
line-height:25px;
font-size:15px;
font-weight:600
}

.uckan-card button {
display:none
}

.geo_highlight {
padding:0 2px;
background-color:#FFEB3B
}

.geo_dropcap {
display:block;
float:left;
font-size:32px;
width:50px;
height:50px;
line-height:50px;
margin:5px 10px 0 0;
text-align:center
}

.geo_dropcap.geo_dropcap-letter {
margin:0 10px 0 0
}

.geo_dropcap.geo_dropcap-circle {
background-color:<?php echo $primary_color; ?>;
color:#fff;
border-radius:100%
}

.geo_dropcap.geo_dropcap-square {
background-color:<?php echo $primary_color; ?>;
color:#fff;
border-radius:0
}


.uckan-btn {
background:#fff;
border:none;
margin-bottom: 15px;
border-radius:3px;
color:rgba(0,0,0,.9);
position:relative;
height:50px;
min-width:64px;
padding:0 30px;
display:inline-block;
font-size:12px;
letter-spacing:.05em;
text-transform:uppercase;
font-weight:600;
font-family:'Poppins',sans-serif;
will-change:box-shadow;
transition:box-shadow .2s cubic-bezier(.4,0,1,1),background-color .2s cubic-bezier(.4,0,.2,1),color .2s cubic-bezier(.4,0,.2,1);
outline:none;
cursor:pointer;
text-decoration:none;
text-align:center;
line-height:50px;
-webkit-box-shadow:0 0 3px rgba(0,0,0,.1);
box-shadow:0 0 3px rgba(0,0,0,.1);
background:rgba(255,255,255,1);
vertical-align:middle;
text-decoration:none!important
}

.uckan-btn.colored {
background-color:<?php echo $primary_color; ?>;
color:#fff
}

.uckan-btn--icon {
border-radius:50%;
font-size:24px;
box-shadow:none;
background-color:transparent;
height:32px;
margin-left:0;
margin-right:0;
position:relative;
min-width:32px;
width:32px;
padding:0;
overflow:hidden;
color:inherit;
line-height:normal
}

.uckan-btn--icon i {
position:absolute;
top:50%;
left:50%;
-ms-transform:translate(-12px,-12px);
-webkit-transform:translate(-12px,-12px);
transform:translate(-12px,-12px);
line-height:24px;
width:24px
}

.uckan-btn--middle {
height:40px;
line-height:40px;
padding:0 20px;
}

.uckan-btn--small {
height:35px;
padding:0 10px;
line-height:35px
}

.uckan-btn--fab {
height:40px;
min-width:40px;
width:40px;
border-radius:50%;
cursor:pointer;
font-size:15px;
margin:auto;
padding:0;
overflow:hidden;
background:rgba(255,255,255,1);
box-shadow:0 1px 1.5px 0 rgba(0,0,0,.12);
position:relative;
line-height:normal
}

.uckan-btn--fab i {
position:absolute;
top:50%;
left:50%;
-webkit-transform:translate(-12px,-12px);
transform:translate(-12px,-12px);
line-height:26px;
width:24px
}

.uckan-btn--fab.colored i {
color:#fff
}

.uckan-btn--red {
background-color:#F44336;
color:#fff!important
}

.uckan-btn--green {
background-color:#4CAF50;
color:#fff!important
}

.uckan-btn--blue {
background-color:#2196F3;
color:#fff!important
}

.uckan-btn--block {
display:block;
}

.uckan-btn--rounded {
border-radius:25px
}


.geoit-alert {
position:relative;
margin:15px 0
}

.geoit-alert p:last-child {
margin-bottom:0
}

.geo-alert-style-1 {
padding:2rem;
border:1px solid transparent;
border-radius:.25rem;
color:#0c5460;
background-color:#d1ecf1;
border-color:#bee5eb
}

.geo-alert-style-1.geo-alert-color-primary {
color:#fff;
background-color:<?php echo $primary_color; ?>;
border-color:<?php echo $primary_color; ?>
}

.geo-alert-style-1.geo-alert-color-primary p {
color:rgba(255,255,255,.75)
}

.geo-alert-style-1.geo-alert-color-success {
color:#155724;
background-color:#d4edda;
border-color:#c3e6cb
}

.geo-alert-style-1.geo-alert-color-danger {
color:#721c24;
background-color:#f8d7da;
border-color:#f5c6cb
}

.geo-alert-style-1.geo-alert-color-warning {
color:#856404;
background-color:#fff3cd;
border-color:#ffeeba
}

.geo-alert-style-1.geo-alert-color-dark {
color:#1b1e21;
background-color:#d6d8d9;
border-color:#c6c8ca
}

.geo-alert-style-2 {
padding:2rem;
border:1px solid #ececec;
border-radius:0px;
border-left-width:15px;
border-left-color:<?php echo $primary_color; ?>
}

.geo-alert-style-2.geo-alert-color-info {
border-left-color:#d1ecf1
}

.geo-alert-style-2.geo-alert-color-success {
border-left-color:#4caf50
}

.geo-alert-style-2.geo-alert-color-danger {
border-left-color:red
}

.geo-alert-style-2.geo-alert-color-warning {
border-left-color:#ffbe00
}

.geo-alert-style-2.geo-alert-color-dark {
border-left-color:#0a0a0a
}



.uck-accordion {
margin:auto;
width:100%
}

.uck-accordion--box {
position:relative;
background:#fff;
border:1px solid #ececec;
margin:-1px 0 0;
transition:all .15s ease-in-out
}

.uck-accordion--box.collapsible-active {
height:auto;
margin:16px 0;
border-radius:2px
}

.uck-accordion--content {

-webkit-transition:height 1s;
-moz-transition:height 1s;
-ms-transition:height 1s;
-o-transition:height 1s;
transition:height 1s;
width:calc(100% - 40px);
padding:30px 20px;
font-size:11pt;
color:rgba(0,0,0,.54)
}

.collapsible-active .uck-accordion--content {
display:block;
height:auto
}

.uck-accordion--title {
width:100%;
padding:1em;
position:relative;
display:inline-block;
cursor:pointer;
-webkit-touch-callout:none;
-webkit-user-select:none;
-khtml-user-select:none;
-moz-user-select:none;
-ms-user-select:none;
user-select:none
}

.uck-accordion--toggle {
padding-left:2em;
font-weight:600
}

.uck-accordion--box.collapsible-active .uck-accordion--title:before {
-ms-transform:rotate(90deg);
-webkit-transform:rotate(90deg);
transform:rotate(90deg);
top:8px
}

.uck-accordion--box.collapsible-active .uck-accordion--title {
border-bottom:1px solid #ececec
}

.uck-accordion--title:before {
position:absolute;
display:block;
content:'\203a';
font-size:18pt;
left:20px;
top:14px;
transition:transform .15s ease-in-out;
color:<?php echo $primary_color; ?>
}

.geo-review-badge {
position:absolute;
top:0;
left:0;
z-index:2;
text-align:right;
padding:0 1em;
width:40px!important;
transition:all .3s ease;
font-size:12px;
background:<?php echo $primary_color; ?>;
color:#fff
}
hr {
border-color:#ececec;
border-top:0;
margin:1em 0;
display:inline-block;
width:100%
}
.geoit-sc-headline,.geoit-sc-headline>span {
display:-webkit-box;display:-ms-flexbox;display:flex;
-ms-flex-wrap:wrap;flex-wrap:wrap;
-webkit-box-align:center;-ms-flex-align:center;align-items:center;
text-transform:capitalize
}

.geoit-sc-headline span.round {
border-radius:100%;
margin-right:15px;
background-color:<?php echo $primary_color; ?>;
color:#fff;
border-radius:3px;
font-weight:500;
font-size:18px;
display:inline-block;
text-align:center;
overflow:hidden;
padding:2px 15px
}

.geoit-sc-headline span.bordered:not(:hover) {
background:transparent!important;
color:<?php echo $primary_color; ?>
}

.geoit-sc-headline span.bordered {
line-height:45px;
border:1px solid <?php echo $primary_color; ?>
}

.amp-wp-related-posts {
display: flex;
flex-wrap: wrap;
margin: 0 -15px;
}
.amp-wp-related-post {
flex: 0 0 100%;
width: calc(33.3333% - 30px);
margin-bottom: 15px;
margin: 0 15px 15px;
max-width: calc(33.3333% - 30px);
}
.amp-wp-related-post .amp-wp-related-post-title {
color: <?php echo $text_color; ?>;
text-decoration: none;
font-weight: 600;
display: block;
font-size: 15px;
margin-top: 15px;
}
.amp-wp-related-post .amp-wp-related-post-title:hover {
color: <?php echo $primary_color; ?>;
}
.amp-wp-block-title {
padding-left: 30px;
margin-bottom:20px;
border-left: 5px solid <?php echo $primary_color; ?>
}
.amp-wp-full-version-link {
	margin: 1em auto 2em;
}
@media (max-width:992px) {
.amp-wp-related-post {
width: calc(50% - 30px);
max-width: calc(50% - 30px);
}
}
@media (max-width:600px) {
.amp-wp-related-posts {
margin-left:0;
margin-right: 0;
}
.amp-wp-related-post {
width: 100%;
margin-left:0;
margin-right: 0;
max-width: 100%
}
}


.geoit-recipe-header {
text-align:center
}

.geoit-recipe {
border:1px solid <?php echo $primary_color; ?>;
margin:20px 0;
border-radius:4px
}

.geoit-recipe-wrapper {
padding:30px
}

.recipe-title {
background:<?php echo $primary_color; ?>
color:#fff;
text-align:center;
margin:0!important;
padding:20px
}

.recipe-main-meta {
padding:20px 0;
margin:20px 0;
display:flex;
display:-ms-flex;
display:-webkit-flex
}

.recipe-meta-inline {
display:-webkit-box;display:-ms-flexbox;display:flex;
-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;
padding:0 10px;
-webkit-box-flex:1;-ms-flex:1 1 auto;flex:1 1 auto;
border-left:1px solid rgba(0,0,0,.1);
-webkit-box-align:center;-ms-flex-align:center;align-items:center
}

.recipe-meta-inline:first-child {
border:0
}

.recipe-meta-label {
display:block;
font-size:18px;
font-weight:700
}

.recipe-meta-unit {
margin-top:5px;
font-size:22px;
display:block
}

.geoit-nutritions-table {
border-radius:3px 3px 0 0;
border:1px solid <?php echo $primary_color; ?>
}

.geoit-nutritions-title {
padding:15px;
text-align:left;
margin:0;
background-color:<?php echo $primary_color; ?>
}

.geoit-nutrition-item {
display:-webkit-box;display:-ms-flexbox;display:flex;
-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;
padding:0 10px;
-webkit-box-flex:1;-ms-flex:1 1 auto;flex:1 1 auto;
border-left:1px solid rgba(0,0,0,.1);
-webkit-box-align:center;-ms-flex-align:center;align-items:centerr
}

.geoit-nutrition-item:first-child {
border-left:0
}

.geoit-nutrition-table-inner {
display:-webkit-box;display:-ms-flexbox;display:flex;
-webkit-box-flex:0;
-ms-flex:0 0 80%;
flex:0 0 80%;
-webkit-box-pack:justify;
-ms-flex-pack:justify;
justify-content:space-between
}

.geoit-nutritions-title {
margin:0!important;
font-weight:600!important;
text-align:center;
color:#fff;
font-size:18px!important
}

.nutrition-item-label {
font-weight:700;
}

.geoit-ingredients-header {
margin:35px 0 15px!important
}

.geoit-ingredients-items {
margin:0!important
}

.geoit-ingredients-item:before {
content:'\e804';
width:22px;
height:22px;
font-size:10px;
margin-right:15px;
vertical-align:2px;
line-height:22px;
text-align:center;
background:<?php echo $primary_color; ?>;
color:#fff;
border-radius:100%;
font-family:'geoit-font';
display:inline-block
}

.geoit-ingredients-item {
list-style:none!important
}

.geoit-recipe-instructions {
margin-top:35px;
padding-top:35px;
border-top:1px solid rgba(0,0,0,.1)
}

.geoit-recipe-instructions-item:not(:last-child) {
margin-bottom:35px
}

.geoit-recipe-instructions-counter {
width:42px;
height:42px;
margin-bottom:20px;
font-size:15px;
float:left;
margin-right:15px;
vertical-align:2px;
line-height:42px;
text-align:center;
background:<?php echo $primary_color; ?>;
color:#fff;
border-radius:100%
}

.geoit_comment_detail {
width:100%;
overflow:hidden
}

@media (max-width:992px) {
.nutrition-item-label,.recipe-meta-label {
font-size:14px
}

.nutrition-item-value,.recipe-meta-unit {
font-size:16px
}

.geoit-nutritions-table {
-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column
}

.geoit-nutritions-title {
-webkit-box-flex:0;-ms-flex:0 0 100%;flex:0 0 100%;
width:100%
}

.geoit-nutrition-table-inner {
padding:20px
}
}

#amp-menu {
width: 300px;
background-color: #fff;
}
#amp-menu .menu-item a {
display: block;
color: #222;
border-bottom: 1px solid <?php echo $border_color; ?>;
text-decoration: none !important;
padding: 1em 2em;
font-size: 16px;
font-weight: 600;
width: 100%;
transition: all .3s ease;
}
#amp-menu .menu-item a:hover {
background: <?php echo $primary_color; ?>;
color: #fff;
border-color: <?php echo $primary_color; ?>
}
amp-accordion h6 {
background: transparent !important;
border:0 !important;
padding: 0 !important;
}
amp-accordion h6>svg {
position: absolute;
width: 16px;
height: 16px;
z-index: 2;
right: 20px;
top: 20px;
}


#toc_container {
border:1px solid <?php echo $border_color; ?>;
background:#fff;
width:100%!important;
margin:1em 0!important;
padding:0
}

#toc_container .toc_title {
padding:10px 10px 10px 1em!important;
margin:0;
font-weight:600;
font-size:22px;
}

#toc_container ul {
margin:0!important
}

#toc_container li {
list-style: none
}
#toc_container li a {
display:block;
text-decoration: none;
color:<?php echo $text_color; ?>!important;
padding:10px 1em;
border-top:1px solid <?php echo $border_color; ?>
}

#toc_container li:nth-child(2n) a {
background:#f9f9f9
}

#toc_container li a:hover {
background:#fdfdfd;
text-decoration:none
}

#toc_container li a span {
min-width:25px;
height:25px;
padding:0 5px;
display:inline-block;
background:#fff;
border:1px solid #eee;
line-height:25px;
text-align:center;
border-radius:25px;
font-size:12px;
margin-right:10px
}

.review-box-image  {
background-color: #ccc;
background-size: cover;
background-position: center center;
height: 350px;
}

.geo-review-badge {
position:absolute;
top:0;
left:0;
z-index:2;
text-align:right;
padding:0 1em;
/* width:40px!important; */
transition:all .3s ease;
font-size:12px;
background:<?php echo $primary_color; ?>;
color:#fff
}

.geo-review-badge span {
position:relative;
z-index:2
}

.geo-review-box-top {
margin:35px 0 30px
}

.geo-review-box-bottom {
margin:-5px 0 30px
}

#review-box {
border:1px solid #ececec;
margin:0 0 1em;
position:relative;
}

#review-box ul {
margin:0;
padding:2em;
list-style:none
}

#review-box ul li {
margin-bottom:15px;
list-style:none
}

#review-box ul li:last-child {
margin: 0
}

#review-box .overall-score {
background: <?php echo $primary_color; ?>;
float: right;
border-radius: 100%;
font-family: 'Poppins', sans-serif;
border: 5px solid #fff;
line-height: 90px;
width: 100px;
height: 100px;
color: #fff;
margin-left: 40px;
text-align: center;
font-size: 32px;
font-weight: 600;
}

#review-box .review-box-image + .review-top .overall-score {
position: absolute;
top: 300px;
right: 40px;
}

#review-box .review-top {
padding: 2em;
border-bottom:1px solid #ececec
}

#review-box .review-top .review-text .review-title {
font-size:22px;
font-weight:600;
font-family: 'Poppins', sans-serif;
line-height:1;
display:block;
margin:8px 0 30px
}

#review-box .review-top .review-text p {
margin-bottom:0;
font-size: 15px;
}

#review-box ul li .review-criteria-bar-container {
position:relative;
background:rgba(0,0,0,.25);
border-radius: 25px;
height:8px;
margin-top: 10px;
overflow:hidden
}

#review-box ul li .review-criteria-bar {
float:left;
height:8px;
border-radius: 25px;
background:<?php echo $primary_color; ?>;
padding:0 1em;
}

#review-box ul li .legeo {
font-weight:600;
font-family: 'Poppins', sans-serif;
}

#review-box ul li span.right {
font-weight:500;
font-family: 'Poppins', sans-serif;
z-index:99;
float: right;
}

code {
padding:3px 10px;
font-size:90%;
color:#c7254e;
background-color:#eee;
border-radius:4px
}
code,kbd,pre,samp {
font-family:Menlo,Monaco,Consolas,"Courier New",monospace
}
pre code {
padding:0;
font-size:inherit;
color:inherit;
white-space:pre-wrap;
background-color:transparent;
border-radius:0
}
pre {
display:block;
overflow:auto;
padding:10px;
margin:0 0 20px;
font-size:13px;
line-height:1.42857143;
color:#333;
word-break:break-all;
-ms-word-wrap: break-word;
word-wrap: break-word;
background-color:#f5f5f5;
border:1px solid #ccc;
border-radius:4px
}
table {
border-width:1px;
width:100%;
margin:20px 0;
border-spacing:0;
overflow-x:auto;
display:inline-block;
border-color:#EAEAEA;
border-collapse:collapse;
background-color:#fff
}
table tbody {
display:inline-table;
width:100%
}
table th {
border-width:1px;
padding:1em;
border-style:inset;
vertical-align:middle;
font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif;
font-weight:600;
text-align:left;
float:none;
border-color:#EAEAEA;
background-color:#fff
}
table th[scope=row],table tr th {
background-color:#F5F5F5
}
table td {
border-width:1px;
padding:1em;
border-style:inset;
vertical-align:middle;
font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif;
border-color:#EAEAEA
}
.dark-mode table th[scope=row],.dark-mode table tr th {
background:#313131
}
.dark-mode table td,.dark-mode table th[scope=row],.dark-mode table tr th {
border-color:#5e5e5e
}
.wp-block-table td,.wp-block-table th {
border-color:#EAEAEA;
word-break:unset!important
}
@media screen and (max-width: 750px) {
table th,table td {
font-size:12px!important;
padding:6px!important
}
}
@media screen and (max-width: 550px) {
table th,table td {
font-size:10px!important;
padding:4px!important
}
}
iframe,object,embed {
max-width:100%
}
.wp-block-cover{
margin: 20px 0;
}
.wp-block-code {
margin: 20px 0;
overflow: auto;
}
.amp-wp-article-content h1, .amp-wp-article-content h2, .amp-wp-article-content h3, .amp-wp-article-content h4, .amp-wp-article-content h5, .amp-wp-article-content h6 {
margin-bottom: 20px 0
}
.geo-private-post {
text-align: center;
border-radius: 15px;
margin: 15px 0;
background: #f7f7f7;
position: relative;
}
.geo-private-post .uckan-btn {
margin: 0 15px 0
}
.geo-private-post-inner {
max-width: 425px;
margin: 0 auto;
position: relative;
z-index: 2;
padding: 70px 0;
}
.geo-private-post:before {
content: '';
position: absolute;
top: -110px;
background: linear-gradient(to bottom,rgba(255,255,255,0),rgba(255,255,255,1));
height: 100px;
left: 0;
right: 0;
}
.geoit_entry-content .post-views{
display: none;
}
.geo-private-post-inner .ad {
display:none;
}