<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
		
if( ! function_exists( 'Mobile_Detect' )){
	function geo_is_mobile() {
		require_once( __DIR__ . '/Mobile_Detect.php' );
		$detect = new Mobile_Detect;
		if( $detect->isMobile() ) {
			return true;
		} else {
			return false;
		}
	}
}

if( ! function_exists( 'Mobile_Detect' )){
	function geo_is_tablet() {
		require_once( __DIR__ . '/Mobile_Detect.php' );
		$detect = new Mobile_Detect;
		if( $detect->isTablet() ) {
			return true;
		} else {
			return false;
		}
	}
}

// Mobil Menu
add_action('geoit_footer', 'geoit_mobil_menu', 30);
function geoit_mobil_menu() {
	$current_user = wp_get_current_user();
	$dark_theme = ot_get_option('dark_theme');
	$darktheme = ot_get_option('header_dark_mode');
	$whatx = ot_get_option('header_top_login');
  echo '<div id="geo_mobil_menu" style="display:none">';
	
		echo '<div class="geo_mobil_menu_header">';
			if ( is_user_logged_in() ) {
				echo '<a href="'.get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ).'" >'.get_avatar(get_the_author_meta('ID', $current_user->ID),48).' <span>'.$current_user->display_name.'</span></a>';
				if ( $dark_theme != 'on' && $darktheme != 'off' ) {
					echo '<div class="geoit_dark_button"><div class="geo-switch-button Off"><div class="geo-switch"></div></div></div>';
				}
				echo '<button data-toggle="geo_mobil_menu" id="mobile-menu-icon" class="geo_mobile_menu_close" aria-label="Menu Close">'.__('Geri Dön', 'geo').'</button>';
			} else {
				if ( $whatx != 'off' ) {
					echo '<button class="geo_mobil_log" data-toggle="geoit-login">'.__('Giriş Yap', 'geo').'</button>';
				}
				if ( $dark_theme != 'on' && $darktheme != 'off' ) {
					echo '<div class="geoit_dark_button"><div class="geo-switch-button Off"><div class="geo-switch"></div></div></div>';
				}
				echo '<button data-toggle="geo_mobil_menu" id="mobile-menu-icon" class="geo_mobile_menu_close" aria-label="Menu Close">'.__('Geri Dön', 'geo').'</button>';
			}
		echo '</div>';
		
		echo '<div class="geo_mobil_menu_nav">';
			geo_mobil_menu();
		echo '</div>';
		echo '<div class="geo_mobil_menu_footer">';
			get_search_form();
		echo '</div>';
	echo '</div>';
}

if( ! function_exists( 'geo_mobil_menu' )){
	function geo_mobil_menu() { 
		if ( has_nav_menu( 'geo-mobil' ) ) {
			$defaults = array(
			 'theme_location'  => 'geo-mobil',
			 'menu'            => '',
			 'container'       => false,
			 'container_class' => '',
			 'container_id'    => '',
			 'menu_class'      => 'menu-mobil',
			 'menu_id'         => '',
			 'echo'            => true,
			 'fallback_cb'     => 'wp_page_menu',
			 'before'          => '',
			 'after'           => '',
			 'link_before'     => '',
			 'link_after'      => '',
			 'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
			 'depth'           => 0,
			 'walker'          => ''
			);
			wp_nav_menu( $defaults );
		}else {
			$defaults = array(
			 'theme_location'  => 'geo-header',
			 'menu'            => '',
			 'container'       => false,
			 'container_class' => '',
			 'container_id'    => '',
			 'menu_class'      => 'menu-mobil',
			 'menu_id'         => '',
			 'echo'            => true,
			 'fallback_cb'     => 'wp_page_menu',
			 'before'          => '',
			 'after'           => '',
			 'link_before'     => '',
			 'link_after'      => '',
			 'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
			 'depth'           => 0,
			 'walker'          => ''
			);
			wp_nav_menu( $defaults );
		}
	} 
}

if( ! function_exists( 'geo_mobil_login' )){
	function geo_mobil_login() {
		$whatx = ot_get_option('header_top_login');
		if ( $whatx != 'off' ) {
			if ( is_user_logged_in() ) {
				$current_user = wp_get_current_user();
				$fav_page_url = ot_get_option('geo-favorites');
				$posting_url = ot_get_option('geo-posting');
				$settings_url = ot_get_option('geo_profile');
				$logout = wp_logout_url( home_url() );
				echo '<div class="has-login-area mobil_login_button">';
				echo '<button data-toggle="geoit_login" class="uckan_login-button" aria-label="Login"><i class="fa fa-user"></i></button>';
				echo '<div id="geoit_login" class="dropdown-content has_login">';
				echo '<ul>';

				if ( current_user_can('administrator') ) {
					echo '<li><a href="'.site_url().'/wp-admin">'.__('Admin Panel', 'geo').'</a></li>';
				}
				echo '<li><a href="'.get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ).'">'.__('Profilim', 'geo').'</a></li>';
				if ($settings_url != '') {
					echo '<li><a href="'.get_page_link($settings_url).'">'.__('Profilimi Düzenle', 'geo').'</a></li>';
				}
				else {
					echo '<li><a href="'.get_edit_user_link().'">'.__('Profilimi Düzenle', 'geo').'</a></li>';
				}
				if ($fav_page_url != '') {
					echo '<li><a href="'.get_page_link($fav_page_url).'">'.__('Favorilerim', 'geo').'</a></li>';
				}
				if ($posting_url != '') {
					echo '<li><a href="'.get_page_link($posting_url).'">'.__('Yazı Gönder', 'geo').'</a></li>';
				}
				$dark_theme = ot_get_option('dark_theme');
				$darktheme = ot_get_option('header_dark_mode');
				if ($dark_theme != 'on' && $darktheme != 'off' ) {
					echo '<div class="geoit_dark_button"><i class="fa fa-flash"></i> <div class="geo-switch-button Off"><div class="geo-switch"></div></div></div>';
				}
				echo '<li><a href="'.$logout.'">'.__('Çıkış Yap', 'geo').'</a></li>';
				echo '</ul>';
				echo '</div>';
				echo '</div>';
			}
		}
	}
}