<?php
/*
Author: Tiguan
Author URI:  http://tiguandesign.com/
*/

class Geo_Viral_React {

	function __construct() {
		add_action('wp_link_pages', array($this,'addContent'));

		add_action( 'wp_ajax_geo_react', array($this,'react'));
		add_action( 'wp_ajax_nopriv_geo_react', array($this,'react' ));

		add_shortcode( 'geo_reactions', array($this, 'shortCode') );
	}

	function shortCode() {
		// return $this->renderPlugin();
		return '';
	}

	function addContent($content) {

		$show_on_every_post = ot_get_option('geo_react_status');
		$post_id = get_the_ID();
		$enabled = get_post_meta( $post_id, 'geo_reaction_enable', true );

		if (!is_page() && $enabled!="off") {
			if ($show_on_every_post=='on') {
				$plugin = $this->renderPlugin();
				$content .= $plugin;
			}
		}

		return $content;
	}
	
	function react_img($img, $size, $slug) {
		$out = '';
		$emoji = (!empty($img))? $img: get_template_directory_uri().'/assets/img/alkis.png';
		if(ot_get_option('geoit_lazy_images') == 'on') {
			$out = 'class="animated geo-lazy" alt="'.$slug.'" data-src="'.$emoji.'" src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" width="'.$size.'" height="'.$size.'"';
		} else {
			$out = 'class="animated" alt="'.$slug.'" src="'.$emoji.'" width="'.$size.'" height="'.$size.'"';
		}
		return $out;
	}
	
	function renderPlugin() {
		$post_id = get_the_ID();
		$post_url = get_permalink($post_id);
		ob_start() ?>
			<div id="geo_viral_reactions">
				<?php if (empty($slug)){$slug = '';} if(!empty(ot_get_option('geo_post_emoji_title'))): ?><div class="geo-reaction-title"><?php echo ot_get_option('geo_post_emoji_title'); ?></div><?php endif; ?>
			    <ul data-post-id="<?php echo $post_id ?>" <?php echo $this->getReactStatus($slug, $post_id); ?>>
					<?php $reaction = ot_get_option('geoit_create_reaction_emoji'); if($reaction): ?>
						<?php $i=0;foreach($reaction as $emoji): $i++; $slug = (!empty($emoji['title']) ? strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '_', $emoji['title']))): 'emoji-'.$i); $label = (!empty($emoji['title']) ? $emoji['title']: 'Emoji'); ?>
							<li class="animated" data-reaction="<?php echo $slug; ?>" <?php echo $this->getClass($slug, $post_id); ?> ><a href="javascript:void(0)"><img <?php echo $this->react_img($emoji['emoji'], 40, $slug); ?> /><em><?php echo $label ?></em><span><?php echo $this->getAmount($slug,$post_id) ?></span></a></li>
						<?php endforeach; ?>
					<?php endif; ?>
			    </ul>

			    <div style="clear: both;"></div>
			 </div>

		<?php
		$plugin = ob_get_contents();
		ob_clean();
		return $plugin;
	}

	function getClass($reaction, $post_id) {
		$out = '';
		if (isset($_COOKIE["geo_reacted_".$reaction."_".$post_id])) {
			$out = 'data-reacted="yes"';
		} else {
			$out = 'data-reacted="no"';
		}
		return $out;
	}
	
	function getReactStatus($reaction, $post_id) {
		$out = '';
		$_COOKIE["geo_reacted_".$post_id] = !empty($_COOKIE["geo_reacted_".$post_id]) ? $_COOKIE["geo_reacted_".$post_id] : '';
		if ($_COOKIE["geo_reacted_".$post_id] == 1){
			$out = 'data-reacted="yes"';
		}
		return $out;
	}
	

	function getAmount($reaction, $post_id) {
		$meta_key = "geo_reaction_".$reaction;
		$amount = get_post_meta($post_id, $meta_key, true) ? get_post_meta($post_id, $meta_key, true) : 0;
		return $amount;
	}

	function react() {
		if (isset($_POST["postid"])) {
			$post_id = $_POST["postid"];
			$reaction = $_POST["reaction"];
			$unreact = $_POST["unreact"];
		}
	 	$amount = $this->getAmount($reaction, $post_id);
		if (isset($unreact) && $unreact === "true") {
			// unset($_COOKIE['geo_reacted_'.$post_id]);
			// unset($_COOKIE['geo_reacted_'.$reaction.'_'.$post_id]);
	    	// setcookie('geo_reacted_'.$reaction.'_'.$post_id, '', time() - 3600, "/");
			// $amount = (int) $amount - 1;
			// if ($amount >=0) {
				// echo "Amount: ".$amount." ";
				// update_post_meta($post_id, "geo_reaction_".$reaction, $amount);
			// }
		}
		else {
			setcookie('geo_reacted_'.$post_id, true, time() + (86400 * 30), "/");
			setcookie('geo_reacted_'.$reaction.'_'.$post_id, $reaction, time() + (86400 * 30), "/");
			$amount = (int) $amount + 1;
			if ($amount >=0) {
				echo "Amount: ".$amount." ";
				update_post_meta($post_id, "geo_reaction_".$reaction, $amount);
			}
		}
		return;
	}

}

function geo_reactions() {
	// Call from templates
	// if (function_exists('geo_reactions')) { geo_reactions() }
	$geo = new Geo_Viral_React();
	echo $geo->renderPlugin();
}
function react_img($img, $size, $slug) {
	$out = '';
	$emoji = (!empty($img))? $img: get_template_directory_uri().'/assets/img/alkis.png';
	if(ot_get_option('geoit_lazy_images') == 'on') {
		$out = 'class="animated geo-lazy" title="'.__('Bu yazıda en çok kullanılan tepki emojisi', 'geo').'" alt="'.$slug.'" data-src="'.$emoji.'" src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" width="'.$size.'" height="'.$size.'"';
	} else {
		$out = 'class="animated" title="'.__('Bu yazıda en çok kullanılan tepki emojisi', 'geo').'" alt="'.$slug.'" src="'.$emoji.'" width="'.$size.'" height="'.$size.'"';
	}
	return $out;
}
function geo_reaction_badge($post_id) {
	
	if (ot_get_option('geo_react_status') == 'on') {
		if (ot_get_option('geo_post_emoji_show') == 'on') {
			$reaction = ot_get_option('geoit_create_reaction_emoji');		
			$i=0;
			if($reaction) {
				foreach ($reaction as $emoji) {
					$i++; $slug = (!empty($emoji['title']) ? strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '_', $emoji['title']))): 'emoji-'.$i);
					$geo_react[] = [
						'value' => get_post_meta($post_id, 'geo_reaction_'.$slug, true),
						'img'   => $emoji['emoji'],
						'slug'   => $emoji['emoji'],
					];
				}

				$minsayi = '5';

				foreach ($geo_react as $emoji) {
					if($emoji['value'] >= $minsayi){
						echo '<div class="geo_reaction_badge">';
							echo '<img '.react_img($emoji['img'], 20, $slug).' />';
						echo '</div>';
						break;
					}
				}
			}
		
		}
	}
}

new Geo_Viral_React();