<?php
/*-----------------------------------------------------------------------------------*/
# Recipe
/*-----------------------------------------------------------------------------------*/
function geoit_recipe($post) {
	$title = (empty(get_post_meta( $post, 'geo_recipe_title' ,true ))) ? '' : '<h3 class="recipe-title" itemprop="name">'.get_post_meta( $post, 'geo_recipe_title' ,true ).'</h3>';
	$desc = (empty(get_post_meta( $post, 'geo_recipe_esc' ,true ))) ? '' : '<p itemprop="description" class="recipe-description">'.get_post_meta( $post, 'geo_recipe_esc' ,true ).'</p>';
	$servings = (empty(get_post_meta( $post, 'geo_recipe_servings' ,true ))) ? '' : '<div class="recipe-meta-inline"><span class="recipe-meta-label">'.__('Kişi Sayısı', 'geo').'</span><span class="recipe-meta-unit" itemprop="recipeYield">'.get_post_meta( $post, 'geo_recipe_servings' ,true ).'</span></div>';
	$keywords = (empty(get_post_meta( $post, 'geo_recipe_keywords' ,true ))) ? '' : '<span style="display:none" itemprop="keywords">'.get_post_meta( $post, 'geo_recipe_keywords' ,true ).'</span>';
	$cat = (empty(get_post_meta( $post, 'geo_recipe_cat' ,true ))) ? '' : '<span style="display:none" itemprop="recipeCategory">'.get_post_meta( $post, 'geo_recipe_cat' ,true ).'</span>';
	$cuisine = (empty(get_post_meta( $post, 'geo_recipe_cuisine' ,true ))) ? '' : '<span style="display:none" itemprop="recipeCuisine">'.get_post_meta( $post, 'geo_recipe_cuisine' ,true ).'</span>';

	$prep_time = (empty(get_post_meta( $post, 'geo_recipe_prep_time' ,true ))) ? '' : '<div class="recipe-meta-inline"><span class="recipe-meta-label">'.__('Hazırlık Süresi', 'geo').'</span><span class="recipe-meta-unit">'.get_post_meta( $post, 'geo_recipe_prep_time' ,true ).'</span></div>';
	$totalTime = (empty(get_post_meta( $post, 'geo_recipe_prep_totaltime' ,true ))) ? '' : '<meta itemprop="totalTime" content="'.get_post_meta( $post, 'geo_recipe_prep_totaltime' ,true ).'">';
	$prep_time_schema = (empty(get_post_meta( $post, 'geo_recipe_prep_time_schema' ,true ))) ? '' : '<meta itemprop="prepTime" content="'.get_post_meta( $post, 'geo_recipe_prep_time_schema' ,true ).'">';
	
	$cook_time = (empty(get_post_meta( $post, 'geo_recipe_cook_time' ,true ))) ? '' : '<div class="recipe-meta-inline"><span class="recipe-meta-label">'.__('Pişirme Süresi', 'geo').'</span><span class="recipe-meta-unit">'.get_post_meta( $post, 'geo_recipe_cook_time' ,true ).'</span></div>';
	$cook_time_schema = (empty(get_post_meta( $post, 'geo_recipe_cook_time_schema' ,true ))) ? '' : '<meta itemprop="cookTime" content="'.get_post_meta( $post, 'geo_recipe_cook_time_schema' ,true ).'">';
	
	$ingredients = (!empty(get_post_meta( $post, 'geo_recipe_ingredients' ,true ))) ? get_post_meta( $post, 'geo_recipe_ingredients' ,true ) : '';
	$instructions = (!empty(get_post_meta( $post, 'geo_recipe_ingredients' ,true ))) ? get_post_meta( $post, 'geo_recipe_instructions' ,true ) : '';
	$nutritional_inf = (!empty(get_post_meta( $post, 'geo_recipe_ingredients' ,true ))) ? get_post_meta( $post, 'geo_recipe_nutritional_inf' ,true ) : '';
	
	if (!empty($title)) {
		$image_out = '';
		if (has_post_thumbnail() ) {
			$image_id = get_post_thumbnail_id();  
			$image_url = wp_get_attachment_image_src($image_id,'full');  
			$image_url = $image_url[0]; 
			$image_out = '<link itemprop="image" href="'.$image_url.'" />';
		}
		echo '<div class="geoit-recipe" itemscope itemtype="http://schema.org/Recipe">';
			// meta
		  echo $image_out;
			echo '<meta itemprop="datePublished" content="'.get_the_date( 'm-d-Y').'">';
			echo '<meta itemprop="author" content="'.get_the_author().'">';
			echo $totalTime;
			echo $prep_time_schema;
			echo $cook_time_schema;
			echo $title;
			// header
			echo '<div class="geoit-recipe-wrapper">';
				echo '<div class="geoit-recipe-header">';
					echo $desc;

					echo '<div class="recipe-main-meta">';
						echo $servings;
						echo $prep_time;
						echo $cook_time;
						echo $keywords;
						echo $cat;
						echo $cuisine;
					echo '</div>';

				echo '</div>';
				// nutritions
				if ($nutritional_inf != '') {
					$n_scope = '';
					if ($nutritional_inf[0]['type'] != '' )
						$n_scope = 'itemprop="nutrition" itemscope itemtype="https://schema.org/NutritionInformation"';
					echo '<div class="geoit-nutritions-table">';
						echo '<h3 class="geoit-nutritions-title">'.__('Beslenme Bilgileri', 'geo').'</h3>';
						echo '<div class="geoit-nutrition-table-inner" '.$n_scope.'>';
							foreach ($nutritional_inf as $item) {
								$n_type = '';
								if ($item['type'] != '') {
									$n_type = 'itemprop="'.$item['type'].'"';
								}
								echo '<div class="geoit-nutrition-item">';
									if($item['title'] != '')
										echo '<span class="nutrition-item-label">'.$item['title'].'</span>';
									if($item['value'] != '')
										echo '<span class="nutrition-item-value" '.$n_type.'>'.$item['value'].'</span>';
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				}
				// ingredients 
				if ($ingredients != '') {
					echo '<h3 class="geoit-ingredients-header">'.__('Malzemeler', 'geo').'</h3>';
					echo '<ul class="geoit-ingredients-items">';
						foreach($ingredients as $item) {
							echo '<li itemprop="recipeIngredient" class="geoit-ingredients-item">';
								if($item['title'] != '')
									echo $item['title'];
							echo '</li>';
						}
					echo '</ul>';
				}
				// Instructions
				if ($instructions != '') {
					echo '<div class="geoit-recipe-instructions">';
						echo '<h3 class="geoit-recipe-instructions-title">'.__('Hazırlanış', 'geo').'</h3>';
						$counter = 0;
						foreach ($instructions as $item) {
							$counter++;
							echo '<div class="geoit-recipe-instructions-item">';
								echo '<div class="geoit-recipe-instructions-counter">'.$counter.'</div>';
								if($item['desc'] != '')
									echo '<p itemprop="recipeInstructions">'.$item['desc'].'</p>';
								if($item['image'] != '')
									echo '<img src="'.$item['image'].'" />';
							echo '</div>';
						}
					echo '</div>';
				}
				echo ' <div itemprop="interactionStatistic" itemscope itemtype="https://schema.org/InteractionCounter">
			<meta itemprop="interactionType" content="https://schema.org/CommentAction" />
			<meta itemprop="userInteractionCount" content="'.get_comments_number($post).'" />
		</div>';
			echo '</div>';
		echo '</div>';
	}
}