<?php
/*-----------------------------------------------------------------------------------*/
/*	Calculate Score
/*-----------------------------------------------------------------------------------*/

function geo_calculate_score($num, $type, $star = false) {
		
		switch ($type) :
					
			case 'number';
				$output = $num;
				break;
			
		endswitch;
		
		return $output;
}


/*-----------------------------------------------------------------------------------*/
/*	Review System Box
/*-----------------------------------------------------------------------------------*/

function geo_print_review_box($post_id, $echo = true) {
		
		$review_box_title = get_post_meta( $post_id, 'geo_' . 'review_box_title', true );
		$review_box_total_score_label = get_post_meta( $post_id, 'geo_' . 'review_box_total_score_label', true );
		$review_summary = get_post_meta( $post_id, 'geo_' . 'review_summary', true );
		$review_thumb = get_post_meta( $post_id, 'geo_' . 'review_box_thumb', true );
		
		$rating_type = 'number';
		$rating_criteria = get_post_meta( $post_id, 'geo_' . 'rating_criteria', true );
		$rating_criteria_count =  count($rating_criteria);
		$author = get_the_author();
		$pfx_date = get_the_date();

		$score_array = array();
			foreach ($rating_criteria as $criteria) {
				$score_array []= $criteria['score'];
			}
			$final_score = array_sum($score_array);
			$final_score = $final_score / $rating_criteria_count;
			$final_score = number_format($final_score, 1, '.', '');
			$times = get_the_time('c');
		$output = '';
		$output .= '<div id="review-box" itemscope itemtype="http://schema.org/Review">';
		$output .= '<span class="reviewer" itemprop="author" style="display:none;">'.$author.'</span>';
		$output .= '<time class="dtreviewed" itemprop="datePublished" content="'.$times.'" style="display:none;">'.$pfx_date.'</time>';
		$output .= '<span class="summary" itemprop="description" style="display:none;">'.$review_summary.'</span>';
		$output .= '<div style="display: none;" itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">';
		$output .= '<span class="rating" itemprop="ratingValue">'. geo_calculate_score($final_score, true).'';
		$output .= '<span itemprop="worstRating">1</span>';
		$output .= '<span itemprop="bestRating">10</span>';
		$output .= '</span>';
		$output .= '</div>';
		$output .= ($review_thumb) ? '<div class="review-box-image" style="background-image: url('.$review_thumb.')"></div>' : '';
		$output .= '<div class="review-top">';
		$output .= '<div class="overall-score">';
		$output .= '<span class="overall">'. geo_calculate_score($final_score, $rating_type, true).'</span>';
		// $output .= '<span class="overall-text">' . __( 'Ortalama Puan' , 'geo' ) . '</span>';
		$output .= '</div>';
		$output .= '<div class="review-text">';
		$output .= '<span itemprop="itemreviewed" class="review-title">'.$review_box_title.'</span>';
		$output .= '<p>'.$review_summary.'</p>';
		$output .= '</div>';
		$output .= '</div>';
		$output .= '<ul>';
			foreach ($rating_criteria as $criteria) {
				$percentage_score = $criteria['score'] * 10;
				$criteria_label = '';
				if(isset($criteria['c_label'])) {
					$criteria_label = $criteria['c_label'];
				} else {
					$criteria_label = $criteria['title'];
				}
				if ($criteria_label != '')
				$output .= '<li><span class="legeo">'.$criteria_label.'</span> <span class="right">'.geo_calculate_score($criteria['score'], $rating_type, true).'</span><div class="review-criteria-bar-container"><div class="review-criteria-bar" style="width:'.$percentage_score.'%"></div></div></li>';
			}
		$output .= '</ul>';
    
		$output .= '</div>';
		
		if($echo == 'true') :
		echo $output;
		else :
		return $output;
		endif;
}


/*-----------------------------------------------------------------------------------*/
/*	Display Review Badge
/*-----------------------------------------------------------------------------------*/

function geo_print_review_badge($post_id, $echo = true) {
		if(get_post_meta( $post_id, 'geo_enable_review', true ) != 'true' && get_post_meta( $post_id, 'geo_enable_review', true ) != 'on')
			return;
		$rating_type = get_post_meta( $post_id, 'geo_' . 'rating_type', true );
		$rating_criteria = get_post_meta( $post_id, 'geo_' . 'rating_criteria', true );
		$rating_criteria_count =  count($rating_criteria);
		
		$output = '';
		$score_array = array();
		
		if($rating_criteria){
			foreach ($rating_criteria as $criteria) {
				$score_array []= $criteria['score'];
				
			}
		}
		
		$final_score = array_sum($score_array);
		$final_score = $final_score / $rating_criteria_count;
		$final_score = number_format($final_score, 1, '.', '');
		$percentage_score = $final_score * 10;
		$output = '<div style="min-width: '.$percentage_score.'%" class="geo-review-badge review-badge-'.$rating_type.'"><span>'.geo_calculate_score($final_score, $rating_type, true).'</span></div>';
    
		if($echo == 'true' || $echo == 'on') :
		echo $output;
		else :
		return $output;
		endif;
}

